/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/log"})
public class LogController {
    private static final Log _logger = LogFactory.getLog(LogController.class);

    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void logFromClient(@RequestBody Map<String, String> args) throws Exception {
        String level = args.get("level");
        String message = args.get("message");
        Validate.notEmpty((CharSequence)level);
        Validate.notEmpty((CharSequence)message);
        message = "[H5_CLIENT]" + message;
        switch (level) {
            case "error": {
                _logger.error((Object)message);
                break;
            }
            case "warn": {
                _logger.warn((Object)message);
                break;
            }
            case "info": {
                _logger.info((Object)message);
                break;
            }
            case "debug": {
                _logger.debug((Object)message);
                break;
            }
            case "trace": {
                _logger.trace((Object)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Log level not supported.");
            }
        }
    }
}

