/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.util.client.configuration.ConfigurationPayload;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/configuration"})
public class ConfigurationServiceController {
    private final ConfigurationService _configurationService;
    private static final List<String> CONFIGURATION_KEY_BLACKLIST = new ArrayList<String>(){
        {
            this.add("intercom.*");
            this.add("segment.*");
        }
    };
    private static final String HIDDEN_VALUE = "<hidden>";

    @Autowired
    public ConfigurationServiceController(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public final ConfigurationPayload getConfiguration() throws Exception {
        ConfigurationPayload configuration = this._configurationService.getConfiguration();
        return this.hideSensitiveConfigProperties(configuration);
    }

    private ConfigurationPayload hideSensitiveConfigProperties(ConfigurationPayload configuration) {
        ConfigurationPayload filteredConfiguration = new ConfigurationPayload();
        filteredConfiguration.featureStates = configuration.featureStates;
        filteredConfiguration.configParams = new HashMap();
        for (Map.Entry entry : configuration.configParams.entrySet()) {
            Object key = entry.getKey();
            if (this.checkForBlackListedKeyMatch(key)) {
                filteredConfiguration.configParams.put(key, HIDDEN_VALUE);
                continue;
            }
            filteredConfiguration.configParams.put(key, entry.getValue());
        }
        return filteredConfiguration;
    }

    private boolean checkForBlackListedKeyMatch(Object key) {
        for (String blackListedKey : CONFIGURATION_KEY_BLACKLIST) {
            if (!key.toString().matches(blackListedKey)) continue;
            return true;
        }
        return false;
    }
}

