/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.ActionMenuItem;
import com.vmware.vise.actionsfw.ActionMenusRequestSpec;
import com.vmware.vise.actionsfw.ActionToolbarRequestSpec;
import com.vmware.vise.actionsfw.ActionsRequestSpec;
import com.vmware.vise.actionsfw.ActionsService;
import com.vmware.vise.actionsfw.RequestPolicy;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.actions.model.EvaluatedMenus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/actionsService"})
public class ActionsServiceController {
    private static final Log _logger = LogFactory.getLog(ActionsServiceController.class);
    private final ActionsService _actionsService;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public ActionsServiceController(ActionsService actionService, @Qualifier(value="objectReferenceService") ObjectReferenceService refService) {
        this._actionsService = actionService;
        this._objectReferenceService = refService;
    }

    @RequestMapping(value={"/toolbar"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionMenuItem> getToolbarActions(@RequestParam(value="listViewId", required=true) String listViewId, @RequestParam(value="targetUids", required=false) String[] targetUids) {
        ActionToolbarRequestSpec toolbarSpec = new ActionToolbarRequestSpec();
        toolbarSpec.listViewId = listViewId;
        ActionContext context = new ActionContext();
        List<Object> targets = this.getObjectRefsForTargets(targetUids);
        context.setTargetObjects(targets);
        toolbarSpec.context = context;
        List result = this._actionsService.getToolbarActions(toolbarSpec);
        return result;
    }

    @RequestMapping(value={"/menu"}, method={RequestMethod.POST})
    @ResponseBody
    public ActionMenuItem getOrBuildMenu(@RequestParam(value="menuType", required=true) String menuType, @RequestBody(required=false) String[] targetUids) {
        Validate.notNull((Object)menuType);
        ActionMenusRequestSpec menuSpec = new ActionMenusRequestSpec();
        menuSpec.menuTypes = Arrays.asList(StringUtils.stripAll((String[])menuType.split(",")));
        ActionContext context = new ActionContext();
        List<Object> targets = this.getObjectRefsForTargets(targetUids);
        context.setTargetObjects(targets);
        menuSpec.context = context;
        ActionMenuItem result = this._actionsService.getOrBuildMenu(menuSpec);
        return result;
    }

    @RequestMapping(value={"/actions/descriptions/{actionUid:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public Action getAction(@PathVariable(value="actionUid") String actionUid) {
        Validate.notBlank((CharSequence)actionUid, (String)"Action identifer must not be null or empty.", (Object[])new Object[0]);
        ActionsRequestSpec spec = new ActionsRequestSpec();
        spec.actionUids = Arrays.asList(actionUid);
        List actions = this._actionsService.getActions(spec, false);
        Validate.notEmpty((Collection)actions, (String)("No Action registered with ID " + actionUid), (Object[])new Object[0]);
        assert (actions.size() == 1) : "Received more than one action with ID " + actionUid;
        return (Action)actions.get(0);
    }

    @RequestMapping(value={"/actions/descriptions"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Action> getActions(@RequestParam(value="actionUids", required=false) String[] actionUids, @RequestParam(value="targetTypes", required=false) String targetTypes, @RequestParam(value="globalActions", required=false) String globalActions) {
        ActionsRequestSpec spec = new ActionsRequestSpec();
        spec.actionUids = Arrays.asList(actionUids);
        spec.targetTypes = Arrays.asList(StringUtils.stripAll((String[])targetTypes.split(",")));
        if (StringUtils.isNotBlank((CharSequence)globalActions)) {
            spec.globalActions = RequestPolicy.valueOf((String)globalActions.toUpperCase());
        }
        List result = this._actionsService.getActions(spec, false);
        return result;
    }

    @RequestMapping(value={"/actions/evaluations/{actionUid:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public ActionEvaluation getActionEvaluation(@PathVariable(value="actionUid") String actionUid, @RequestParam(value="targetUids", required=false) String[] targetUids) throws Exception {
        Validate.notBlank((CharSequence)actionUid, (String)"Action identifer must not be null or empty.", (Object[])new Object[0]);
        ActionContext context = new ActionContext();
        context.setTargetObjects(this.getObjectRefsForTargets(targetUids));
        ActionsRequestSpec spec = new ActionsRequestSpec();
        spec.context = context;
        spec.actionUids = Arrays.asList(actionUid);
        List evals = this._actionsService.getEvaluatedActions(spec, false);
        Validate.notEmpty((Collection)evals, (String)("No Action registered with ID " + actionUid), (Object[])new Object[0]);
        assert (evals.size() == 1) : "Found more than one action with ID " + actionUid;
        return (ActionEvaluation)evals.get(0);
    }

    @RequestMapping(value={"/actions/evaluations"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ActionEvaluation> getActionEvaluations(@RequestParam(value="actionUids", required=false) String[] actionUids, @RequestParam(value="globalActions", required=false) String globalActions, @RequestParam(value="skipActionFilteringStage", required=false, defaultValue="false") boolean skipActionFilteringStage, @RequestBody(required=false) String[] targetUids) throws Exception {
        ActionContext context = new ActionContext();
        List<Object> targets = this.getObjectRefsForTargets(targetUids);
        context.setTargetObjects(targets);
        ActionsRequestSpec spec = new ActionsRequestSpec();
        spec.context = context;
        if (ArrayUtils.isNotEmpty((Object[])actionUids)) {
            spec.actionUids = Arrays.asList(actionUids);
        }
        if (StringUtils.isNotEmpty((CharSequence)globalActions)) {
            spec.globalActions = RequestPolicy.valueOf((String)globalActions.toUpperCase());
        }
        List<ActionEvaluation> result = Collections.emptyList();
        try {
            return this._actionsService.getEvaluatedActions(spec, skipActionFilteringStage);
        }
        catch (ManagedObjectNotFound ex) {
            _logger.debug((Object)"Unable to find object", (Throwable)ex);
            return result;
        }
    }

    @RequestMapping(value={"/menus"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionMenuItem> getMenus() {
        ActionMenusRequestSpec spec = new ActionMenusRequestSpec();
        List result = this._actionsService.getMenus(spec);
        return result;
    }

    @RequestMapping(value={"/menus/{menuType:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionMenuItem> getMenus(@PathVariable(value="menuType") String menuType, @RequestParam(value="targetUids", required=false) String[] targetUids) {
        Validate.notBlank((CharSequence)menuType, (String)"Menu type must not be null or empty.", (Object[])new Object[0]);
        ActionMenusRequestSpec spec = new ActionMenusRequestSpec();
        spec.menuTypes = Arrays.asList(StringUtils.stripAll((String[])menuType.split(",")));
        if (ArrayUtils.isEmpty((Object[])targetUids)) {
            return this._actionsService.getMenus(spec);
        }
        List<ActionMenuItem> result = this.getApplicableMenus(targetUids, spec);
        return result;
    }

    @RequestMapping(value={"/menus/{menuIds:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public EvaluatedMenus getEvaluatedMenus(@PathVariable(value="menuIds") String menuIds, @RequestBody(required=false) String[] targetUids) throws Exception {
        ActionMenusRequestSpec getMenusSpec = new ActionMenusRequestSpec();
        getMenusSpec.menuIds = Arrays.asList(StringUtils.stripAll((String[])menuIds.split(",")));
        List<ActionMenuItem> menus = ArrayUtils.isEmpty((Object[])targetUids) ? this._actionsService.getMenus(getMenusSpec) : this.getApplicableMenus(targetUids, getMenusSpec);
        ActionsRequestSpec getActionEvaluationsSpec = new ActionsRequestSpec();
        getActionEvaluationsSpec.actionUids = new ArrayList();
        getActionEvaluationsSpec.context = getMenusSpec.context;
        for (ActionMenuItem menu : menus) {
            getActionEvaluationsSpec.actionUids.addAll(this.extractActionIds(menu));
        }
        List evaluations = null;
        if (!(menus.isEmpty() || targetUids != null && targetUids.length != 1)) {
            evaluations = this._actionsService.getEvaluatedActions(getActionEvaluationsSpec, true);
        }
        return new EvaluatedMenus(menus, evaluations);
    }

    @RequestMapping(value={"/menus/{menuType:.*}/{menuUid:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public ActionMenuItem getMenu(@PathVariable(value="menuType") String menuType, @PathVariable(value="menuUid") String menuUid, @RequestParam(value="targetUids", required=false) String[] targetUids) {
        Validate.notBlank((CharSequence)menuType, (String)"Menu type must not be null or whitespace.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)menuUid, (String)"Menu uid must not be null or whitespace.", (Object[])new Object[0]);
        ActionMenusRequestSpec spec = new ActionMenusRequestSpec();
        spec.menuTypes = Arrays.asList(menuType);
        spec.menuIds = Arrays.asList(menuUid);
        List<ActionMenuItem> menus = ArrayUtils.isEmpty((Object[])targetUids) ? this._actionsService.getMenus(spec) : this.getApplicableMenus(targetUids, spec);
        if (menus.size() > 1) {
            _logger.warn((Object)("More than one menu registered with uid " + menuUid));
        }
        return menus.get(0);
    }

    private List<ActionMenuItem> getApplicableMenus(String[] targetUids, ActionMenusRequestSpec spec) {
        ActionContext context = new ActionContext();
        List<Object> targets = this.getObjectRefsForTargets(targetUids);
        context.setTargetObjects(targets);
        spec.context = context;
        return this._actionsService.getMenus(spec);
    }

    private List<Object> getObjectRefsForTargets(String[] targetIds) {
        if (ArrayUtils.isEmpty((Object[])targetIds)) {
            return null;
        }
        ArrayList<Object> refs = new ArrayList<Object>(targetIds.length);
        for (String target : targetIds) {
            Object ref = this._objectReferenceService.getReference(target, true);
            if (ref == null) {
                _logger.warn((Object)("Object " + target + " could not be found."));
                continue;
            }
            refs.add(ref);
        }
        return refs;
    }

    private Collection<String> extractActionIds(ActionMenuItem menu) {
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add(menu.getId());
        if (menu.getChildren() != null) {
            for (ActionMenuItem subItem : menu.getChildren()) {
                actionIds.addAll(this.extractActionIds(subItem));
            }
        }
        return actionIds;
    }
}

