/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.util;

import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.vim.vslm.InfrastructureObjectPolicy;
import com.vmware.vim.binding.vim.vslm.vcenter.VStorageObjectManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VStorageObjectManagerUtil {
    private static final Log _logger = LogFactory.getLog(VStorageObjectManagerUtil.class);

    public static VStorageObjectManager getVStorageObjectManager(String vcGuid) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)vcGuid);
        ManagedObjectReference vStorageObjectManagerRef = vcService.getServiceInstanceContent().vStorageObjectManager;
        if (vStorageObjectManagerRef != null) {
            return (VStorageObjectManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vStorageObjectManagerRef);
        }
        return null;
    }

    public static ProfileId getFcdNamespaceProfileForDatastore(ManagedObjectReference dsRef) throws Exception {
        try {
            InfrastructureObjectPolicy[] infrastructureObjectPolicies;
            VStorageObjectManager vStorageObjectManager = VStorageObjectManagerUtil.getVStorageObjectManager(dsRef.getServerGuid());
            if (vStorageObjectManager != null && (infrastructureObjectPolicies = vStorageObjectManager.retrieveVStorageInfrastructureObjectPolicy(dsRef)) != null) {
                for (InfrastructureObjectPolicy objPolicy : infrastructureObjectPolicies) {
                    if (objPolicy == null || objPolicy.profileId == null || objPolicy.profileId.isEmpty()) continue;
                    ProfileId profileId = new ProfileId();
                    profileId.uniqueId = objPolicy.profileId;
                    return profileId;
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve FCD namespace profile.", (Throwable)ex);
        }
        return null;
    }
}

