/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.host.Capability;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.ResignatureRescanResult;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vim.host.UnresolvedVmfsResolutionResult;
import com.vmware.vim.binding.vim.host.UnresolvedVmfsResolutionSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreExpandSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreExtendSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreOption;
import com.vmware.vim.binding.vim.host.VmfsDatastoreSpec;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.storage.DatastoreCreateSpec;
import com.vmware.vsphere.client.storage.DatastoreIncreaseSpec;
import com.vmware.vsphere.client.storage.DatastoreRefreshSpec;
import com.vmware.vsphere.client.storage.MoveOutFromDsClusterQueryObject;
import com.vmware.vsphere.client.storage.MoveOutFromDsClusterSpec;
import com.vmware.vsphere.client.storage.NfsDatastoreCreateSpec;
import com.vmware.vsphere.client.storage.StorageDataService;
import com.vmware.vsphere.client.storage.VmfsDatastoreCreateSpec;
import com.vmware.vsphere.client.storage.VmfsDatastoreHostsMountSpec;
import com.vmware.vsphere.client.storage.VmfsDatastoreResignatureSpec;
import com.vmware.vsphere.client.storage.VmfsDatastoreUnmapPrioritySpec;
import com.vmware.vsphere.client.storage.VmfsDatastoreUnmountSpec;
import com.vmware.vsphere.client.storage.VmfsDatastoreUpgradeSpec;
import com.vmware.vsphere.client.storage.VmfsDatastoreUpgradeValidationSpec;
import com.vmware.vsphere.client.storage.VmfsForceMountSpec;
import com.vmware.vsphere.client.storage.maintenance.DatastoreMaintenanceSpec;
import com.vmware.vsphere.client.storage.maintenance.impl.DatastoreMaintenanceOpUtil;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import com.vmware.vsphere.client.storage.vvol.CreateVvolDatastoreSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DatastoreMutationProvider.class);
    private static final String HOST_SUPPORTED_VMFS_VERSION_PROPERTY = "capability.supportedVmfsMajorVersion";
    private static final String HOST_NAME_PROPERTY = "name";
    private static final String DATASTORE_INFO_PROPERTY = "info";
    private static final String DATASTORE_VMFS_UUID_PROPERTY = "info[@type='VmfsDatastoreInfo'].vmfs.uuid";
    private static final String HOST_MOUNT_PROPERTY = "hostMount";
    private static final String DATASTORE_CONNECTED_HOST_PROPERTY = "connectedHost";
    private DataService _dataService;
    private LegacyAuthorizationService _authorizationService;
    private TaskMonitor _taskMonitor;
    private StorageDataService _storageDataService;

    public DatastoreMutationProvider(LegacyAuthorizationService authorizationService, DataService dataService, TaskMonitor taskMonitor, StorageDataService storageDataService) {
        this._authorizationService = authorizationService;
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._storageDataService = storageDataService;
    }

    public OperationResult add(VmfsDatastoreCreateSpec spec) {
        return this.addInternal(spec);
    }

    public OperationResult add(NfsDatastoreCreateSpec spec) {
        return this.addInternal(spec);
    }

    public OperationResult add(CreateVvolDatastoreSpec spec) {
        return this.addInternal(spec);
    }

    public OperationResult add(VmfsForceMountSpec spec) {
        return this.addInternal(spec);
    }

    public OperationResult add(VmfsDatastoreResignatureSpec spec) {
        return this.addInternal(spec);
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, StorageResourceManager.IORMConfigSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = datastoreRef;
        if (datastoreRef == null) {
            _logger.error((Object)"Configure datastore IORM: datastore can't be null.");
            opResult.error = StorageUtil.getFault("error.invalidDatastore");
            return opResult;
        }
        try {
            ServiceInstanceContent serviceContent = StorageUtil.getServiceInstanceContent(datastoreRef);
            StorageResourceManager storageResourceManager = (StorageResourceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.storageResourceManager);
            opResult.task = storageResourceManager.ConfigureDatastoreIORM(datastoreRef, spec);
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
            _logger.error((Object)"Failed to configure datastore I/O resource management.", (Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, DatastoreRefreshSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = datastoreRef;
        if (datastoreRef == null) {
            _logger.error((Object)"Refresh datastore: datastore can't be null.");
            opResult.error = StorageUtil.getFault("error.invalidDatastore");
            return opResult;
        }
        try {
            Datastore datastore = (Datastore)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datastoreRef);
            datastore.refreshStorageInfo();
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
            _logger.error((Object)"Failed to refresh datastore info.", (Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference datastore, DatastoreIncreaseSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = datastore;
        if (datastore == null) {
            _logger.error((Object)"increaseVmfsDatastore: datastore can't be null.");
            opResult.error = StorageUtil.getFault("error.invalidDatastore");
            return opResult;
        }
        if (!DatastoreMutationProvider.validateDatastoreIncreaseSpec(spec, opResult)) {
            return opResult;
        }
        try {
            DatastoreSystem datastoreSystem = this._storageDataService.getHostDatastoreSystem(spec.host);
            if (datastoreSystem == null) {
                _logger.error((Object)"increaseDatastore: Failed to retrieve datastoreSystem for host.");
                opResult.error = StorageUtil.getFault("error.failedToRetrieveHostInfo");
                return opResult;
            }
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(spec.host);
            if (storageSystem == null) {
                _logger.error((Object)"increaseDatastore: Failed to retrieve storageSystem for host.");
                opResult.error = StorageUtil.getFault("error.failedToRetrieveHostInfo");
                return opResult;
            }
            if (spec.increaseOption.spec instanceof VmfsDatastoreExtendSpec) {
                opResult.result = DatastoreMutationProvider.addNewExtentToDatastore(datastoreSystem, storageSystem, datastore, spec);
            } else if (spec.increaseOption.spec instanceof VmfsDatastoreExpandSpec) {
                opResult.result = DatastoreMutationProvider.expandDatastoreExtent(datastoreSystem, storageSystem, datastore, spec);
            }
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
            _logger.error((Object)"Failed to increase datastore capacity.", (Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference host, VmfsDatastoreUnmountSpec spec) {
        ManagedObjectReference[] hosts = new ManagedObjectReference[]{host};
        OperationResult[] opResults = this.applyOnMultiEntity(hosts, spec);
        return opResults[0];
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] hosts, VmfsDatastoreUnmountSpec spec) {
        OperationResult[] opResults = new OperationResult[1];
        if (spec == null) {
            String errorText = StorageUtil.getLocalizedString("error.vmfsDsUnmountSpecInvalid");
            _logger.error((Object)errorText);
            opResults[0] = new OperationResult();
            opResults[0].error = new MethodFault(errorText);
            return opResults;
        }
        if (!this.validateUnmountAndMountSpecs(hosts, spec.datastoreToUnmount, opResults)) {
            return opResults;
        }
        String vmfsUuid = this.getVmfsUuidForDatastore(spec.datastoreToUnmount, opResults);
        if (vmfsUuid == null) {
            return opResults;
        }
        return this.mountOrUnmountDatastoreFromHosts(hosts, vmfsUuid, false, spec.datastoreToUnmount);
    }

    public OperationResult apply(ManagedObjectReference host, VmfsDatastoreHostsMountSpec spec) {
        ManagedObjectReference[] hosts = new ManagedObjectReference[]{host};
        OperationResult[] opResults = this.applyOnMultiEntity(hosts, spec);
        return opResults[0];
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] hosts, VmfsDatastoreHostsMountSpec spec) {
        OperationResult[] opResults = new OperationResult[1];
        if (spec == null) {
            String errorText = StorageUtil.getLocalizedString("error.vmfsDsMountSpecInvalid");
            _logger.error((Object)errorText);
            opResults[0] = new OperationResult();
            opResults[0].error = new MethodFault(errorText);
            return opResults;
        }
        if (!this.validateUnmountAndMountSpecs(hosts, spec.datastoreToMount, opResults)) {
            return opResults;
        }
        String vmfsUuid = this.getVmfsUuidForDatastore(spec.datastoreToMount, opResults);
        if (vmfsUuid == null) {
            return opResults;
        }
        return this.mountOrUnmountDatastoreFromHosts(hosts, vmfsUuid, true, spec.datastoreToMount);
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] datastoreRefs, MoveOutFromDsClusterSpec spec) {
        return this.moveDatastoresOutOfDsCluster(datastoreRefs);
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, VmfsDatastoreUnmapPrioritySpec spec) throws Exception {
        OperationResult result = new OperationResult();
        if (spec == null) {
            String errorText = StorageUtil.getLocalizedString("error.vmfsDsUnmapPrioritySpecInvalid");
            _logger.error((Object)errorText);
            result = new OperationResult();
            result.error = new MethodFault(errorText);
            return result;
        }
        if (datastoreRef != null && spec.hostRef != null && spec.vmfsUuid != null && spec.unmapPriority != null) {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(spec.hostRef);
            if (storageSystem == null) {
                _logger.error((Object)"editSpaceReclamationPriority: Failed to retrieve storageSystem for host.");
                result.error = StorageUtil.getFault("error.failedToRetrieveHostInfo");
                return result;
            }
            storageSystem.updateVmfsUnmapPriority(spec.vmfsUuid, spec.unmapPriority);
            result.entity = datastoreRef;
            result.result = spec.unmapPriority;
        }
        return result;
    }

    public OperationResult[] applyOnMultiEntityDeferred(ManagedObjectReference[] dsRefs, StorageResourceManager.IORMConfigSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        OperationResult[] results = new OperationResult[dsRefs.length];
        OperationResult result = null;
        ManagedObjectReference schTaskRef = null;
        String origTaskName = scheduleSpec.name;
        for (int i = 0; i < dsRefs.length; ++i) {
            result = new OperationResult();
            try {
                scheduleSpec.name = SchedulingUtil.formatTaskNameForBatch((String)origTaskName, (int)i, (int)dsRefs.length);
                schTaskRef = scheduleSpec.scheduledTask != null ? this.editScheduleTaskForConfigureSIOC(dsRefs[i], spec, scheduleSpec) : this.createScheduleTaskForConfigureSIOC(dsRefs[i], spec, scheduleSpec);
                result.entity = schTaskRef;
            }
            catch (Exception ex) {
                _logger.error((Object)"Could not update the scheduled task for Configure SIOC", (Throwable)ex);
                result.error = MixedUtil.getMethodFault((Throwable)ex);
            }
            results[i] = result;
        }
        return results;
    }

    public OperationResult apply(ManagedObjectReference dsRef, VmfsDatastoreUpgradeSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = dsRef;
        try {
            Datastore.HostMount hostMount = null;
            try {
                hostMount = this.getConnectedAndAuthorizedHostMountForDatastore(dsRef);
            }
            catch (Exception ex) {
                _logger.error((Object)("DatastoreMutationProvider: Error when retrieving mountInfo for datastore: [" + dsRef + "]"), (Throwable)ex);
                opResult.error = new MethodFault(ex.getMessage());
                return opResult;
            }
            if (hostMount == null) {
                _logger.warn((Object)("DatastoreMutationProvider: Error when retrieving mountInfo for datastore: [" + dsRef + "]. Result is null."));
                return opResult;
            }
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostMount.key);
            storageSystem.upgradeVmfs(hostMount.mountInfo.path);
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during UpgradeVmfsDatastore:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, DatastoreMaintenanceSpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.maintenanceSpecInvalid"));
        }
        return DatastoreMaintenanceOpUtil.applyMaintenanceOperation(datastoreRef, spec);
    }

    public ValidationResult[] validateOnMultiEntity(Object[] entities, VmfsDatastoreUpgradeValidationSpec spec) {
        ValidationResult[] result = new ValidationResult[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            Object datastore = entities[i];
            ValidationResult dsResult = new ValidationResult();
            dsResult.entity = datastore;
            Datastore.HostMount hostMount = null;
            try {
                hostMount = this.getConnectedAndAuthorizedHostMountForDatastore((ManagedObjectReference)datastore);
            }
            catch (Exception ex) {
                _logger.error((Object)("DatastoreMutationProvider: Error when retrieving mountInfo for datastore: [" + datastore + "]"), (Throwable)ex);
            }
            if (hostMount == null) {
                _logger.warn((Object)("DatastoreMutationProvider: Datastore [" + datastore + "]. doesnot have a valid hostMount. User is either missing privileges or hosts aredisconnected."));
                String message = StorageUtil.getLocalizedString("error.invalidHostMountForUser");
                dsResult.result = new String[]{message};
                result[i] = dsResult;
                continue;
            }
            PropertyValue[] hostProperties = null;
            try {
                hostProperties = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)datastore, (String)"hostKey", (String)"HostSystem", (String[])new String[]{HOST_SUPPORTED_VMFS_VERSION_PROPERTY, HOST_NAME_PROPERTY});
            }
            catch (Exception ex) {
                _logger.error((Object)("DatastoreMutationProvider: Error when retrieving supportedVmfsMajorVersion & name for host connected to datastore: [" + datastore + "]"), (Throwable)ex);
            }
            if (hostProperties != null) {
                HashMap<ManagedObjectReference, PropertyValue[]> hostPropertiesHashMap = new HashMap<ManagedObjectReference, PropertyValue[]>();
                for (PropertyValue hostValue : hostProperties) {
                    if (hostPropertiesHashMap.get(hostValue.resourceObject) == null) {
                        hostPropertiesHashMap.put((ManagedObjectReference)hostValue.resourceObject, new PropertyValue[2]);
                    }
                    if (hostValue.propertyName.equals(HOST_SUPPORTED_VMFS_VERSION_PROPERTY)) {
                        ((PropertyValue[])hostPropertiesHashMap.get((Object)hostValue.resourceObject))[0] = hostValue;
                        continue;
                    }
                    if (!hostValue.propertyName.equals(HOST_NAME_PROPERTY)) continue;
                    ((PropertyValue[])hostPropertiesHashMap.get((Object)hostValue.resourceObject))[1] = hostValue;
                }
                ArrayList<PropertyValue> resultList = new ArrayList<PropertyValue>();
                for (ManagedObjectReference host : hostPropertiesHashMap.keySet()) {
                    PropertyValue[] hostPropertiesArray = (PropertyValue[])hostPropertiesHashMap.get(host);
                    if (StorageUtil.hostSupportsVmfs5((int[])hostPropertiesArray[0].value)) continue;
                    resultList.add(hostPropertiesArray[1]);
                }
                if (resultList.size() != 0) {
                    Object[] resultArray = new Object[resultList.size()];
                    dsResult.result = resultList.toArray(resultArray);
                } else {
                    dsResult.result = null;
                }
            } else {
                String message = StorageUtil.getLocalizedString("error.failedToRetrieveHostInfo");
                _logger.error((Object)("DatastoreMutationProvider: Error when retrieving supportedVmfsMajorVersion & name for host connected to datastore: [" + datastore + "]. Result is null."));
                dsResult.result = new String[]{message};
            }
            result[i] = dsResult;
        }
        return result;
    }

    private Datastore.HostMount getConnectedAndAuthorizedHostMountForDatastore(ManagedObjectReference dsRef) throws Exception {
        Datastore.HostMount[] hostMounts;
        for (Datastore.HostMount hostMount : hostMounts = (Datastore.HostMount[])QueryUtil.getProperty((DataService)this._dataService, (Object)dsRef, (String)HOST_MOUNT_PROPERTY)) {
            if (hostMount == null || !StorageUtil.isHostConnected(hostMount.key).booleanValue() || !this._authorizationService.checkPrivileges(new ManagedObjectReference[]{hostMount.key}, new String[]{"Host.Config.Storage"})) continue;
            return hostMount;
        }
        return null;
    }

    private OperationResult addInternal(DatastoreCreateSpec spec) {
        OperationResult opResult = new OperationResult();
        if (!DatastoreMutationProvider.validateDatastoreCreateSpec(spec, opResult)) {
            return opResult;
        }
        opResult.entity = spec.host;
        OperationEffect opEffect = OperationEffect.newDelayedEffect();
        opEffect.affectedEntites = new Object[]{spec.host};
        opResult.effect = opEffect;
        try {
            if (spec instanceof NfsDatastoreCreateSpec) {
                opResult.result = this._storageDataService.getHostDatastoreSystem(spec.host).createNasDatastore(((NfsDatastoreCreateSpec)spec).nfsDatastoreCreateSpec);
            } else if (spec instanceof VmfsDatastoreCreateSpec) {
                opResult.result = this.addVmfsDatastore((VmfsDatastoreCreateSpec)spec);
            } else if (spec instanceof VmfsForceMountSpec) {
                UnresolvedVmfsResolutionSpec[] resolutionSpecs = new UnresolvedVmfsResolutionSpec[]{((VmfsForceMountSpec)spec).vmfsDatastoreForceMountSpec};
                UnresolvedVmfsResolutionResult resolutionResult = this._storageDataService.getHostStorageSystem(spec.host).resolveMultipleUnresolvedVmfsVolumes(resolutionSpecs)[0];
                if (resolutionResult.fault != null) {
                    throw resolutionResult.fault;
                }
                opResult.result = this.getDatastoreByUuid(spec.host, resolutionResult.vmfs.uuid);
            } else if (spec instanceof VmfsDatastoreResignatureSpec) {
                ManagedObjectReference taskRef = this._storageDataService.getHostDatastoreSystem(spec.host).resignatureUnresolvedVmfsVolume(((VmfsDatastoreResignatureSpec)spec).vmfsDatastoreResignatureSpec);
                opResult.task = taskRef;
                TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
                if (taskInfo.error != null) {
                    throw taskInfo.error;
                }
                ResignatureRescanResult resignatureResult = (ResignatureRescanResult)taskInfo.result;
                opResult.result = resignatureResult.result;
            } else if (spec instanceof CreateVvolDatastoreSpec) {
                DatastoreSystem datastoreSystem = this._storageDataService.getHostDatastoreSystem(spec.host);
                opResult.result = datastoreSystem.createVvolDatastore(((CreateVvolDatastoreSpec)spec).vvolDatastoreSpec);
            }
            if (opResult.result instanceof ManagedObjectReference && spec.storageFolder != null) {
                this.moveDatastoreToStorageFolder((ManagedObjectReference)opResult.result, spec.storageFolder);
            }
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
            _logger.error((Object)"Failed to create datastore.", (Throwable)e);
        }
        return opResult;
    }

    private ManagedObjectReference getDatastoreByUuid(ManagedObjectReference host, String uuid) throws Exception {
        Constraint datastoresForHostConstraint = QueryUtil.createConstraintForRelationship((Object)host, (String)"datastore", (String)"Datastore");
        PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)"Datastore", (String)DATASTORE_VMFS_UUID_PROPERTY, (Comparator)Comparator.EQUALS, (Object)uuid);
        CompositeConstraint compConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{datastoresForHostConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = QueryUtil.createEmptyResourceSpec();
        querySpec.resourceSpec.constraint = compConstraint;
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
        if (resultSet.items.length == 1) {
            return (ManagedObjectReference)resultSet.items[0].resourceObject;
        }
        return null;
    }

    private void moveDatastoreToStorageFolder(ManagedObjectReference datastoreRef, ManagedObjectReference folderRef) throws Exception {
        Folder folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)folderRef);
        folder.moveInto(new ManagedObjectReference[]{datastoreRef});
    }

    private static boolean validateDatastoreIncreaseSpec(DatastoreIncreaseSpec spec, OperationResult opResult) {
        if (spec == null) {
            _logger.error((Object)"DatastoreIncreaseSpec: spec can't be null.");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        if (spec.host == null) {
            _logger.error((Object)"DatastoreIncreaseSpec.host cannot be null.");
            opResult.error = StorageUtil.getFault("error.invalidHost");
            return false;
        }
        if (spec.disk == null) {
            _logger.error((Object)"DatastoreIncreaseSpec.disk can't be null.");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        if (spec.increaseOption == null) {
            _logger.error((Object)"DatastoreIncreaseSpec.increaseOption can't be null.");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        if (spec.sizeToAdd <= 0L) {
            _logger.error((Object)"DatastoreIncreaseSpec.sizeToAdd can't be 0.");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        if (!(spec.increaseOption.spec instanceof VmfsDatastoreExpandSpec) && !(spec.increaseOption.spec instanceof VmfsDatastoreExtendSpec)) {
            _logger.error((Object)"DatastoreIncreaseSpec: invalid vmfsDatastoreSpec spec.");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        return true;
    }

    private static boolean validateDatastoreCreateSpec(DatastoreCreateSpec spec, OperationResult opResult) {
        if (spec == null) {
            _logger.error((Object)"DatastoreCreateSpec cannot be null.");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        if (spec.host == null) {
            _logger.error((Object)"DatastoreCreateSpec.host cannot be null.");
            opResult.error = StorageUtil.getFault("error.invalidHost");
            return false;
        }
        if (spec.storageFolder != null && !spec.storageFolder.getType().equals(Folder.class.getSimpleName())) {
            _logger.error((Object)"Invalid DatastoreCreateSpec.storageFolder");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        if (spec instanceof NfsDatastoreCreateSpec) {
            if (((NfsDatastoreCreateSpec)spec).nfsDatastoreCreateSpec == null) {
                _logger.error((Object)"DatastoreCreateSpec.nfsDatastoreCreateSpec can't be null.");
                opResult.error = StorageUtil.getFault("error.invalidArgument");
                return false;
            }
        } else {
            if (spec instanceof VmfsDatastoreCreateSpec) {
                VmfsDatastoreCreateSpec vmfsCreateSpec = (VmfsDatastoreCreateSpec)spec;
                return DatastoreMutationProvider.validateVmfsDatastoreCreateSpec(vmfsCreateSpec, opResult);
            }
            if (spec instanceof VmfsForceMountSpec) {
                if (((VmfsForceMountSpec)spec).vmfsDatastoreForceMountSpec == null) {
                    _logger.error((Object)"DatastoreCreateSpec.vmfsDatastoreForceMountSpec can't be null.");
                    opResult.error = StorageUtil.getFault("error.invalidArgument");
                    return false;
                }
            } else if (spec instanceof VmfsDatastoreResignatureSpec) {
                if (((VmfsDatastoreResignatureSpec)spec).vmfsDatastoreResignatureSpec == null) {
                    _logger.error((Object)"DatastoreCreateSpec.vmfsDatastoreResignatureSpec can't be null.");
                    opResult.error = StorageUtil.getFault("error.invalidArgument");
                    return false;
                }
            } else if (spec instanceof CreateVvolDatastoreSpec) {
                if (((CreateVvolDatastoreSpec)spec).vvolDatastoreSpec == null) {
                    _logger.error((Object)"DatastoreCreateSpec.vvolDatastoreSpec can't be null.");
                    opResult.error = StorageUtil.getFault("error.invalidArgument");
                    return false;
                }
            } else {
                _logger.error((Object)"Unsupported datastore creation type specified.");
                opResult.error = StorageUtil.getFault("error.invalidArgument");
                return false;
            }
        }
        return true;
    }

    private static boolean validateVmfsDatastoreCreateSpec(VmfsDatastoreCreateSpec spec, OperationResult opResult) {
        if (spec.vmfsDatastoreCreateSpec == null) {
            _logger.error((Object)"DatastoreCreateSpec.vmfsDatastoreCreateSpec can't be null.");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        if (spec.disk == null) {
            _logger.error((Object)"DatastoreCreateSpec.disk can't be null.");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        if (spec.createOption == null) {
            _logger.error((Object)"DatastoreCreateSpec.createOption can't be null.");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        if (spec.datastoreSize <= 0L) {
            _logger.error((Object)"DatastoreCreateSpec.datastoreSize can't be 0.");
            opResult.error = StorageUtil.getFault("error.invalidArgument");
            return false;
        }
        return true;
    }

    private boolean validateUnmountAndMountSpecs(ManagedObjectReference[] hosts, ManagedObjectReference datastore, OperationResult[] opResults) {
        if (hosts == null || hosts.length == 0) {
            String errorText = StorageUtil.getLocalizedString("error.invalidHostArray");
            _logger.error((Object)errorText);
            opResults[0] = new OperationResult();
            opResults[0].error = new MethodFault(errorText);
            return false;
        }
        if (datastore == null) {
            String errorText = StorageUtil.getLocalizedString("error.invalidDatastore");
            _logger.error((Object)errorText);
            opResults[0] = new OperationResult();
            opResults[0].error = new MethodFault(errorText);
            return false;
        }
        return true;
    }

    private String getVmfsUuidForDatastore(ManagedObjectReference datastore, OperationResult[] opResults) {
        String vmfsUuid = "";
        try {
            Datastore.Info dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)datastore, (String)DATASTORE_INFO_PROPERTY);
            if (dsInfo == null || !(dsInfo instanceof VmfsDatastoreInfo)) {
                String errorText = StorageUtil.getLocalizedString("error.dsIsNotVMFS");
                _logger.error((Object)errorText);
                opResults[0] = new OperationResult();
                opResults[0].error = new MethodFault(errorText);
                return null;
            }
            vmfsUuid = ((VmfsDatastoreInfo)dsInfo).vmfs.uuid;
        }
        catch (Exception e) {
            _logger.error((Object)e);
            opResults[0] = new OperationResult();
            opResults[0].error = MixedUtil.getMethodFault((Throwable)e);
            return null;
        }
        return vmfsUuid;
    }

    private OperationResult[] mountOrUnmountDatastoreFromHosts(ManagedObjectReference[] hosts, String vmfsUuid, boolean mount, ManagedObjectReference datastore) {
        OperationResult[] opResults = new OperationResult[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            opResults[i] = new OperationResult();
            opResults[i].entity = datastore;
            if (!DatastoreMutationProvider.isHostVmfsDatastoreMountCapable(hosts[i])) continue;
            try {
                OperationEffect opEffect;
                StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hosts[i]);
                if (mount) {
                    storageSystem.mountVmfsVolume(vmfsUuid);
                    continue;
                }
                storageSystem.unmountVmfsVolume(vmfsUuid);
                opResults[i].effect = opEffect = OperationEffect.newDelayedEffect();
                continue;
            }
            catch (Exception e) {
                _logger.error((Object)e);
                opResults[i].error = MixedUtil.getMethodFault((Throwable)e);
            }
        }
        return opResults;
    }

    private OperationResult[] moveDatastoresOutOfDsCluster(ManagedObjectReference[] datastoreRefs) {
        OperationResult errOpResult = null;
        OperationResult[] opResults = null;
        try {
            DataFetchCommand fetchService = DataFetchCommandFactory.getDataFetchCommand((DataService)this._dataService);
            Collection dataQueryResults = fetchService.execute(MoveOutFromDsClusterQueryObject.class, (Object[])datastoreRefs);
            HashMap<ManagedObjectReference, Object[]> targetDsFolderMap = new HashMap<ManagedObjectReference, Object[]>();
            for (MoveOutFromDsClusterQueryObject queryResult : dataQueryResults) {
                List<ManagedObjectReference> datastoreList;
                List<ManagedObjectReference> datastoreClusters;
                Object[] affDsClustersAndDatastores = (Object[])targetDsFolderMap.get(queryResult.dsClusterParentFolder);
                if (affDsClustersAndDatastores == null) {
                    datastoreClusters = new ArrayList();
                    datastoreList = new ArrayList();
                    affDsClustersAndDatastores = new Object[]{datastoreClusters, datastoreList};
                    targetDsFolderMap.put(queryResult.dsClusterParentFolder, affDsClustersAndDatastores);
                } else {
                    datastoreClusters = (List)affDsClustersAndDatastores[0];
                    datastoreList = (List)affDsClustersAndDatastores[1];
                }
                if (!datastoreClusters.contains(queryResult.dsClusterRef)) {
                    datastoreClusters.add(queryResult.dsClusterRef);
                }
                datastoreList.add((ManagedObjectReference)queryResult.provider);
            }
            opResults = new OperationResult[targetDsFolderMap.size()];
            int index = 0;
            for (ManagedObjectReference dsFolderRef : targetDsFolderMap.keySet()) {
                opResults[index] = new OperationResult();
                Object[] affectedDsClustersAndDatastores = (Object[])targetDsFolderMap.get(dsFolderRef);
                opResults[index].entity = dsFolderRef;
                ArrayList dsClusterList = (ArrayList)affectedDsClustersAndDatastores[0];
                opResults[index].effect = new OperationEffect();
                opResults[index].effect.affectedEntites = dsClusterList.toArray(new ManagedObjectReference[0]);
                try {
                    ArrayList dsList = (ArrayList)affectedDsClustersAndDatastores[1];
                    ManagedObjectReference[] dsRefs = dsList.toArray(new ManagedObjectReference[0]);
                    Folder dsFolder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dsFolderRef);
                    opResults[index].task = dsFolder.moveInto(dsRefs);
                }
                catch (Exception ex) {
                    _logger.error((Object)ex);
                    opResults[index].error = MixedUtil.getMethodFault((Throwable)ex);
                }
                ++index;
            }
        }
        catch (Exception e) {
            _logger.error((Object)e);
            errOpResult = new OperationResult();
            errOpResult.error = MixedUtil.getMethodFault((Throwable)e);
            return new OperationResult[]{errOpResult};
        }
        return opResults;
    }

    private static boolean isHostVmfsDatastoreMountCapable(ManagedObjectReference hostRef) {
        if (hostRef == null) {
            return false;
        }
        HostSystem host = null;
        try {
            host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        }
        catch (Exception e) {
            _logger.error((Object)e);
            return false;
        }
        Capability hostCapability = host.getCapability();
        if (hostCapability != null) {
            return hostCapability.vmfsDatastoreMountCapable;
        }
        return false;
    }

    private static ManagedObjectReference addNewExtentToDatastore(DatastoreSystem datastoreSystem, StorageSystem storageSystem, ManagedObjectReference datastore, DatastoreIncreaseSpec spec) throws Exception {
        VmfsDatastoreExtendSpec extendSpec = (VmfsDatastoreExtendSpec)spec.increaseOption.spec;
        if (!DatastoreMutationProvider.updateOptionLayout(spec.increaseOption, spec.sizeToAdd, spec.increaseOption.spec)) {
            throw new Exception(StorageUtil.getLocalizedString("error.failedToComputeNewDiskLayout"));
        }
        String format = null;
        if (extendSpec.partition.partitionFormat != "" && extendSpec.partition.partitionFormat != null) {
            format = extendSpec.partition.partitionFormat;
        }
        DiskPartitionInfo newDiskPartition = storageSystem.computeDiskPartitionInfo(spec.disk.disk.devicePath, spec.increaseOption.info.layout, format);
        extendSpec.partition = newDiskPartition.spec;
        Hashtable<Integer, ScsiDisk.Partition> partitionIndexToScsiPartitionMap = new Hashtable<Integer, ScsiDisk.Partition>();
        if (extendSpec.extent != null) {
            for (ScsiDisk.Partition partition : extendSpec.extent) {
                partitionIndexToScsiPartitionMap.put(partition.partition, partition);
            }
        }
        for (ScsiDisk.Partition partition : StorageUtil.getOptionInfoExtents(spec.increaseOption.info)) {
            DiskPartitionInfo.BlockRange newBlockRange = null;
            for (DiskPartitionInfo.BlockRange blockRange : newDiskPartition.layout.partition) {
                if (blockRange.start.block != partition.start.block) continue;
                newBlockRange = blockRange;
                break;
            }
            if (newBlockRange == null) {
                _logger.error((Object)"addNewExtentToDatastore: failed to match the original block range with a new one!");
                throw new Exception(StorageUtil.getLocalizedString("error.failedToComputeNewDiskLayout"));
            }
            ScsiDisk.Partition partitionMap = (ScsiDisk.Partition)partitionIndexToScsiPartitionMap.get(partition.partition);
            if (partitionMap == null) continue;
            partitionMap.partition = newBlockRange.partition;
        }
        return datastoreSystem.extendVmfsDatastore(datastore, extendSpec);
    }

    private static ManagedObjectReference expandDatastoreExtent(DatastoreSystem datastoreSystem, StorageSystem storageSystem, ManagedObjectReference datastore, DatastoreIncreaseSpec spec) throws Exception {
        VmfsDatastoreExpandSpec expandSpec = (VmfsDatastoreExpandSpec)spec.increaseOption.spec;
        VmfsDatastoreOption.SingleExtentInfo info = (VmfsDatastoreOption.SingleExtentInfo)spec.increaseOption.info;
        long availableBlocks = StorageUtil.getNumberOfBlocks(info.vmfsExtent);
        long originalExtentSize = DatastoreMutationProvider.getOriginalExtentSize(storageSystem, spec, expandSpec);
        long newExtentSize = originalExtentSize + spec.sizeToAdd;
        long numberOfBlocks = StorageUtil.getNumberOfBlocksForDatastore(newExtentSize, info.vmfsExtent.start.blockSize, availableBlocks);
        info.vmfsExtent.end.block = StorageUtil.getEndBlockAddress(info.vmfsExtent.start.block, numberOfBlocks);
        String format = null;
        if (expandSpec.partition.partitionFormat != "" && expandSpec.partition.partitionFormat != null) {
            format = expandSpec.partition.partitionFormat;
        }
        DiskPartitionInfo newDiskInfo = storageSystem.computeDiskPartitionInfoForResize(expandSpec.extent, info.vmfsExtent, format);
        expandSpec.partition = newDiskInfo.spec;
        return datastoreSystem.expandVmfsDatastore(datastore, expandSpec);
    }

    private static long getOriginalExtentSize(StorageSystem storageSystem, DatastoreIncreaseSpec spec, VmfsDatastoreExpandSpec expandSpec) throws Exception {
        DiskPartitionInfo[] diskPartitionInfos = storageSystem.retrieveDiskPartitionInfo(new String[]{spec.disk.disk.devicePath});
        if (diskPartitionInfos == null || diskPartitionInfos.length != 1) {
            _logger.error((Object)"getOriginalExtentSize: Failed to retrieve original DiskPartitionInfo.");
            throw new Exception(StorageUtil.getLocalizedString("error.failedToComputeNewDiskLayout"));
        }
        DiskPartitionInfo originalDiskPartitionInfo = diskPartitionInfos[0];
        DiskPartitionInfo.BlockRange newBlockRange = StorageUtil.findBlockRange(expandSpec.extent.partition, spec.increaseOption.info.layout.partition);
        DiskPartitionInfo.BlockRange originalBlockRange = null;
        for (DiskPartitionInfo.BlockRange range : originalDiskPartitionInfo.layout.partition) {
            if (range.start.block != newBlockRange.start.block) continue;
            originalBlockRange = range;
            break;
        }
        if (originalBlockRange == null) {
            _logger.error((Object)"getOriginalExtentSize: Failed to find disk's original block range.");
            throw new Exception(StorageUtil.getLocalizedString("error.failedToComputeNewDiskLayout"));
        }
        return StorageUtil.getSizeOfBlockRange(originalBlockRange);
    }

    private ManagedObjectReference addVmfsDatastore(VmfsDatastoreCreateSpec spec) throws Exception {
        if (!DatastoreMutationProvider.updateOptionLayout(spec.createOption, spec.datastoreSize, (VmfsDatastoreSpec)spec.vmfsDatastoreCreateSpec)) {
            throw new Exception(StorageUtil.getLocalizedString("error.failedToComputeNewDiskLayout"));
        }
        StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(spec.host);
        if (storageSystem == null) {
            _logger.error((Object)"expandDatastoreExtent: Failed to retrieve host's storageSystem.");
            throw new Exception(StorageUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        String format = null;
        if (spec.vmfsDatastoreCreateSpec.partition.partitionFormat != "" && spec.vmfsDatastoreCreateSpec.partition.partitionFormat != null) {
            format = spec.vmfsDatastoreCreateSpec.partition.partitionFormat;
        }
        DiskPartitionInfo newDiskPartition = storageSystem.computeDiskPartitionInfo(spec.disk.disk.devicePath, spec.createOption.info.layout, format);
        spec.vmfsDatastoreCreateSpec.partition = newDiskPartition.spec;
        Hashtable<Integer, ScsiDisk.Partition> partitionIndexToScsiPartitionMap = new Hashtable<Integer, ScsiDisk.Partition>();
        if (spec.vmfsDatastoreCreateSpec.extent != null) {
            for (ScsiDisk.Partition extentPartition : spec.vmfsDatastoreCreateSpec.extent) {
                partitionIndexToScsiPartitionMap.put(extentPartition.partition, extentPartition);
            }
        }
        boolean isHeadExtent = true;
        for (DiskPartitionInfo.BlockRange originalExtentBlockRange : StorageUtil.getOptionInfoExtents(spec.createOption.info)) {
            DiskPartitionInfo.BlockRange newBlockRange = null;
            for (DiskPartitionInfo.BlockRange blockRange : newDiskPartition.layout.partition) {
                if (blockRange.start.block != originalExtentBlockRange.start.block) continue;
                newBlockRange = blockRange;
                break;
            }
            if (newBlockRange == null) {
                _logger.error((Object)"createVmfsDatastore: failed to match the original blockrange with a new one!");
                throw new Exception(StorageUtil.getLocalizedString("error.failedToComputeNewDiskLayout"));
            }
            ScsiDisk.Partition partitionMap = (ScsiDisk.Partition)partitionIndexToScsiPartitionMap.get(originalExtentBlockRange.partition);
            if (partitionMap != null) {
                partitionMap.partition = newBlockRange.partition;
            }
            if (!isHeadExtent) continue;
            isHeadExtent = false;
            spec.vmfsDatastoreCreateSpec.vmfs.extent.partition = newBlockRange.partition;
        }
        return this._storageDataService.getHostDatastoreSystem(spec.host).createVmfsDatastore(spec.vmfsDatastoreCreateSpec);
    }

    private static boolean updateOptionLayout(VmfsDatastoreOption option, long datastoreSize, VmfsDatastoreSpec spec) {
        if (option.info instanceof VmfsDatastoreOption.SingleExtentInfo) {
            VmfsDatastoreOption.SingleExtentInfo singleExtentInfo = (VmfsDatastoreOption.SingleExtentInfo)option.info;
            return DatastoreMutationProvider.updateSingleExtentInfoLayout(singleExtentInfo, datastoreSize);
        }
        if (option.info instanceof VmfsDatastoreOption.MultipleExtentInfo) {
            VmfsDatastoreOption.MultipleExtentInfo multiExtentInfo = (VmfsDatastoreOption.MultipleExtentInfo)option.info;
            return DatastoreMutationProvider.updateMultipleExtentInfoLayout(multiExtentInfo, datastoreSize, spec);
        }
        return false;
    }

    private static boolean updateSingleExtentInfoLayout(VmfsDatastoreOption.SingleExtentInfo info, long datastoreSize) {
        long endBlockAddress;
        DiskPartitionInfo.BlockRange extentBlockRange = StorageUtil.findBlockRange(info.vmfsExtent.partition.intValue(), info.layout.partition);
        if (extentBlockRange == null) {
            _logger.error((Object)"updateSingelExtentInfoLayout: failed to find the block range!");
            return false;
        }
        long availableBlocks = StorageUtil.getNumberOfBlocks(extentBlockRange);
        long numberOfBlocks = StorageUtil.getNumberOfBlocksForDatastore(datastoreSize, info.vmfsExtent.start.blockSize, availableBlocks);
        extentBlockRange.end.block = endBlockAddress = StorageUtil.getEndBlockAddress(extentBlockRange.start.block, numberOfBlocks);
        return true;
    }

    private static boolean updateMultipleExtentInfoLayout(VmfsDatastoreOption.MultipleExtentInfo info, long datastoreSize, VmfsDatastoreSpec datastoreSpec) {
        int extentIndex;
        DiskPartitionInfo.BlockRange[] extents = info.vmfsExtent;
        if (extents.length == 0) {
            _logger.error((Object)"updateMultipleExtentInfoLayout: invalid number of Vmfs Extents!");
            return false;
        }
        long availableBlocks = DatastoreMutationProvider.getNumberOfAvailableBlocks(extents);
        long numberOfBlocks = StorageUtil.getNumberOfBlocksForDatastore(datastoreSize, extents[0].start.blockSize, availableBlocks);
        for (extentIndex = 0; numberOfBlocks > 0L && extentIndex < extents.length; ++extentIndex) {
            DiskPartitionInfo.BlockRange blockRange = extents[extentIndex];
            long span = StorageUtil.getNumberOfBlocks(blockRange);
            if (span >= numberOfBlocks) {
                long endBlockAddress;
                DiskPartitionInfo.BlockRange layoutBlockRange = StorageUtil.findBlockRange(blockRange.partition.intValue(), info.layout.partition);
                if (layoutBlockRange == null) {
                    _logger.error((Object)"updateMultipleExtentInfoLayout: failed to find layout block range!");
                    return false;
                }
                layoutBlockRange.end.block = endBlockAddress = StorageUtil.getEndBlockAddress(layoutBlockRange.start.block, numberOfBlocks);
                numberOfBlocks = 0L;
                continue;
            }
            numberOfBlocks -= span;
        }
        ArrayList<DiskPartitionInfo.BlockRange> filteredBlockRanges = new ArrayList<DiskPartitionInfo.BlockRange>();
        for (DiskPartitionInfo.BlockRange blockRangeToFilter : info.layout.partition) {
            boolean filterOut = false;
            if (blockRangeToFilter.partition != null) {
                for (int i = extentIndex; i < info.vmfsExtent.length; ++i) {
                    if (info.vmfsExtent[i].partition == null || !blockRangeToFilter.partition.equals(info.vmfsExtent[i].partition)) continue;
                    filterOut = true;
                    break;
                }
            }
            if (filterOut) continue;
            filteredBlockRanges.add(blockRangeToFilter);
        }
        info.layout.partition = filteredBlockRanges.toArray(new DiskPartitionInfo.BlockRange[0]);
        info.vmfsExtent = (DiskPartitionInfo.BlockRange[])Arrays.copyOf(extents, extentIndex, DiskPartitionInfo.BlockRange[].class);
        if (datastoreSpec instanceof com.vmware.vim.binding.vim.host.VmfsDatastoreCreateSpec) {
            com.vmware.vim.binding.vim.host.VmfsDatastoreCreateSpec createSpec = (com.vmware.vim.binding.vim.host.VmfsDatastoreCreateSpec)datastoreSpec;
            if (createSpec.extent != null && extentIndex - 1 < createSpec.extent.length) {
                createSpec.extent = (ScsiDisk.Partition[])Arrays.copyOf(createSpec.extent, extentIndex - 1, ScsiDisk.Partition[].class);
            }
        } else if (datastoreSpec instanceof VmfsDatastoreExtendSpec) {
            VmfsDatastoreExtendSpec extendSpec = (VmfsDatastoreExtendSpec)datastoreSpec;
            if (extendSpec.extent != null && extentIndex < extendSpec.extent.length) {
                extendSpec.extent = (ScsiDisk.Partition[])Arrays.copyOf(extendSpec.extent, extentIndex, ScsiDisk.Partition[].class);
            }
        }
        return true;
    }

    private static long getNumberOfAvailableBlocks(DiskPartitionInfo.BlockRange[] extents) {
        long availableBlocks = 0L;
        for (DiskPartitionInfo.BlockRange blockRange : extents) {
            availableBlocks += StorageUtil.getNumberOfBlocks(blockRange);
        }
        return availableBlocks;
    }

    private ManagedObjectReference createScheduleTaskForConfigureSIOC(ManagedObjectReference dsRef, StorageResourceManager.IORMConfigSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ServiceInstanceContent serviceContent = StorageUtil.getServiceInstanceContent(dsRef);
        ManagedObjectReference storageManagerRef = serviceContent.getStorageResourceManager();
        ScheduledTaskSpec vcTaskSpec = this.createConfigureSiocScheduledTaskSpec(dsRef, spec, scheduleSpec);
        return SchedulingUtil.createVcScheduledTaskForObject((DataService)this._dataService, (ManagedObjectReference)storageManagerRef, (ScheduledTaskSpec)vcTaskSpec);
    }

    private ManagedObjectReference editScheduleTaskForConfigureSIOC(ManagedObjectReference dsRef, StorageResourceManager.IORMConfigSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = this.createConfigureSiocScheduledTaskSpec(dsRef, spec, scheduleSpec);
        return SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec);
    }

    private ScheduledTaskSpec createConfigureSiocScheduledTaskSpec(ManagedObjectReference dsRef, StorageResourceManager.IORMConfigSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        vcTaskSpec.action = SchedulingUtil.newMethodAction((String)"ConfigureDatastoreIORM_Task", (Object[])new Object[]{dsRef, spec});
        return vcTaskSpec;
    }
}

