/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.util;

import com.vmware.vim.binding.sms.storage.replication.GroupInfo;
import com.vmware.vim.binding.sms.storage.replication.ReplicationState;
import com.vmware.vim.binding.sms.storage.replication.SourceGroupInfo;
import com.vmware.vim.binding.sms.storage.replication.TargetGroupInfo;
import com.vmware.vim.binding.vim.vm.replication.ReplicationGroupId;
import com.vmware.vsphere.client.common.spbm.data.ReplicationGroupInfo;
import com.vmware.vsphere.client.spbm.util.PbmUtil;

public class ReplicationGroupUtil {
    private static final String AUTO_GROUP_ID = "ffffffff-ffff-ffff-ffff-ffffffffffff";

    private ReplicationGroupUtil() {
    }

    public static String getReplicationGroupName(ReplicationGroupInfo replicationGroupInfo) {
        if (replicationGroupInfo == null || replicationGroupInfo.groupInfo == null) {
            return "";
        }
        GroupInfo groupInfo = replicationGroupInfo.groupInfo;
        if (groupInfo instanceof SourceGroupInfo) {
            return ((SourceGroupInfo)groupInfo).getName();
        }
        if (groupInfo instanceof TargetGroupInfo) {
            TargetGroupInfo targetGroupInfo = (TargetGroupInfo)groupInfo;
            String stateTag = "";
            if (targetGroupInfo.getState() != null) {
                if (ReplicationState.INTEST.toString().equals(targetGroupInfo.getState())) {
                    stateTag = String.format("({%s})", PbmUtil.getLocalizedString("spbmReplicationGroups.intestState", new String[0]));
                } else if (ReplicationState.FAILEDOVER.toString().equals(targetGroupInfo.getState())) {
                    stateTag = String.format("({%s})", PbmUtil.getLocalizedString("spbmReplicationGroups.failedoverState", new String[0]));
                }
            }
            return String.format("%s%s", stateTag, ReplicationGroupUtil.getReplicationGroupNameFromId(replicationGroupInfo.id));
        }
        return ReplicationGroupUtil.getReplicationGroupNameFromId(replicationGroupInfo.id);
    }

    private static String getReplicationGroupNameFromId(ReplicationGroupId replicationGroupId) {
        if (replicationGroupId == null) {
            return "";
        }
        if (ReplicationGroupUtil.isAutoReplicationGroup(replicationGroupId)) {
            return PbmUtil.getLocalizedString("StorageLocatorControl.protectionGroup.auto", new String[0]);
        }
        if (replicationGroupId.deviceGroupId != null && replicationGroupId.deviceGroupId.id != null && replicationGroupId.faultDomainId != null && replicationGroupId.faultDomainId.id != null) {
            return String.format("%s:%s", replicationGroupId.deviceGroupId.id, replicationGroupId.faultDomainId.id);
        }
        return "";
    }

    private static boolean isAutoReplicationGroup(ReplicationGroupId replicationGroupId) {
        return replicationGroupId != null && replicationGroupId.deviceGroupId != null && AUTO_GROUP_ID.equals(replicationGroupId.deviceGroupId.id);
    }
}

