/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl.formatters;

import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.capability.CapabilityMetadata;
import com.vmware.vim.binding.pbm.capability.ConstraintInstance;
import com.vmware.vim.binding.pbm.capability.PropertyInstance;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;
import com.vmware.vsphere.client.spbm.data.profile.content.PropertyData;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class VsanCapabilitiesFormatter {
    public static final String VSAN_NAMESPACE = "VSAN";
    public static final int VMWARE_VSAN_CACHE_RESERVATION_SCALE_FACTOR = 10000;
    public static final int VMWARE_VSAN_CACHE_RESERVATION_PRECISION = 4;
    public static final String CACHE_RESERVATION_CAPABILITY = "cacheReservation";
    private static final String SUBFAILURES_TO_TOLERATE_CAPABILITY = "subFailuresToTolerate";
    private static final String LOCALITY_CAPABILITY = "locality";
    private static final String REPLICA_PREFERENCE_CAPABILITY = "replicaPreference";
    private static final String CHECKSUM_DISABLED_CAPABILITY = "checksumDisabled";
    private static final String IOPS_LIMIT_CAPABILITY = "iopsLimit";
    private static final String PRIMARY_TO_TOLERATE_CAPABILITY = "hostFailuresToTolerate";
    private static final String STRIPE_WIDTH_CAPABILITY = "stripeWidth";
    private static final String OBJECT_SPACE_RESERVATION_CAPABILITY = "proportionalCapacity";
    private static final String FORCE_PROVISIONING_CAPABILITY = "forceProvisioning";
    private static final String LOCALITY_NONE = "None";
    private static final String LOCALITY_HOST_LOCAL = "HostLocal";
    private static final String LOCALITY_PRIMARY = "Preferred Fault Domain";
    private static final String LOCALITY_SECONDARY = "Secondary Fault Domain";
    private static final String RAID1 = "RAID-1 (Mirroring) - Performance";
    private static final String RAID5 = "RAID-5/6 (Erasure Coding) - Capacity";
    private static final String LOCAL_PROTECTION_CAPABILITY = "localProtection";
    private static final String ARCHIVAL_PROTECTION_CAPABILITY = "archivalProtection";
    private static final String REMOTE_PROTECTION_CAPABILITY = "remoteProtection";
    private static final String LOCAL_SNAPSHOT_FREQUENCY_CAPABILITY = "localSnapshotFrequency";
    private static final String LOCAL_QUIESCE_EVERY_MTH_CAPABILITY = "localQuiesceEveryMth";
    private static final String LOCAL_INSTANCES_RETAIN_CAPABILITY = "localInstancesRetained";
    private static final String ARCHIVAL_ARCHIVE_ONLY_QUIESCED_CAPABILITY = "archivalArchiveOnlyQuiesced";
    private static final String ARCHIVAL_ARCHIVE_MTH_CAPABILITY = "archivalArchiveMth";
    private static final String ARCHIVAL_RECENT_RESTORE_POINTS_CAPABILITY = "archivalRecentRestorePoints";
    private static final String REMOTE_RPO_CAPABILITY = "remoteRpo";
    private static final String REMOTE_INSTANCES_RETAINED_CAPABILITY = "remoteInstancesRetained";
    private static final String REMOTE_POLICY_TAG_CAPABILITY = "remotePolicyTag";

    public static boolean isVsanNamespace(String namespace) {
        return VSAN_NAMESPACE.equals(namespace);
    }

    public static boolean hasMissingMetadata(List<CapabilityInstance> capabilityInstances, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        if (capabilityInstances == null || capabilityInstances.size() == 0) {
            return false;
        }
        if (namespaceMetadata == null || namespaceMetadata.size() == 0) {
            return true;
        }
        for (CapabilityInstance capInstance : capabilityInstances) {
            if (VsanCapabilitiesFormatter.containsCapability(namespaceMetadata, capInstance.id.id, capInstance.id.namespace)) continue;
            return true;
        }
        return false;
    }

    static boolean containsCapability(Map<String, NamespaceCapabilityMetadata> namespaceMetadata, String capability, String namespace) {
        if (namespaceMetadata == null || namespaceMetadata.size() == 0) {
            return false;
        }
        NamespaceCapabilityMetadata vsanCapabilityMetadata = namespaceMetadata.get(namespace);
        if (vsanCapabilityMetadata == null) {
            return false;
        }
        for (CapabilityMetadata capabilityMetadata : vsanCapabilityMetadata.capabilityMetadata) {
            if (!capabilityMetadata.id.id.equals(capability)) continue;
            return true;
        }
        return false;
    }

    static boolean containsVsanCapability(Map<String, NamespaceCapabilityMetadata> namespaceMetadata, String capability) {
        return VsanCapabilitiesFormatter.containsCapability(namespaceMetadata, capability, VSAN_NAMESPACE);
    }

    public static List<PropertyData> getVsanRuleProperties(List<CapabilityInstance> capabilityInstances, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        VsanCapabilitiesData vsanCapabilitiesData = VsanCapabilitiesFormatter.getCapabilityDataFromRuleSet(capabilityInstances, namespaceMetadata);
        ArrayList<PropertyData> result = new ArrayList<PropertyData>();
        if (vsanCapabilitiesData == null) {
            return result;
        }
        result.add(VsanCapabilitiesFormatter.getSiteTolerancePropertyData(vsanCapabilitiesData, namespaceMetadata));
        if (vsanCapabilitiesData.isNestedFd) {
            result.add(VsanCapabilitiesFormatter.getFaultDomainsToToleratePropertyData(vsanCapabilitiesData));
        }
        result.add(VsanCapabilitiesFormatter.getFailuresToToleratePropertyData(vsanCapabilitiesData, namespaceMetadata));
        result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.diskStripes", new String[0]), Integer.toString(vsanCapabilitiesData.diskStripes)));
        if (VsanCapabilitiesFormatter.containsVsanCapability(namespaceMetadata, IOPS_LIMIT_CAPABILITY)) {
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.iopsLimit", new String[0]), Integer.toString(vsanCapabilitiesData.iopsLimit)));
        }
        result.add(VsanCapabilitiesFormatter.getObjectSpaceReservationPropertyData(vsanCapabilitiesData));
        result.add(VsanCapabilitiesFormatter.getReadCacheReservationPropertyData(vsanCapabilitiesData));
        if (VsanCapabilitiesFormatter.containsVsanCapability(namespaceMetadata, CHECKSUM_DISABLED_CAPABILITY)) {
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.disableObjectChecksum", new String[0]), vsanCapabilitiesData.checksumDisabled ? PbmUtil.getLocalizedString("vsan.yes", new String[0]) : PbmUtil.getLocalizedString("vsan.no", new String[0])));
        }
        result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.forceProvisioning", new String[0]), vsanCapabilitiesData.forceProvisioning ? PbmUtil.getLocalizedString("vsan.yes", new String[0]) : PbmUtil.getLocalizedString("vsan.no", new String[0])));
        if (vsanCapabilitiesData.hasLocalProtectionCapabilitySet) {
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.dp.localSnapshotFrequency", new String[0]), PbmUtil.getLocalizedString("vsan.sp.dp.snapshotFrequencyInMinutes", Integer.toString(vsanCapabilitiesData.localSnapshotFrequencyInMinutes))));
            int quiescedSnapshot = vsanCapabilitiesData.quiesceEveryMthLocalSnapshot;
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.dp.queiscedSnapshot", new String[0]), VsanCapabilitiesFormatter.getFormattedNumber(quiescedSnapshot)));
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.dp.localInstancesToRetain", new String[0]), Integer.toString(vsanCapabilitiesData.localInstancesToRetain)));
        }
        if (vsanCapabilitiesData.hasArchivalProtectionCapabilitySet && vsanCapabilitiesData.archivalSnapshotsToRetain > 0) {
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.dp.archiveSnaphotsToRetain", new String[0]), Integer.toString(vsanCapabilitiesData.archivalSnapshotsToRetain)));
            if (vsanCapabilitiesData.archiveEveryMthSnapshot > 0) {
                int archiveEveryMthSnapshot = vsanCapabilitiesData.archiveEveryMthSnapshot;
                result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.dp.archiveEvery", new String[0]), VsanCapabilitiesFormatter.getFormattedNumber(archiveEveryMthSnapshot)));
            }
        }
        if (vsanCapabilitiesData.hasRemoteProtectionCapabilitySet) {
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.dp.remote.rpo", new String[0]), PbmUtil.getLocalizedString("vsan.sp.dp.snapshotFrequencyInMinutes", Integer.toString(vsanCapabilitiesData.remoteRpo))));
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.dp.remote.instancesRetained", new String[0]), vsanCapabilitiesData.remoteInstancesRetained == 0 ? PbmUtil.getLocalizedString("vsan.sp.dp.noQuiescedSnapshot", new String[0]) : Integer.toString(vsanCapabilitiesData.remoteInstancesRetained)));
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.dp.remote.policyTag", new String[0]), vsanCapabilitiesData.remotePolicyTag));
        }
        return result;
    }

    static void addVsanDpCapabilities(VsanCapabilitiesData vsanCapabilitiesData, List<CapabilityInstance> vsanCapabilities, VsanCapabilitiesData defaultCapabilites) {
        for (CapabilityInstance item : vsanCapabilities) {
            if (item.id.id.equals(LOCAL_PROTECTION_CAPABILITY)) {
                vsanCapabilitiesData.hasLocalProtectionCapabilitySet = true;
                vsanCapabilitiesData.localSnapshotFrequencyInMinutes = VsanCapabilitiesFormatter.getPropertyInstanceValue(item, LOCAL_SNAPSHOT_FREQUENCY_CAPABILITY, defaultCapabilites.localSnapshotFrequencyInMinutes);
                vsanCapabilitiesData.quiesceEveryMthLocalSnapshot = VsanCapabilitiesFormatter.getPropertyInstanceValue(item, LOCAL_QUIESCE_EVERY_MTH_CAPABILITY, defaultCapabilites.quiesceEveryMthLocalSnapshot);
                vsanCapabilitiesData.localInstancesToRetain = VsanCapabilitiesFormatter.getPropertyInstanceValue(item, LOCAL_INSTANCES_RETAIN_CAPABILITY, defaultCapabilites.localInstancesToRetain);
                continue;
            }
            if (item.id.id.equals(ARCHIVAL_PROTECTION_CAPABILITY)) {
                vsanCapabilitiesData.hasArchivalProtectionCapabilitySet = true;
                vsanCapabilitiesData.archiveEveryMthSnapshot = VsanCapabilitiesFormatter.getPropertyInstanceValue(item, ARCHIVAL_ARCHIVE_MTH_CAPABILITY, defaultCapabilites.archiveEveryMthSnapshot);
                vsanCapabilitiesData.archivalSnapshotsToRetain = VsanCapabilitiesFormatter.getPropertyInstanceValue(item, ARCHIVAL_RECENT_RESTORE_POINTS_CAPABILITY, defaultCapabilites.archivalSnapshotsToRetain);
                continue;
            }
            if (!item.id.id.equals(REMOTE_PROTECTION_CAPABILITY)) continue;
            vsanCapabilitiesData.hasRemoteProtectionCapabilitySet = true;
            vsanCapabilitiesData.remoteRpo = VsanCapabilitiesFormatter.getPropertyInstanceValue(item, REMOTE_RPO_CAPABILITY, defaultCapabilites.remoteRpo);
            vsanCapabilitiesData.remoteInstancesRetained = VsanCapabilitiesFormatter.getPropertyInstanceValue(item, REMOTE_INSTANCES_RETAINED_CAPABILITY, defaultCapabilites.remoteInstancesRetained);
            vsanCapabilitiesData.remotePolicyTag = VsanCapabilitiesFormatter.getPropertyInstanceValue(item, REMOTE_POLICY_TAG_CAPABILITY, defaultCapabilites.remotePolicyTag);
        }
    }

    static VsanCapabilitiesData getDefaultValuesCapabilityData(Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        if (namespaceMetadata == null) {
            return null;
        }
        NamespaceCapabilityMetadata vsanCapabilityMetadata = namespaceMetadata.get(VSAN_NAMESPACE);
        if (vsanCapabilityMetadata == null) {
            return null;
        }
        VsanCapabilitiesData defaultCapabilitiesData = new VsanCapabilitiesData();
        block40: for (CapabilityMetadata capability : vsanCapabilityMetadata.capabilityMetadata) {
            Object defaultValue = capability.propertyMetadata[0].defaultValue;
            switch (capability.id.id) {
                case "hostFailuresToTolerate": {
                    defaultCapabilitiesData.primaryFtt = (Integer)defaultValue;
                    continue block40;
                }
                case "subFailuresToTolerate": {
                    defaultCapabilitiesData.secondaryFtt = (Integer)defaultValue;
                    continue block40;
                }
                case "locality": {
                    defaultCapabilitiesData.locality = (String)defaultValue;
                    continue block40;
                }
                case "replicaPreference": {
                    defaultCapabilitiesData.replicaPreference = (String)defaultValue;
                    continue block40;
                }
                case "stripeWidth": {
                    defaultCapabilitiesData.diskStripes = (Integer)defaultValue;
                    continue block40;
                }
                case "cacheReservation": {
                    defaultCapabilitiesData.readCacheReservation = (Integer)defaultValue;
                    continue block40;
                }
                case "checksumDisabled": {
                    defaultCapabilitiesData.checksumDisabled = (Boolean)defaultValue;
                    continue block40;
                }
                case "iopsLimit": {
                    defaultCapabilitiesData.iopsLimit = (Integer)defaultValue;
                    continue block40;
                }
                case "proportionalCapacity": {
                    defaultCapabilitiesData.objectSpaceReservation = (Integer)defaultValue;
                    continue block40;
                }
                case "forceProvisioning": {
                    defaultCapabilitiesData.forceProvisioning = (Boolean)defaultValue;
                    continue block40;
                }
                case "localSnapshotFrequency": {
                    defaultCapabilitiesData.localSnapshotFrequencyInMinutes = (Integer)defaultValue;
                    continue block40;
                }
                case "localQuiesceEveryMth": {
                    defaultCapabilitiesData.quiesceEveryMthLocalSnapshot = (Integer)defaultValue;
                    continue block40;
                }
                case "localInstancesRetained": {
                    defaultCapabilitiesData.localInstancesToRetain = (Integer)defaultValue;
                    continue block40;
                }
                case "archivalArchiveMth": {
                    defaultCapabilitiesData.archiveEveryMthSnapshot = (Integer)defaultValue;
                    continue block40;
                }
                case "archivalRecentRestorePoints": {
                    defaultCapabilitiesData.archivalSnapshotsToRetain = (Integer)defaultValue;
                    continue block40;
                }
                case "remoteRpo": {
                    defaultCapabilitiesData.remoteRpo = (Integer)defaultValue;
                    continue block40;
                }
                case "remoteInstancesRetained": {
                    defaultCapabilitiesData.remoteInstancesRetained = (Integer)defaultValue;
                    continue block40;
                }
                case "remotePolicyTag": {
                    defaultCapabilitiesData.remotePolicyTag = (String)defaultValue;
                }
            }
        }
        return defaultCapabilitiesData;
    }

    static VsanCapabilitiesData getCapabilityDataFromRuleSet(List<CapabilityInstance> vSanCapabilities, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        VsanCapabilitiesData defaultCapabilites = VsanCapabilitiesFormatter.getDefaultValuesCapabilityData(namespaceMetadata);
        if (defaultCapabilites == null) {
            return null;
        }
        if (vSanCapabilities == null) {
            return defaultCapabilites;
        }
        boolean hasSecondaryFTT = false;
        boolean hasLocalityCapability = false;
        for (CapabilityInstance item : vSanCapabilities) {
            if (item.id.id.equals(SUBFAILURES_TO_TOLERATE_CAPABILITY)) {
                hasSecondaryFTT = true;
                continue;
            }
            if (!item.id.id.equals(LOCALITY_CAPABILITY)) continue;
            hasLocalityCapability = true;
        }
        boolean isNestedFd = hasSecondaryFTT && !hasLocalityCapability;
        boolean isStretchedCluster = hasSecondaryFTT && hasLocalityCapability;
        String locality = hasLocalityCapability ? VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, LOCALITY_CAPABILITY, defaultCapabilites.locality) : null;
        VsanCapabilitiesData result = new VsanCapabilitiesData(isStretchedCluster, isNestedFd, VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, PRIMARY_TO_TOLERATE_CAPABILITY, defaultCapabilites.primaryFtt), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, SUBFAILURES_TO_TOLERATE_CAPABILITY, defaultCapabilites.secondaryFtt), locality, VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, REPLICA_PREFERENCE_CAPABILITY, defaultCapabilites.replicaPreference), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, STRIPE_WIDTH_CAPABILITY, defaultCapabilites.diskStripes), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, IOPS_LIMIT_CAPABILITY, defaultCapabilites.iopsLimit), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, CHECKSUM_DISABLED_CAPABILITY, defaultCapabilites.checksumDisabled), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, CACHE_RESERVATION_CAPABILITY, defaultCapabilites.readCacheReservation), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, OBJECT_SPACE_RESERVATION_CAPABILITY, defaultCapabilites.objectSpaceReservation), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, FORCE_PROVISIONING_CAPABILITY, defaultCapabilites.forceProvisioning));
        VsanCapabilitiesFormatter.addVsanDpCapabilities(result, vSanCapabilities, defaultCapabilites);
        return result;
    }

    static PropertyData getSiteTolerancePropertyData(VsanCapabilitiesData vsanCapabilitiesData, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        String stTolerance = PbmUtil.getLocalizedString("vsan.policy.siteTolerance.none", new String[0]);
        if ((vsanCapabilitiesData.isStretchedCluster || vsanCapabilitiesData.isNestedFd) && VsanCapabilitiesFormatter.containsVsanCapability(namespaceMetadata, SUBFAILURES_TO_TOLERATE_CAPABILITY)) {
            stTolerance = vsanCapabilitiesData.primaryFtt == 0 && StringUtils.isNotEmpty((String)vsanCapabilitiesData.locality) && VsanCapabilitiesFormatter.containsVsanCapability(namespaceMetadata, LOCALITY_CAPABILITY) ? (vsanCapabilitiesData.locality.equals(LOCALITY_PRIMARY) ? PbmUtil.getLocalizedString("vsan.policy.siteTolerance.nonePrimary", new String[0]) : (vsanCapabilitiesData.locality.equals(LOCALITY_SECONDARY) ? PbmUtil.getLocalizedString("vsan.policy.siteTolerance.noneSecondary", new String[0]) : PbmUtil.getLocalizedString("vsan.policy.siteTolerance.noneStretchedCluster", new String[0]))) : (StringUtils.isNotEmpty((String)vsanCapabilitiesData.locality) ? PbmUtil.getLocalizedString("vsan.policy.siteTolerance.dualSiteMirroring", new String[0]) : PbmUtil.getLocalizedString("vsan.policy.siteTolerance.noneWithNestedFDs", new String[0]));
        }
        PropertyData propertyData = PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.siteDisasterTolerance", new String[0]), stTolerance);
        return propertyData;
    }

    static PropertyData getReadCacheReservationPropertyData(VsanCapabilitiesData vsanCapabilitiesData) {
        BigDecimal rawValue = BigDecimal.valueOf(vsanCapabilitiesData.readCacheReservation);
        BigDecimal percentValue = rawValue.divide(BigDecimal.valueOf(10000L), 4, RoundingMode.FLOOR);
        String readCacheValue = PbmUtil.getLocalizedString("vsan.policy.readCacheReservation.percentageFormat", Integer.toString(percentValue.intValue()));
        return PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.readCacheReservation", new String[0]), readCacheValue);
    }

    static PropertyData getObjectSpaceReservationPropertyData(VsanCapabilitiesData vsanCapabilitiesData) {
        String objectSpaceReservation;
        switch (vsanCapabilitiesData.objectSpaceReservation) {
            case 0: {
                objectSpaceReservation = PbmUtil.getLocalizedString("vsan.policy.objSpaceReservation.thin", new String[0]);
                break;
            }
            case 100: {
                objectSpaceReservation = PbmUtil.getLocalizedString("vsan.policy.objSpaceReservation.thick", new String[0]);
                break;
            }
            default: {
                objectSpaceReservation = PbmUtil.getLocalizedString("vsan.policy.objSpaceReservation.percentageFormat", Integer.toString(vsanCapabilitiesData.objectSpaceReservation));
            }
        }
        return PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.objectSpaceReservation", new String[0]), objectSpaceReservation);
    }

    static PropertyData getFailuresToToleratePropertyData(VsanCapabilitiesData vsanCapabilitiesData, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        int ftt;
        int n = ftt = vsanCapabilitiesData.isStretchedCluster || vsanCapabilitiesData.isNestedFd ? vsanCapabilitiesData.secondaryFtt : vsanCapabilitiesData.primaryFtt;
        String fttValue = ftt == 0 ? (LOCALITY_HOST_LOCAL.equals(vsanCapabilitiesData.locality) ? PbmUtil.getLocalizedString("vsan.policy.ft.noneWithHostAffinity", new String[0]) : PbmUtil.getLocalizedString("vsan.policy.ft.none", new String[0])) : (ftt == 3 ? PbmUtil.getLocalizedString("vsan.policy.ft.threeFailuresMirror", new String[0]) : (VsanCapabilitiesFormatter.containsVsanCapability(namespaceMetadata, LOCALITY_CAPABILITY) && vsanCapabilitiesData.replicaPreference.equals(RAID5) ? (ftt == 1 ? PbmUtil.getLocalizedString("vsan.policy.ft.oneFailureErasureCoding", new String[0]) : PbmUtil.getLocalizedString("vsan.policy.ft.twoFailuresErasureCoding", new String[0])) : (ftt == 1 ? PbmUtil.getLocalizedString("vsan.policy.ft.oneFailureMirror", new String[0]) : PbmUtil.getLocalizedString("vsan.policy.ft.twoFailuresMirror", new String[0]))));
        return PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.failuresToTolerate", new String[0]), fttValue);
    }

    static PropertyData getFaultDomainsToToleratePropertyData(VsanCapabilitiesData vsanCapabilitiesData) {
        String fttValue = "";
        switch (vsanCapabilitiesData.primaryFtt) {
            case 0: {
                fttValue = PbmUtil.getLocalizedString("vsan.policy.ft.none", new String[0]);
                break;
            }
            case 1: {
                fttValue = PbmUtil.getLocalizedString("vsan.policy.ft.oneFailureMirror", new String[0]);
            }
        }
        return PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.faultDomainsToTolerate", new String[0]), fttValue);
    }

    static <T> T getCapabilityValue(List<CapabilityInstance> capabilityInstances, String capability, T defaultValue) {
        for (CapabilityInstance item : capabilityInstances) {
            if (!item.id.id.equals(capability)) continue;
            return (T)item.constraint[0].propertyInstance[0].value;
        }
        return defaultValue;
    }

    static <T> T getPropertyInstanceValue(CapabilityInstance capabilityInstance, String property, T defaultValue) {
        for (ConstraintInstance constraint : capabilityInstance.constraint) {
            for (PropertyInstance propertyInstance : constraint.propertyInstance) {
                if (!propertyInstance.id.equals(property)) continue;
                return (T)propertyInstance.value;
            }
        }
        return defaultValue;
    }

    static String getFormattedNumber(int quiescedSnapshot) {
        if (quiescedSnapshot == 0) {
            return PbmUtil.getLocalizedString("vsan.sp.dp.noQuiescedSnapshot", new String[0]);
        }
        String formattedSnapshot = Integer.toString(quiescedSnapshot);
        String snapshotSuffix = PbmUtil.getLocalizedString("vsan.sp.dp.everyNthSnapshot", formattedSnapshot);
        if (formattedSnapshot.length() > 1 && formattedSnapshot.charAt(formattedSnapshot.length() - 2) == '1') {
            return snapshotSuffix;
        }
        switch (quiescedSnapshot % 10) {
            case 1: {
                return PbmUtil.getLocalizedString("vsan.sp.dp.everyFirstSnapshot", formattedSnapshot);
            }
            case 2: {
                return PbmUtil.getLocalizedString("vsan.sp.dp.everySecondSnapshot", formattedSnapshot);
            }
            case 3: {
                return PbmUtil.getLocalizedString("vsan.sp.dp.everyThirdSnapshot", formattedSnapshot);
            }
        }
        return PbmUtil.getLocalizedString("vsan.sp.dp.everyNthSnapshot", formattedSnapshot);
    }

    static class VsanCapabilitiesData {
        public boolean isStretchedCluster;
        public boolean isNestedFd;
        public int primaryFtt;
        public int secondaryFtt;
        public String locality;
        public String replicaPreference;
        public int diskStripes;
        public int iopsLimit;
        public boolean checksumDisabled;
        public int readCacheReservation;
        public int objectSpaceReservation;
        public boolean forceProvisioning;
        public boolean hasLocalProtectionCapabilitySet;
        public boolean hasArchivalProtectionCapabilitySet;
        public boolean hasRemoteProtectionCapabilitySet;
        public int localSnapshotFrequencyInMinutes;
        public int quiesceEveryMthLocalSnapshot;
        public int localInstancesToRetain;
        public int archiveEveryMthSnapshot;
        public int archivalSnapshotsToRetain;
        public int remoteRpo;
        public int remoteInstancesRetained;
        public String remotePolicyTag;

        public VsanCapabilitiesData() {
        }

        public VsanCapabilitiesData(boolean isStretchedCluster, boolean isNestedFd, int primaryFtt, int secondaryFtt, String locality, String replicaPreference, int diskStripes, int iopsLimit, boolean checksumDisabled, int readCacheReservation, int objectSpaceReservation, boolean forceProvisioning) {
            this.isStretchedCluster = isStretchedCluster;
            this.isNestedFd = isNestedFd;
            this.primaryFtt = primaryFtt;
            this.secondaryFtt = secondaryFtt;
            this.locality = locality;
            this.replicaPreference = replicaPreference;
            this.diskStripes = diskStripes;
            this.iopsLimit = iopsLimit;
            this.checksumDisabled = checksumDisabled;
            this.readCacheReservation = readCacheReservation;
            this.objectSpaceReservation = objectSpaceReservation;
            this.forceProvisioning = forceProvisioning;
        }
    }
}

