/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.rp.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateRpPropertyProvider
implements PropertyProviderBean {
    private final QuerySpecBuilder _querySpecBuilder;
    private final QueryExecutor _queryExecutor;
    private static final String PARENT_RELATION = "parent";
    private static final String RP_RELATION = "resourcePool";
    private static final String HAS_PRIVILEGES_PROP = "hasPrivileges";
    private static final String DISABLED_OPERATIONS_PROP = "disabledOperations";
    private static final String HOST_CONN_STATE_PROP = "runtime.connectionState";
    private static final String CREATE_RP_PRIVILEGE = "Resource.CreatePool";
    private static final String CREATE_RP_METHOD_NAME = "CreateResourcePool";
    private static final String CLUSTER_TYPE = ClusterComputeResource.class.getSimpleName();
    private static final String COMPUTE_RESOURCE_TYPE = ComputeResource.class.getSimpleName();
    private static final String HOST_TYPE = HostSystem.class.getSimpleName();
    private static final String RP_TYPE = ResourcePool.class.getSimpleName();
    private static final Log LOGGER = LogFactory.getLog(CreateRpPropertyProvider.class);

    public CreateRpPropertyProvider(QuerySpecBuilder querySpecBuilder, QueryExecutor queryExecutor) {
        this._querySpecBuilder = querySpecBuilder;
        this._queryExecutor = queryExecutor;
    }

    @type(value="HostSystem,ClusterComputeResource,ResourcePool,VirtualApp")
    public boolean getIsRpCreationAllowed(ManagedObjectReference target) {
        QuerySpec querySpec = this.getQuerySpecForTarget(target);
        ResultSet result = this.retrieveData(querySpec);
        if (result == null) {
            return true;
        }
        return this.isRpCreationAllowedInTarget(target, result);
    }

    private QuerySpec getQuerySpecForTarget(ManagedObjectReference target) {
        if (HOST_TYPE.equals(target.getType())) {
            return this.newQuerySpecForRpCreationInHost(target);
        }
        Object rpConstraint = null;
        rpConstraint = CLUSTER_TYPE.equals(target.getType()) ? this._querySpecBuilder.createConstraintForRelationship((Object)target, RP_RELATION, RP_TYPE) : this._querySpecBuilder.createObjectIdentityConstraint((Object)target);
        return CreateRpPropertyProvider.newQuerySpecForRpCreationInRp((Constraint)rpConstraint);
    }

    private boolean isRpCreationAllowedInTarget(ManagedObjectReference target, ResultSet result) {
        if (HOST_TYPE.equals(target.getType())) {
            return CreateRpPropertyProvider.isRpCreationAllowedInHost(result);
        }
        return CreateRpPropertyProvider.isRpCreationAllowedInRp(result.items[0]);
    }

    private ResultSet retrieveData(QuerySpec querySpec) {
        ResultSet result = null;
        try {
            result = this._queryExecutor.getData(querySpec);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Data retrieval error occurred while calculating isRpCreationAllowed", (Throwable)e);
            return null;
        }
        if (result == null || ArrayUtil.isNullOrEmpty((Object[])result.items) || result.items[0] == null) {
            LOGGER.warn((Object)"Invalid data retrieved while calculating isRpCreationAllowed");
            return null;
        }
        return result;
    }

    private static QuerySpec newQuerySpecForRpCreationInRp(Constraint rpConstraint) {
        ResourceSpec rSpec = new ResourceSpec();
        rSpec.constraint = rpConstraint;
        rSpec.propertySpecs = new PropertySpec[]{CreateRpPropertyProvider.newAuthRpCreationPropSpec()};
        QuerySpec qSpec = new QuerySpec();
        qSpec.resourceSpec = rSpec;
        qSpec.name = "isRpCreationAllowed-rp-data";
        return qSpec;
    }

    private static PropertySpec newAuthRpCreationPropSpec() {
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.propertyName = HAS_PRIVILEGES_PROP;
        paramSpec.parameter = new String[]{CREATE_RP_PRIVILEGE};
        PropertySpec propSpec = new PropertySpec();
        propSpec.propertyNames = new String[]{HAS_PRIVILEGES_PROP, DISABLED_OPERATIONS_PROP};
        propSpec.parameters = new ParameterSpec[]{paramSpec};
        propSpec.type = RP_TYPE;
        return propSpec;
    }

    private static boolean isRpCreationAllowedInRp(ResultItem rootRpData) {
        for (PropertyValue value : rootRpData.properties) {
            String[] array;
            HashSet<String> disabledOps;
            if (HAS_PRIVILEGES_PROP.equals(value.propertyName)) {
                boolean hasPrivileges = (Boolean)value.value;
                if (hasPrivileges) continue;
                LOGGER.info((Object)"Missing privileges for resource pool creation");
                return false;
            }
            if (!DISABLED_OPERATIONS_PROP.equals(value.propertyName) || !(disabledOps = new HashSet<String>(Arrays.asList(array = (String[])value.value))).contains(CREATE_RP_METHOD_NAME)) continue;
            LOGGER.info((Object)"Resource pool creation method is disabled");
            return false;
        }
        return true;
    }

    private QuerySpec newQuerySpecForRpCreationInHost(ManagedObjectReference host) {
        ResourceSpec rSpec = new ResourceSpec();
        rSpec.constraint = this.createHostConstraints(host);
        rSpec.propertySpecs = new PropertySpec[]{CreateRpPropertyProvider.newAuthRpCreationPropSpec(), CreateRpPropertyProvider.newHostParentPropSpec(), CreateRpPropertyProvider.newHostConnStatePropSpec()};
        QuerySpec qSpec = new QuerySpec();
        qSpec.resourceSpec = rSpec;
        qSpec.name = "isRpCreationAllowed-host-data";
        return qSpec;
    }

    private Constraint createHostConstraints(ManagedObjectReference host) {
        ObjectIdentityConstraint hostConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)host);
        Constraint parentConstraint = this._querySpecBuilder.createConstraintForRelationship((Object)host, PARENT_RELATION, COMPUTE_RESOURCE_TYPE);
        RelationalConstraint rootRpConstraint = this._querySpecBuilder.createRelationalConstraint(RP_RELATION, parentConstraint, Boolean.valueOf(true), RP_TYPE);
        Constraint result = this._querySpecBuilder.combineIntoSingleConstraint(new Constraint[]{hostConstraint, parentConstraint, rootRpConstraint}, Conjoiner.OR);
        return result;
    }

    private static PropertySpec newHostParentPropSpec() {
        PropertySpec propSpec = new PropertySpec();
        propSpec.propertyNames = new String[0];
        propSpec.type = COMPUTE_RESOURCE_TYPE;
        return propSpec;
    }

    private static PropertySpec newHostConnStatePropSpec() {
        PropertySpec propSpec = new PropertySpec();
        propSpec.propertyNames = new String[]{HOST_CONN_STATE_PROP};
        propSpec.type = HOST_TYPE;
        return propSpec;
    }

    private static boolean isRpCreationAllowedInHost(ResultSet data) {
        for (ResultItem item : data.items) {
            ManagedObjectReference resource = (ManagedObjectReference)item.resourceObject;
            if (CLUSTER_TYPE.equals(resource.getType())) {
                LOGGER.info((Object)"Resource pool creation is not allowed in clustered host");
                return false;
            }
            if (RP_TYPE.equals(resource.getType()) && !CreateRpPropertyProvider.isRpCreationAllowedInRp(item)) {
                LOGGER.info((Object)"Resource pool creation is not authorized");
                return false;
            }
            if (!HOST_TYPE.equals(resource.getType()) || ArrayUtil.isNullOrEmpty((Object[])item.properties)) continue;
            PropertyValue prop = item.properties[0];
            HostSystem.ConnectionState hostState = (HostSystem.ConnectionState)prop.value;
            if (HostSystem.ConnectionState.connected.equals((Object)hostState)) continue;
            LOGGER.info((Object)"Resource pool creation is only allowed in connected hosts");
            return false;
        }
        return true;
    }
}

