/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vise.util.FormatUtil;

@QueryBinding(value="HostSystem")
public class HostPmemData {
    @Property(value="HostSystem/hardware/persistentMemoryInfo/capacityInMB")
    public Long totalPmem;
    @Property(value="HostSystem/availablePMem")
    public Long freePmem;

    public String getPmemUsageText() {
        if (this.totalPmem == null || this.freePmem == null) {
            return HostPmemData.formatDataSize(0, 0x100000L);
        }
        return HostPmemData.formatDataSize(this.totalPmem - this.freePmem, 0x100000L);
    }

    public String getPmemUsagePercentage() {
        if (this.totalPmem == null || this.freePmem == null || this.totalPmem == 0L) {
            return String.format("%.0f", 0.0);
        }
        return String.format("%.0f", Float.valueOf((float)(this.totalPmem - this.freePmem) * 100.0f / (float)this.totalPmem.longValue()));
    }

    public String getPmemSizeText() {
        if (this.totalPmem == null || this.freePmem == null) {
            return HostPmemData.formatDataSize(0, 0x100000L);
        }
        return HostPmemData.formatDataSize(this.totalPmem, 0x100000L);
    }

    private static String formatDataSize(Number bytes, long base) {
        return FormatUtil.getDataSizeFormatted((Number)bytes, (int)2, (long)base, (long)-1L, (boolean)true);
    }
}

