/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.config;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.host.EsxAgentHostManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.mutation.MutationMapping;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.host.util.Util;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentVmSettingsProvider
implements PropertyProviderBean,
MutationProvider {
    private static final Log _logger = LogFactory.getLog(AgentVmSettingsProvider.class);
    private static final String PROPERTY_NETWORK = "allNetwork";
    private static final String PROPERTY_DATASTORE = "datastore";
    private static final String SUMMARY_NAME = "summary.name";
    private static final String IS_UPLINK_PORTGROUP = "isUplinkPortgroup";
    private static final String DS_NW_QUERY_NAME = "agentVm.datastore.and.network";
    private DataService _dataService;
    private LegacyAuthorizationService _authService;

    public AgentVmSettingsProvider(DataService dataService, LegacyAuthorizationService authService) {
        this._dataService = dataService;
        this._authService = authService;
    }

    @type(value="HostSystem")
    public DynamicObject getAgentVmSettings(ManagedObjectReference hostRef) throws Exception {
        Constraint dsConstraint = QueryUtil.createConstraintForRelationship((Object)hostRef, (String)"summary.config.agentVmDatastore", (String)"Datastore");
        Constraint nwOnlyConstraint = new Constraint();
        nwOnlyConstraint.targetType = Network.class.getSimpleName();
        Constraint onwOnlyConstraint = new Constraint();
        onwOnlyConstraint.targetType = OpaqueNetwork.class.getSimpleName();
        PropertyConstraint nonUplinkConstraint = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)IS_UPLINK_PORTGROUP, (Comparator)Comparator.EQUALS, (Object)false);
        Constraint nonUplinkNwConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{nwOnlyConstraint, onwOnlyConstraint, nonUplinkConstraint}, (Conjoiner)Conjoiner.OR);
        Constraint nwConstraint = QueryUtil.createConstraintForRelationship((Object)hostRef, (String)"summary.config.agentVmNetwork", (String)"AnyNetwork");
        Constraint allNwConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{nwConstraint, nonUplinkNwConstraint}, (Conjoiner)Conjoiner.AND);
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{dsConstraint, allNwConstraint}, (Conjoiner)Conjoiner.OR);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{SUMMARY_NAME});
        query.name = DS_NW_QUERY_NAME;
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        if (resultSet.error != null) {
            _logger.error((Object)resultSet.error);
        }
        Object[] resultItems = resultSet.items;
        String datastoreName = "";
        String networkName = "";
        if (!ArrayUtil.isNullOrEmpty((Object[])resultItems)) {
            for (Object resultItem : resultItems) {
                Object[] propValues = ((ResultItem)resultItem).properties;
                if (ArrayUtil.isNullOrEmpty((Object[])propValues)) continue;
                for (Object propValue : propValues) {
                    if (!SUMMARY_NAME.equals(((PropertyValue)propValue).propertyName)) continue;
                    ManagedObjectReference resourceMor = (ManagedObjectReference)((PropertyValue)propValue).resourceObject;
                    if (ManagedObjectUtil.isOfType((ManagedObjectReference)resourceMor, Datastore.class)) {
                        datastoreName = (String)((PropertyValue)propValue).value;
                        continue;
                    }
                    if (!this.isOfAnyNetworkType(resourceMor)) continue;
                    networkName = (String)((PropertyValue)propValue).value;
                }
            }
        }
        DynamicObject result = new DynamicObject();
        result.properties = new NameValuePair[]{new NameValuePair(PROPERTY_DATASTORE, (Object)datastoreName), new NameValuePair(PROPERTY_NETWORK, (Object)networkName)};
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, property="agentVmSettings.@info.immutable")
    public boolean getAgentVmSettingsImmutable(ManagedObjectReference hostRef) {
        return !Util.checkHostAvailability(hostRef, new String[]{"Host.Config.Settings"}, this._dataService, this._authService);
    }

    @MutationMapping(type="HostSystem", property="agentVmSettings")
    public OperationResult applyAgentVmSettings(ManagedObjectReference hostRef, Map<String, Object> args) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            Object network;
            PropertyValue[] props = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)hostRef, (String)"configManager.esxAgentHostManager", (String)"EsxAgentHostManager", (String[])new String[]{"configInfo"});
            EsxAgentHostManager manager = (EsxAgentHostManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)((ManagedObjectReference)props[0].resourceObject));
            EsxAgentHostManager.ConfigInfo configInfo = (EsxAgentHostManager.ConfigInfo)props[0].value;
            Object datastore = args.get(PROPERTY_DATASTORE);
            if (datastore != null) {
                configInfo.agentVmDatastore = Util.lookupDatastoreRef(hostRef, (String)datastore, this._dataService);
            }
            if ((network = args.get(PROPERTY_NETWORK)) != null) {
                configInfo.agentVmNetwork = Util.lookupNetworkRef(hostRef, (String)network, this._dataService);
            }
            manager.updateConfig(configInfo);
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private boolean isOfAnyNetworkType(ManagedObjectReference moRef) {
        return ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, Network.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, DistributedVirtualPortgroup.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, OpaqueNetwork.class);
    }
}

