/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.compositecommand.factory;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vise.data.query.DataService;
import com.vmware.vsphere.client.common.compositecommand.BaseCommand;
import com.vmware.vsphere.client.common.compositecommand.CommandFactory;
import com.vmware.vsphere.client.common.compositecommand.DummyCommand;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.api.spec.DummyCommandSpec;
import com.vmware.vsphere.client.host.compositecommand.commands.ReconfigureHostDasCommand;
import com.vmware.vsphere.client.host.compositecommand.commands.SetClusterAdvancedOptionsCommand;
import com.vmware.vsphere.client.host.compositecommand.specs.ReconfigureHostDasCommandSpec;
import com.vmware.vsphere.client.host.compositecommand.specs.SetClusterAdvancedOptionsCommandSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCommandFactory
extends CommandFactory {
    private static final Log _logger = LogFactory.getLog(HostCommandFactory.class);

    public BaseCommand createCommand(BaseCommandSpec commandSpec, BaseCommand parentCommand, DataService dataService) {
        try {
            if (commandSpec instanceof DummyCommandSpec) {
                return this.createConcreteCommand((DummyCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof SetClusterAdvancedOptionsCommandSpec) {
                return this.createConcreteCommand((SetClusterAdvancedOptionsCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof ReconfigureHostDasCommandSpec) {
                return this.createConcreteCommand((ReconfigureHostDasCommandSpec)commandSpec, parentCommand);
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
        }
        return null;
    }

    private BaseCommand createConcreteCommand(DummyCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec((BaseCommandSpec)commandSpec, parentCommand, null);
        return new DummyCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(SetClusterAdvancedOptionsCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{ClusterComputeResource.class.getSimpleName()});
        return new SetClusterAdvancedOptionsCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(ReconfigureHostDasCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{HostSystem.class.getSimpleName()});
        return new ReconfigureHostDasCommand(commandSpec);
    }
}

