/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.wizardinfo.triggercategories;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.triggercategories.AlarmTriggerCategoryConfig;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.triggercategories.MOAlarmTriggerCategoriesConfig;
import java.io.IOException;
import java.net.URL;

public class AlarmTriggerCategoryUtil {
    private static final String CONFIG_FILE_PATH = "/AlarmTriggerCategories.json";

    public static AlarmTriggerCategoryConfig[] getTriggerCategories(String moType) {
        URL resource = AlarmTriggerCategoryUtil.class.getResource(CONFIG_FILE_PATH);
        if (resource == null) {
            throw new IllegalStateException("Could not find alarm config: /AlarmTriggerCategories.json");
        }
        try {
            MOAlarmTriggerCategoriesConfig[] configData;
            ObjectMapper objectMapper = new ObjectMapper();
            for (MOAlarmTriggerCategoriesConfig objConfig : configData = (MOAlarmTriggerCategoriesConfig[])objectMapper.readValue(resource, MOAlarmTriggerCategoriesConfig[].class)) {
                if (!moType.equals(objConfig.moType)) continue;
                return objConfig.categories;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new AlarmTriggerCategoryConfig[0];
    }
}

