/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.vmware.opsmgmt.client.extension.alarms.configuration.Trigger;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.ResourceUtil;

public class Localization {
    private static final String OPSMGMT_STRINGS = "opsmgmtservice";
    public static final String RES_PREFIX = "Alarm.Metadata.";
    private static final String TRIGGER_CATEGORY_KEY_FORMAT = "%s.triggerCategory.%s";

    public static String getString(String key) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{key});
        return ResourceUtil.getString((String)OPSMGMT_STRINGS, (String)key, (ClassLoader)Localization.class.getClassLoader());
    }

    public static String getFormattedString(String key, String[] args) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{key, args});
        return ResourceUtil.getString((String)OPSMGMT_STRINGS, (String)key, (String[])args, (ClassLoader)Localization.class.getClassLoader());
    }

    public static String getTriggerName(Trigger trigger) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{trigger});
        String key = RES_PREFIX + trigger.nameResourceId;
        return ResourceUtil.getString((String)"VpxClientStrings", (String)key, (ClassLoader)Localization.class.getClassLoader());
    }

    public static String getVpxString(String key) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{key});
        return ResourceUtil.getString((String)"VpxClientStrings", (String)key, (ClassLoader)Localization.class.getClassLoader());
    }

    public static String getVpxString(String key, String[] args) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{key, args});
        return ResourceUtil.getString((String)"VpxClientStrings", (String)key, (String[])args, (ClassLoader)Localization.class.getClassLoader());
    }

    public static String getTriggerCategoryName(String moType, String categoryKey) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{moType, categoryKey});
        String key = String.format(TRIGGER_CATEGORY_KEY_FORMAT, moType, categoryKey);
        return Localization.getString(key);
    }
}

