/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.google.common.base.Optional;
import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.AlarmsUtil;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.actions.ActionGroupFactory;
import com.vmware.opsmgmt.client.extension.alarms.actions.AlarmActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.configuration.AlarmConfiguration;
import com.vmware.opsmgmt.client.extension.alarms.configuration.AlarmConfigurator;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionGroup;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionFactory;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmDetails;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmRuleJoiner;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmRulesSummaryBuilder;
import com.vmware.opsmgmt.client.extension.alarms.expressions.AlarmExpressionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorType;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.MonitorTypeInfoConfigUtil;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlarmDetailsCreator {
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;
    private AlarmConfiguration _alarmConfig;
    private static final String ALARM_INFO = "info";
    private static final String ALARM_DEFINITION_INFO = "alarmDefinitionInfo";
    private static final String ALARM_INFO_ENTITY_NAME = "name";
    private static final String FOLDER = "Folder";
    private static final String FOLDER_RES_KEY_TEMPLATE = "Alarm.MonitorObject.%s.lower";
    private static final String LOWER_EXTENSION = ".lower";

    public AlarmDetailsCreator(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryExecutor});
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._alarmConfig = new AlarmConfigurator().parseConfig();
    }

    public AlarmDetails createAlarmDetails(Object alarm) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarm});
        Optional<AlarmDefinitionInfo> adiOpt = this.getAlarmDefinitionInfo(alarm);
        if (!adiOpt.isPresent()) {
            return null;
        }
        AlarmDefinitionInfo alarmDefInfo = (AlarmDefinitionInfo)adiOpt.get();
        AlarmInfo ai = (AlarmInfo)this._queryExecutor.getProperty(alarm, ALARM_INFO);
        AlarmExpressionWrapper wrapper = new AlarmExpressionWrapper(ai.expression);
        AlarmDetails alarmDetails = new AlarmDetails();
        alarmDetails.monitorTypeSummary = this.getMonitorTypeSummary(ai);
        List<TriggerConditionGroup> triggerConditionGroups = new TriggerConditionFactory().build(wrapper, alarmDefInfo);
        List<ActionGroup> actions = this.createActionGroups(alarmDefInfo, ai);
        AlarmRuleJoiner alarmRuleJoiner = wrapper.getIsAndExpression() ? AlarmRuleJoiner.AND : AlarmRuleJoiner.OR;
        alarmDetails.rules = new AlarmRulesSummaryBuilder(triggerConditionGroups, alarmRuleJoiner, actions, this.secondsToMinutes(ai.actionFrequency)).build();
        return alarmDetails;
    }

    private String test(AlarmInfo info) {
        return AlarmsUtil.getMonitorType(info.expression);
    }

    private Optional<AlarmDefinitionInfo> getAlarmDefinitionInfo(Object alarm) throws Exception {
        QuerySpec alarmDefQuerySpec = this._querySpecBuilder.buildQuerySpec(alarm, new String[]{ALARM_DEFINITION_INFO});
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.propertyName = ALARM_DEFINITION_INFO;
        paramSpec.parameter = this._alarmConfig.getServerCollection().toArray();
        alarmDefQuerySpec.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{paramSpec};
        ResultSet resultSet = this._queryExecutor.getData(alarmDefQuerySpec);
        if (resultSet == null || resultSet.items == null) {
            return Optional.absent();
        }
        for (ResultItem resultItem : resultSet.items) {
            if (resultItem == null || resultItem.properties == null) continue;
            for (PropertyValue propValue : resultItem.properties) {
                if (propValue == null || !ALARM_DEFINITION_INFO.equals(propValue.propertyName)) continue;
                return Optional.of((Object)((AlarmDefinitionInfo)propValue.value));
            }
        }
        return Optional.absent();
    }

    private List<ActionGroup> createActionGroups(AlarmDefinitionInfo alarmDefInfo, AlarmInfo ai) {
        if (ai.action == null) {
            return Collections.emptyList();
        }
        Map<ManagedObjectReference, String> namesMap = this.buildObjectNamesMap(alarmDefInfo);
        ActionGroupFactory actionGroupFactory = new ActionGroupFactory();
        AlarmActionWrapper wrapper = new AlarmActionWrapper(ai.action);
        List<ActionGroup> actionGroups = actionGroupFactory.build(wrapper, namesMap);
        return actionGroups;
    }

    private Map<ManagedObjectReference, String> buildObjectNamesMap(AlarmDefinitionInfo alarmDefInfo) {
        if (alarmDefInfo == null || ArrayUtil.isNullOrEmpty((Object[])alarmDefInfo.migrateActionArgs)) {
            return Collections.emptyMap();
        }
        HashMap<ManagedObjectReference, String> names = new HashMap<ManagedObjectReference, String>();
        for (PropertyValue name : alarmDefInfo.migrateActionArgs) {
            ManagedObjectReference sor = (ManagedObjectReference)name.resourceObject;
            names.put(sor, (String)name.value);
        }
        return names;
    }

    private String getMonitorTypeSummary(AlarmInfo alarmInfo) throws Exception {
        String entityType;
        String monitorFQDN = AlarmsUtil.getMonitorType(alarmInfo.expression);
        if (monitorFQDN == null) {
            return "";
        }
        Object monitorType = monitorFQDN;
        Object[] monitorFQDNParts = monitorFQDN.split("\\.");
        if (!ArrayUtil.isNullOrEmpty((Object[])monitorFQDNParts)) {
            monitorType = monitorFQDNParts[monitorFQDNParts.length - 1];
        }
        if (((String)monitorType).equals(entityType = AlarmsUtil.getNormalizeType(alarmInfo.entity))) {
            return AlarmsUtil.getLocalizedMonitorType(monitorFQDN);
        }
        boolean isFolderEntity = FOLDER.equals(alarmInfo.entity.getType());
        List<AlarmMonitorType> monitorTypeList = MonitorTypeInfoConfigUtil.getMonitorTypeInfoConfig(alarmInfo.entity);
        String entityTypeLocalized = null;
        String monitorTypeLocalized = null;
        if (isFolderEntity) {
            entityTypeLocalized = Localization.getVpxString(String.format(FOLDER_RES_KEY_TEMPLATE, entityType));
        }
        for (AlarmMonitorType monitorTypeInfo : monitorTypeList) {
            if (!isFolderEntity && monitorTypeInfo.getType().equals(alarmInfo.entity.getType())) {
                entityTypeLocalized = this.getLocalizedMonitorTypeLower(monitorTypeInfo.getI18Key());
                continue;
            }
            if (!monitorTypeInfo.getType().equals(monitorType)) continue;
            monitorTypeLocalized = this.getLocalizedMonitorTypeLower(monitorTypeInfo.getI18Key());
        }
        if (StringUtil.isNullOrEmpty(entityTypeLocalized) || StringUtil.isNullOrEmpty(monitorTypeLocalized)) {
            return AlarmsUtil.getLocalizedMonitorType(monitorFQDN);
        }
        String entityName = (String)this._queryExecutor.getProperty((Object)alarmInfo.entity, ALARM_INFO_ENTITY_NAME);
        return Localization.getFormattedString("alarm.monitor.type.summary.template", new String[]{monitorTypeLocalized, entityTypeLocalized, entityName});
    }

    private int secondsToMinutes(Integer seconds) {
        return seconds == null ? 0 : seconds / 60;
    }

    private String getLocalizedMonitorTypeLower(String key) {
        return Localization.getVpxString(key + LOWER_EXTENSION);
    }
}

