/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.vmware.vim.binding.rbd.Rule;
import com.vmware.vim.binding.rbd.RuleData;
import com.vmware.vim.binding.rbd.RuleManager;
import com.vmware.vim.binding.rbd.RuleSet;
import com.vmware.vim.binding.rbd.WorkingRuleSet;
import com.vmware.vim.binding.rbd.fault.InvalidRuleSpecFault;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.host.CheckHostComplianceSpec;
import com.vmware.vsphere.client.h5.autodeploy.host.CheckMultiHostComplianceSpec;
import com.vmware.vsphere.client.h5.autodeploy.host.RemediateHostSpec;
import com.vmware.vsphere.client.h5.autodeploy.impl.HostOpsPropertyProvider;
import com.vmware.vsphere.client.h5.autodeploy.rule.ActivateRulesSpec;
import com.vmware.vsphere.client.h5.autodeploy.rule.CreateRuleSpec;
import com.vmware.vsphere.client.h5.autodeploy.rule.DeleteRuleSpec;
import com.vmware.vsphere.client.h5.autodeploy.rule.EditRuleContentsSpec;
import com.vmware.vsphere.client.h5.autodeploy.rule.HostComplianceData;
import com.vmware.vsphere.client.h5.autodeploy.rule.TestActiveRulesSpec;
import com.vmware.vsphere.client.h5.autodeploy.rule.ValidateRuleContentsSpec;
import com.vmware.vsphere.client.h5.autodeploy.rule.ValidateRuleNameSpec;
import com.vmware.vsphere.client.h5.autodeploy.util.HostComplianceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(RuleMutationProvider.class);
    private final AutoDeployServiceFactory _serviceFactory;
    private final QueryExecutor _queryExecutor;
    private final HostOpsPropertyProvider _hostOpsProvider;
    private final TaskMonitor _taskMonitor;

    private static String text(String key) {
        return ResourceUtil.getString((String)"autodeployservice", (String)key, (ClassLoader)RuleMutationProvider.class.getClassLoader());
    }

    private static boolean areNullOrEqual(ManagedObjectReference object1, ManagedObjectReference object2) {
        if (object1 == null && object2 == null) {
            return true;
        }
        return ManagedObjectUtil.areEqual((ManagedObjectReference)object1, (ManagedObjectReference)object2);
    }

    public RuleMutationProvider(AutoDeployServiceFactory serviceFactory, QueryExecutor queryService, HostOpsPropertyProvider hostOpsProvider, TaskMonitor taskMonitor) {
        this._serviceFactory = (AutoDeployServiceFactory)Preconditions.checkNotNull((Object)serviceFactory);
        this._queryExecutor = (QueryExecutor)Preconditions.checkNotNull((Object)queryService);
        this._hostOpsProvider = (HostOpsPropertyProvider)Preconditions.checkNotNull((Object)hostOpsProvider);
        this._taskMonitor = taskMonitor;
    }

    public OperationResult apply(ManagedObjectReference rootFolderRef, ActivateRulesSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = rootFolderRef;
        try {
            Preconditions.checkNotNull((Object)spec.rulesToActivate, (Object)"Rules to activate cannot be null.");
            AutoDeployService autoDeployService = this._serviceFactory.getService(rootFolderRef.getServerGuid());
            RuleManager ruleManager = autoDeployService.getRuleManager();
            ManagedObjectReference[] ruleSetRefs = ruleManager.retrieveRuleSetList();
            ManagedObjectReference workingSet = ruleSetRefs[0];
            result.entity = workingSet;
            WorkingRuleSet ruleSet = (WorkingRuleSet)autoDeployService.getManagedObject(workingSet);
            RuleSet.RuleSetSpec ruleSetSpec = ruleSet.retrieveSpec();
            ruleSetSpec.ruleList = spec.rulesToActivate;
            ruleSet.update(ruleSetSpec);
            ruleManager.activate(workingSet);
            if (!ArrayUtil.isNullOrEmpty((Object[])spec.hostsToRemediate)) {
                this.applyOnMultiEntity(spec.hostsToRemediate, new RemediateHostSpec());
            }
        }
        catch (Exception ex) {
            result.error = ex;
        }
        return result;
    }

    public ValidationResult validate(ValidateRuleNameSpec spec) {
        ValidationResult result = new ValidationResult();
        try {
            RuleData[] allRulesData;
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)spec.ruleName) ? 1 : 0) != 0);
            AutoDeployService autoDeployService = this._serviceFactory.getService(spec.vcServerGuid);
            RuleManager ruleManager = autoDeployService.getRuleManager();
            ManagedObjectReference ruleWithSameName = null;
            for (RuleData ruleData : allRulesData = ruleManager.retrieveRuleObjects()) {
                String ruleName = ruleData.getMetadataObject().name;
                if (!ruleName.equalsIgnoreCase(spec.ruleName)) continue;
                ruleWithSameName = ruleData.rule;
                break;
            }
            Boolean isNameValid = ruleWithSameName == null || ManagedObjectUtil.areEqual(ruleWithSameName, (ManagedObjectReference)spec.ruleReference) != false;
            result.result = isNameValid;
        }
        catch (Exception ex) {
            result.error = ex;
        }
        return result;
    }

    public ValidationResult validate(TestActiveRulesSpec spec) {
        ValidationResult result = new ValidationResult();
        try {
            Preconditions.checkNotNull((Object)spec.testHost);
            AutoDeployService autoDeployService = this._serviceFactory.getService(spec.testHost.getServerGuid());
            RuleManager ruleManager = autoDeployService.getRuleManager();
            ManagedObjectReference[] ruleSetRefs = ruleManager.retrieveRuleSetList();
            ManagedObjectReference workingSet = ruleSetRefs[0];
            WorkingRuleSet ruleSet = (WorkingRuleSet)autoDeployService.getManagedObject(workingSet);
            RuleSet.RuleSetSpec ruleSetSpec = ruleSet.retrieveSpec();
            ruleSetSpec.ruleList = spec.rulesToActivate;
            ruleSet.update(ruleSetSpec);
            result.result = this.checkHostCompliance(spec.testHost, (RuleSet)ruleSet);
        }
        catch (Exception ex) {
            result.error = ex;
        }
        return result;
    }

    public ValidationResult validate(CheckHostComplianceSpec spec) {
        Preconditions.checkNotNull((Object)spec.host);
        ValidationResult result = new ValidationResult();
        try {
            AutoDeployService autoDeploy = this._serviceFactory.getService(spec.host.getServerGuid());
            RuleManager ruleManager = autoDeploy.getRuleManager();
            ManagedObjectReference[] liveRuleSetList = ruleManager.getLiveRuleSetList();
            RuleSet liveRuleSet = (RuleSet)autoDeploy.getManagedObject(liveRuleSetList[0]);
            result.result = this.checkHostCompliance(spec.host, liveRuleSet);
        }
        catch (Exception ex) {
            result.error = ex;
        }
        return result;
    }

    public ValidationResult validate(CheckMultiHostComplianceSpec spec) {
        Validate.isTrue((spec.isLiveRuleset == (spec.rulesToActivate == null) ? 1 : 0) != 0);
        Validate.notEmpty((Object[])spec.hosts, (String)"No hosts in compliance spce!");
        ValidationResult result = new ValidationResult();
        AutoDeployService autoDeployService = this._serviceFactory.getService(spec.hosts[0].getServerGuid());
        RuleManager rm = autoDeployService.getRuleManager();
        try {
            RuleSet ruleSet;
            if (spec.isLiveRuleset) {
                ManagedObjectReference[] liveRuleSetList = rm.getLiveRuleSetList();
                ruleSet = (RuleSet)autoDeployService.getManagedObject(liveRuleSetList[0]);
            } else {
                WorkingRuleSet workingRuleSet = this.getWorkingRuleset(spec.hosts[0].getServerGuid());
                RuleSet.RuleSetSpec ruleSetSpec = workingRuleSet.retrieveSpec();
                ruleSetSpec.ruleList = spec.rulesToActivate;
                workingRuleSet.update(ruleSetSpec);
                ruleSet = workingRuleSet;
            }
            ManagedObjectReference task = ruleSet.bulkMappingComplianceCheck(spec.hosts);
            TaskInfo taskInfo = this._taskMonitor.monitorTask(task);
            if (taskInfo.error != null) {
                throw taskInfo.error;
            }
            if (TaskInfo.State.success.equals((Object)taskInfo.state) && taskInfo.result instanceof String) {
                String token = (String)taskInfo.result;
                result.result = this.retrieveHostsComplianceDataByToken(ruleSet, token);
            }
        }
        catch (Exception e) {
            result.error = e;
        }
        return result;
    }

    private WorkingRuleSet getWorkingRuleset(String serverGuid) {
        AutoDeployService autoDeployService = this._serviceFactory.getService(serverGuid);
        RuleManager ruleManager = autoDeployService.getRuleManager();
        ManagedObjectReference[] ruleSetRefs = ruleManager.retrieveRuleSetList();
        ManagedObjectReference workingSet = ruleSetRefs[0];
        WorkingRuleSet ruleSet = (WorkingRuleSet)autoDeployService.getManagedObject(workingSet);
        return ruleSet;
    }

    private HostComplianceData[] retrieveHostsComplianceDataByToken(RuleSet ruleSet, String token) {
        RuleSet.BulkCheckResult[] results = ruleSet.getComplianceCheckResult(token);
        HostComplianceData[] hostsData = new HostComplianceHelper(this._hostOpsProvider, this._queryExecutor).retrieveHostItemsData(results);
        return hostsData;
    }

    private HostComplianceData checkHostCompliance(ManagedObjectReference host, RuleSet ruleSet) {
        RuleSet.CheckResult[] checkResults = ruleSet.mappingComplianceCheck(host);
        HostComplianceData hostData = new HostComplianceHelper(this._hostOpsProvider, this._queryExecutor).retrieveHostItemsData(host, checkResults);
        return hostData;
    }

    public OperationResult add(CreateRuleSpec spec) {
        OperationResult opResult = new OperationResult();
        try {
            AutoDeployService autoDeployService = this._serviceFactory.getService(spec.vcServerGuid);
            RuleManager ruleManager = autoDeployService.getRuleManager();
            if (spec.imageProfile != null) {
                String imageProfileName = (String)this._queryExecutor.getProperty((Object)spec.imageProfile, "name");
                Preconditions.checkNotNull((Object)imageProfileName, (Object)"Image profile name cannot be retrieved.");
                ManagedObjectReference taskRef = ruleManager.createRuleWithTransform(new Rule.RuleMetadata(spec.name), new Rule.RuleSpec(spec.patternList, spec.itemList), new String[]{imageProfileName}, spec.skipImageProfileSignatureCheck);
                TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
                if (taskInfo.error != null) {
                    opResult.error = taskInfo.error;
                }
                opResult.result = ruleManager.findRule(taskInfo.result.toString());
            } else {
                opResult.result = ruleManager.createRule(new Rule.RuleMetadata(spec.name), new Rule.RuleSpec(spec.patternList, spec.itemList));
            }
        }
        catch (Exception ex) {
            opResult.error = ex;
        }
        return opResult;
    }

    public OperationResult remove(ManagedObjectReference ruleRef, DeleteRuleSpec spec) {
        Preconditions.checkNotNull((Object)ruleRef, (Object)"Null rule ref");
        Preconditions.checkNotNull((Object)ruleRef.getServerGuid(), (Object)"Null rule ref server guid");
        OperationResult opResult = new OperationResult();
        opResult.entity = ruleRef;
        try {
            AutoDeployService autoDeployService = this._serviceFactory.getService(ruleRef.getServerGuid());
            Rule rule = (Rule)autoDeployService.getManagedObject(ruleRef);
            rule.destroy();
        }
        catch (Exception ex) {
            opResult.error = ex;
        }
        return opResult;
    }

    public ValidationResult validate(ValidateRuleContentsSpec spec) {
        Preconditions.checkNotNull((Object)spec.vcServerGuid, (Object)"server guid");
        ValidationResult result = new ValidationResult();
        AutoDeployService autoDeploy = this._serviceFactory.getService(spec.vcServerGuid);
        RuleManager rm = autoDeploy.getRuleManager();
        result.result = false;
        try {
            rm.validateRule(new Rule.RuleSpec(spec.patternList, spec.itemList));
            result.result = true;
        }
        catch (InvalidRuleSpecFault e) {
            result.error = e;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference rule, EditRuleContentsSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = rule;
        try {
            Preconditions.checkArgument((!ArrayUtil.isNullOrEmpty((Object[])spec.itemList) || spec.imageProfile != null ? 1 : 0) != 0, (Object)"A rule must contain at least one of the following: image profile, host profile, location.");
            AutoDeployService autoDeploy = this._serviceFactory.getService(rule.getServerGuid());
            Rule r = (Rule)autoDeploy.getManagedObject(rule);
            String ruleName = r.getMetadata().getName();
            if (!spec.name.equalsIgnoreCase(ruleName)) {
                r.updateMetadata(new Rule.RuleMetadata(spec.name));
            }
            if (spec.imageProfile != null) {
                String imageProfileName = (String)this._queryExecutor.getProperty((Object)spec.imageProfile, "name");
                Preconditions.checkNotNull((Object)imageProfileName, (Object)"Image profile name cannot be retrieved.");
                ManagedObjectReference taskRef = r.updateSpecWithTransform(new Rule.RuleSpec(spec.patternList, spec.itemList), new String[]{imageProfileName}, Boolean.valueOf(true), spec.skipImageProfileSignatureCheck);
                TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
                if (taskInfo.error != null) {
                    result.error = taskInfo.error;
                }
                result.result = taskInfo.result;
            } else {
                r.updateSpec(new Rule.RuleSpec(spec.patternList, spec.itemList), Boolean.valueOf(true));
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"Passed an invalid rule spec: ", (Throwable)e);
            MethodFault newException = new MethodFault();
            newException.setFaultCause(e);
            newException.setMessage(e.getLocalizedMessage());
            result.error = newException;
        }
        return result;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] hosts, RemediateHostSpec spec) {
        HashMap<ManagedObjectReference, OperationResult> result = new HashMap<ManagedObjectReference, OperationResult>();
        for (ManagedObjectReference host : hosts) {
            OperationResult opResult = new OperationResult();
            opResult.entity = host;
            result.put(host, opResult);
        }
        RuleSet liveRuleSet = this.getLiveRuleSet(hosts[0].getServerGuid());
        ArrayList<RuleSet.BulkCheckResult> hostsCheckResults = new ArrayList<RuleSet.BulkCheckResult>();
        for (int i = 0; i < hosts.length; ++i) {
            RuleSet.CheckResult[] mappingViolations = null;
            try {
                mappingViolations = liveRuleSet.mappingComplianceCheck(hosts[i]);
            }
            catch (Exception e) {
                _logger.error((Object)e);
                ((OperationResult)result.get((Object)hosts[i])).error = e;
            }
            if (mappingViolations == null || mappingViolations.length <= 0) continue;
            hostsCheckResults.add(new RuleSet.BulkCheckResult(mappingViolations, hosts[i]));
        }
        ManagedObjectReference masterTask = null;
        if (hostsCheckResults.size() > 0) {
            try {
                masterTask = liveRuleSet.bulkRemediateMapping(hostsCheckResults.toArray(new RuleSet.BulkCheckResult[hostsCheckResults.size()]));
                TaskInfo taskInfo = this._taskMonitor.monitorTask(masterTask);
                if (taskInfo.error != null) {
                    throw taskInfo.error;
                }
            }
            catch (Exception e) {
                _logger.error((Object)e);
                for (RuleSet.BulkCheckResult bulkResult : hostsCheckResults) {
                    ((OperationResult)result.get((Object)bulkResult.host)).error = e;
                }
            }
        }
        OperationResult[] opResults = result.values().toArray(new OperationResult[result.size()]);
        return opResults;
    }

    private RuleSet getLiveRuleSet(String serverGuid) {
        AutoDeployService autoDeploy = this._serviceFactory.getService(serverGuid);
        RuleManager ruleManager = autoDeploy.getRuleManager();
        ManagedObjectReference[] liveRuleSetList = ruleManager.getLiveRuleSetList();
        RuleSet liveRuleSet = (RuleSet)autoDeploy.getManagedObject(liveRuleSetList[0]);
        return liveRuleSet;
    }
}

