/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.vmomi.core.exception.VmodlAlreadyLoadedException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmodlContextLoader {
    private static final Log _logger = LogFactory.getLog(VmodlContextLoader.class);
    private final String[] _vmodlPackageRoots;
    private final ClassLoader _bundleClassLoader;

    public VmodlContextLoader(String[] vmodlPackageRoots, Class bundleClass) {
        Preconditions.checkNotNull((Object)vmodlPackageRoots);
        Preconditions.checkArgument((vmodlPackageRoots.length > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bundleClass);
        this._vmodlPackageRoots = vmodlPackageRoots;
        this._bundleClassLoader = bundleClass.getClassLoader();
    }

    public void loadVmodlContext() {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._bundleClassLoader);
            VmodlContext.initContext((String[])this._vmodlPackageRoots);
        }
        catch (VmodlAlreadyLoadedException vmodlAlreadyLoadedException) {
        }
        catch (Exception ex) {
            _logger.error((Object)String.format("Error when loading vmodl types in root packages: \"%s\".", this._vmodlPackageRoots), (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }
}

