/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.autodeploy.util.AutoDeployUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoDeployWaiterService {
    private static final Log _logger = LogFactory.getLog(AutoDeployWaiterService.class);
    private String _rootUri;
    private final VcService _vcService;
    private HostnameVerifier _hostnameVerifier;
    private TrustManager[] _trustAllCerts;
    private static final int BUFFER_SIZE = 512;

    public AutoDeployWaiterService(URI waiterServiceUri, VcService vcService) {
        this._vcService = vcService;
        this._rootUri = waiterServiceUri.toString();
        if (!this._rootUri.endsWith("/")) {
            this._rootUri = this._rootUri + "/";
        }
    }

    private TrustManager[] getTrustAllCerts() {
        if (this._trustAllCerts == null) {
            this._trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
        }
        return this._trustAllCerts;
    }

    private HostnameVerifier getHostnameVerifier() {
        if (this._hostnameVerifier == null) {
            this._hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
        }
        return this._hostnameVerifier;
    }

    public String getResourceBaseUrl(String plugin, String resourceName) {
        try {
            URL url = new URL(this.getResourceMetaUrl(plugin, resourceName) + "/base-url");
            return this.getContentAsString(url);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void uploadResource(String plugin, String resourceName, byte[] content) throws Exception {
        String sessionKey = this._vcService.getConnectionInfo().getUserSession().key;
        URL url = new URL(this.getResourceMetaUrl(plugin, resourceName) + String.format("/content?session=%s&vimSessionKey=%s", sessionKey, sessionKey));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.handleHttpsConnection(connection);
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            int size;
            for (int offset = 0; offset < content.length; offset += size) {
                size = Math.min(512, content.length - offset);
                outputStream.write(content, offset, size);
            }
            outputStream.flush();
        }
        if (connection.getResponseCode() != 200) {
            InputStream errorStream = connection.getErrorStream();
            var8_8 = null;
            try {
                try {
                    if (errorStream != null) {
                        String errorMsg = this.readStreamContent(errorStream);
                        _logger.error((Object)String.format("Failed to upload resource. Status code %d. %s", connection.getResponseCode(), errorMsg));
                        throw new Exception(errorMsg);
                    }
                    _logger.error((Object)String.format("Failed to upload resource. Status code %d.", connection.getResponseCode()));
                    throw new Exception(AutoDeployUtil.getLocalizedString("scriptBundle.upload.uploadFail", new String[0]));
                }
                catch (Throwable throwable) {
                    var8_8 = throwable;
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (errorStream != null) {
                    if (var8_8 != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable throwable2) {
                            var8_8.addSuppressed(throwable2);
                        }
                    } else {
                        errorStream.close();
                    }
                }
                throw throwable;
            }
        }
    }

    private String getResourceMetaUrl(String plugin, String resourceName) {
        return this._rootUri + String.format("cache/default-vc/%s/%s", plugin, this.base64UrlEncode(resourceName));
    }

    private String getContentAsString(URL url) throws Exception {
        URLConnection connection = url.openConnection();
        if (connection != null) {
            this.handleHttpsConnection(connection);
            connection.setUseCaches(false);
            try (InputStream inputStream = connection.getInputStream();){
                String string = this.readStreamContent(inputStream);
                return string;
            }
        }
        return null;
    }

    private String readStreamContent(InputStream inputStream) throws IOException {
        int readCount;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer response = new StringBuffer();
        char[] buffer = new char[512];
        while ((readCount = reader.read(buffer)) > 0) {
            response.append(buffer, 0, readCount);
        }
        return response.toString();
    }

    private void handleHttpsConnection(URLConnection connection) throws Exception {
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setHostnameVerifier(this.getHostnameVerifier());
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, this.getTrustAllCerts(), new SecureRandom());
            httpsConnection.setSSLSocketFactory(sslContext.getSocketFactory());
        }
    }

    private String base64UrlEncode(String s) {
        String result = Base64.encodeBase64String((byte[])s.getBytes(StandardCharsets.UTF_8));
        return result.replace('+', '-').replace('/', '_');
    }
}

