/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.migration.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.RuntimeInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.vm.migration.MigrationReasonCode;
import com.vmware.vsphere.client.vm.migration.MigrationType;
import com.vmware.vsphere.client.vm.migration.VmMigrationOptions;
import com.vmware.vsphere.client.vm.migration.impl.VmMigrationOptionsBuilder;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class VmMigrationOptionsRetriever {
    private static final String PROPERTY_VM_RUNTIME = "runtime";
    private static final String PROPERTY_VM_FT_ROLE = "ftRole";
    private static final String PROPERTY_VM_FT_TYPE = "config.flags.faultToleranceType";
    private static final String PROPERTY_HOST_IN_MM = "runtime.inMaintenanceMode";
    private static final String[] PRIVILEGES_RESOURCE_HOTMIGRATE = new String[]{"Resource.HotMigrate"};
    private static final String[] PRIVILEGES_RESOURCE_COLDMIGRATE = new String[]{"Resource.ColdMigrate"};
    private static final Log _logger = LogFactory.getLog(VmMigrationOptionsRetriever.class);
    private final QueryExecutor _queryExecutor;
    private final ManagedObjectReference[] _vms;
    private PropertyTable _propertyTable;

    public VmMigrationOptionsRetriever(QueryExecutor queryExecutor, ManagedObjectReference[] vms) {
        this._queryExecutor = queryExecutor;
        this._vms = vms;
    }

    public VmMigrationOptions[] getVmMigrationOptions() throws Exception {
        this.retrieveProperties();
        VmMigrationOptions[] allVmMigrationOptions = new VmMigrationOptions[this._vms.length];
        for (int i = 0; i < this._vms.length; ++i) {
            ManagedObjectReference vm = this._vms[i];
            VmMigrationOptionsBuilder optionsBuilder = new VmMigrationOptionsBuilder(vm);
            this.applyPowerStateConstraints(vm, optionsBuilder);
            this.applyFtConstraints(vm, optionsBuilder);
            this.applyPrivilegeConstraints(vm, optionsBuilder);
            allVmMigrationOptions[i] = optionsBuilder.build();
        }
        return allVmMigrationOptions;
    }

    private void retrieveProperties() throws Exception {
        PropertyValue[] vmProps;
        this._propertyTable = new PropertyTable();
        for (PropertyValue p : vmProps = this._queryExecutor.getProperties((Object[])this._vms, new String[]{PROPERTY_VM_RUNTIME, PROPERTY_VM_FT_ROLE, PROPERTY_VM_FT_TYPE, "grantedPrivileges"})) {
            assert (p.resourceObject instanceof ManagedObjectReference);
            this._propertyTable.put((ManagedObjectReference)p.resourceObject, p.propertyName, p.value);
        }
        HashSet<ManagedObjectReference> hostSet = new HashSet<ManagedObjectReference>();
        for (ManagedObjectReference vm : this._vms) {
            RuntimeInfo vmRuntimeInfo = (RuntimeInfo)this._propertyTable.get(vm, PROPERTY_VM_RUNTIME);
            if (vmRuntimeInfo.powerState == VirtualMachine.PowerState.poweredOn) continue;
            hostSet.add(vmRuntimeInfo.host);
        }
        if (!hostSet.isEmpty()) {
            PropertyValue[] hostProps;
            Object[] hostsForNonPoweredOnVms = hostSet.toArray(new ManagedObjectReference[hostSet.size()]);
            for (PropertyValue p : hostProps = this._queryExecutor.getProperty(hostsForNonPoweredOnVms, PROPERTY_HOST_IN_MM)) {
                assert (p.resourceObject instanceof ManagedObjectReference);
                this._propertyTable.put((ManagedObjectReference)p.resourceObject, p.propertyName, p.value);
            }
        }
    }

    private void applyPowerStateConstraints(ManagedObjectReference vm, VmMigrationOptionsBuilder optionsBuilder) {
        Boolean vmHostInMaintenanceMode;
        RuntimeInfo vmRuntimeInfo = (RuntimeInfo)this._propertyTable.get(vm, PROPERTY_VM_RUNTIME);
        if (vmRuntimeInfo.powerState != VirtualMachine.PowerState.poweredOn && (vmHostInMaintenanceMode = (Boolean)this._propertyTable.get(vmRuntimeInfo.host, PROPERTY_HOST_IN_MM)) != null && vmHostInMaintenanceMode.booleanValue()) {
            optionsBuilder.disableOption(MigrationType.datastore, MigrationReasonCode.hostInMaintenance);
            optionsBuilder.disableOption(MigrationType.hostAndDatastore, MigrationReasonCode.hostInMaintenance);
        }
    }

    private void applyPrivilegeConstraints(ManagedObjectReference vm, VmMigrationOptionsBuilder optionsBuilder) {
        String[] grantedPrivileges;
        RuntimeInfo runtimeInfo = (RuntimeInfo)this._propertyTable.get(vm, PROPERTY_VM_RUNTIME);
        String[] requiredPrivileges = runtimeInfo.powerState == VirtualMachine.PowerState.poweredOn ? PRIVILEGES_RESOURCE_HOTMIGRATE : PRIVILEGES_RESOURCE_COLDMIGRATE;
        boolean hasResourceMigratePrivilege = AuthorizationUtil.isPrivilegeGranted((String[])requiredPrivileges, (String[])(grantedPrivileges = (String[])this._propertyTable.get(vm, "grantedPrivileges")));
        if (!hasResourceMigratePrivilege) {
            optionsBuilder.disableOption(MigrationType.host, MigrationReasonCode.noPrivilege);
            optionsBuilder.disableOption(MigrationType.datastore, MigrationReasonCode.noPrivilege);
            optionsBuilder.disableOption(MigrationType.hostAndDatastore, MigrationReasonCode.noPrivilege);
        }
    }

    private void applyFtConstraints(ManagedObjectReference vm, VmMigrationOptionsBuilder optionsBuilder) {
        RuntimeInfo runtimeInfo = (RuntimeInfo)this._propertyTable.get(vm, PROPERTY_VM_RUNTIME);
        if (runtimeInfo.faultToleranceState == VirtualMachine.FaultToleranceState.notConfigured) {
            return;
        }
        String ftTypeValue = (String)this._propertyTable.get(vm, PROPERTY_VM_FT_TYPE);
        if (VmMigrationOptionsRetriever.isCptFt(ftTypeValue)) {
            optionsBuilder.disableOption(MigrationType.datastore, MigrationReasonCode.smpFt);
            optionsBuilder.disableOption(MigrationType.hostAndDatastore, MigrationReasonCode.smpFt);
            return;
        }
        Integer ftRoleBoxed = (Integer)this._propertyTable.get(vm, PROPERTY_VM_FT_ROLE);
        if (ftRoleBoxed == null) {
            _logger.error((Object)("VM " + vm + " is marked as RR-FT, but has no ftRole"));
            return;
        }
        int ftRole = ftRoleBoxed;
        boolean isSecondaryVM = Util.isSecondaryVm(ftRole);
        if (isSecondaryVM) {
            optionsBuilder.disableOption(MigrationType.datastore, MigrationReasonCode.ftSecondary);
            optionsBuilder.disableOption(MigrationType.hostAndDatastore, MigrationReasonCode.ftSecondary);
            return;
        }
        boolean isPrimaryVMPoweredOnAndFTNotDisabled = Util.isPrimaryVmPoweredOnAndFTNotDisabled(runtimeInfo, ftRole);
        if (isPrimaryVMPoweredOnAndFTNotDisabled) {
            optionsBuilder.disableOption(MigrationType.datastore, MigrationReasonCode.ftPrimaryNotInCorrectState);
            optionsBuilder.disableOption(MigrationType.hostAndDatastore, MigrationReasonCode.ftPrimaryNotInCorrectState);
        }
    }

    private static final boolean isCptFt(String ftTypeValue) {
        if (ftTypeValue == null) {
            _logger.warn((Object)"Null VM fault tolerance type provided!");
            return false;
        }
        VirtualMachine.FaultToleranceType ftType = VirtualMachine.FaultToleranceType.valueOf((String)ftTypeValue);
        return VirtualMachine.FaultToleranceType.checkpointing.equals((Object)ftType);
    }

    private static final class PropertyTable {
        private final Object SENTINEL = new Object();
        private final Table<ManagedObjectReference, String, Object> _properties = HashBasedTable.create();

        private PropertyTable() {
        }

        <C> C get(ManagedObjectReference owner, String propertyName) {
            Object result = this._properties.get((Object)owner, (Object)propertyName);
            return (C)(result != this.SENTINEL ? result : null);
        }

        void put(ManagedObjectReference owner, String propertyName, Object value) {
            Object valueToPut = value != null ? value : this.SENTINEL;
            this._properties.put((Object)owner, (Object)propertyName, valueToPut);
        }
    }
}

