/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.issue.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;
import com.vmware.vsphere.client.vm.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="Issue,VmNetworkIssue")
public class VmNetworkIssueAdapter
extends IssueAdapterBase {
    private static final String VM_NETWORK_ISSUE_TYPE = "VmNetworkIssue";
    private static final String VM_NAME_PROPERTY = "name";
    private static final String VIRTUAL_DEVICE_PROPERTY = "config.hardware.device";
    private static final Log _logger = LogFactory.getLog(VmNetworkIssueAdapter.class);
    private DataService _dataService;

    public VmNetworkIssueAdapter(DataService dataService) {
        super(VM_NETWORK_ISSUE_TYPE);
        this._dataService = dataService;
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        Object entity = this.extractEntityFromQuerySpec(querySpec);
        if (!(entity instanceof ManagedObjectReference) || !ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)entity), (String)VirtualMachine.class.getSimpleName())) {
            return new IssueAdapterBase.IssueData[0];
        }
        String vmName = null;
        int nicCount = 0;
        try {
            PropertyValue[] propertyValues;
            for (PropertyValue propertyValue : propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object)entity, (String[])new String[]{VM_NAME_PROPERTY, VIRTUAL_DEVICE_PROPERTY})) {
                VirtualDevice[] devices;
                if (VM_NAME_PROPERTY.equals(propertyValue.propertyName)) {
                    vmName = (String)propertyValue.value;
                    continue;
                }
                if (!VIRTUAL_DEVICE_PROPERTY.equals(propertyValue.propertyName) || (devices = (VirtualDevice[])propertyValue.value) == null) continue;
                for (VirtualDevice device : devices) {
                    if (!(device instanceof VirtualEthernetCard)) continue;
                    ++nicCount;
                }
            }
            if (vmName == null) {
                _logger.warn((Object)String.format("Cound not retrieve VM name for %s", entity.toString()));
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error retrieving virtual devices for %s", entity.toString()), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (nicCount > 0) {
            return new IssueAdapterBase.IssueData[0];
        }
        IssueInfo issueInfo = new IssueInfo();
        issueInfo.description = Util.getLocalizedString("issue.noNetwork");
        issueInfo.typeDisplayName = Util.getLocalizedString("issue.vmNetwork.displayName");
        issueInfo.entity = entity;
        issueInfo.entityName = vmName;
        issueInfo.status = IssueStatus.WARNING;
        IssueAdapterBase.IssueData issueData = new IssueAdapterBase.IssueData();
        ManagedObjectReference vm = (ManagedObjectReference)entity;
        issueData.key = vm.getValue();
        issueData.issueInfo = issueInfo;
        return new IssueAdapterBase.IssueData[]{issueData};
    }
}

