/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vapi.tasks;

import com.vmware.vapi.bindings.client.AsyncCallbackFuture;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.util.vapi.VapiUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.util.concurrent.ExecutionException;

public class VapiAsyncCallback<T>
extends AsyncCallbackFuture<T> {
    protected String _activationId;
    protected String _serverGuid;
    protected VapiTaskMonitor _taskMonitor;

    public VapiAsyncCallback() {
        this.init(null, null);
    }

    public VapiAsyncCallback(VapiTaskMonitor taskMonitor) {
        this.init(taskMonitor, null);
    }

    public VapiAsyncCallback(String activationId, VapiTaskMonitor taskMonitor) {
        this._activationId = activationId == null ? VapiUtil.newClientToken() : activationId;
        this._taskMonitor = taskMonitor;
        this._serverGuid = null;
    }

    public VapiAsyncCallback(VapiTaskMonitor taskMonitor, String serverGuid) {
        this.init(taskMonitor, serverGuid);
    }

    private void init(VapiTaskMonitor taskMonitor, String serverGuid) {
        this._activationId = VapiUtil.newClientToken();
        this._taskMonitor = taskMonitor;
        this._serverGuid = serverGuid;
    }

    public String getActivationId() {
        return this._activationId;
    }

    public InvocationConfig getInvocationConfig() {
        return VapiUtil.newInvocationConfig(this.getActivationId());
    }

    public ManagedObjectReference waitForActivationTask() throws InterruptedException, ExecutionException {
        if (this._taskMonitor == null) {
            return null;
        }
        return this._taskMonitor.waitForActivationTask(this._activationId, this._serverGuid, this);
    }
}

