/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.ovf;

import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vapi.std.errors.Error;
import com.vmware.vcenter.ovf.OvfError;
import com.vmware.vcenter.ovf.OvfMessage;
import com.vmware.vcenter.ovf.ParseIssue;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.util.ServerModulesCommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class OvfErrorFormatter {
    private static final String CONJOINER = "\n";

    public String format(List<OvfError> errors) {
        String result = "";
        if (ArrayUtil.isNullOrEmpty(errors)) {
            return result;
        }
        ArrayList<String> messages = new ArrayList<String>();
        for (OvfError error : errors) {
            String message = this.formatErrorObject(error);
            if (StringUtil.isNullOrEmpty((String)message)) continue;
            messages.add(message);
        }
        return StringUtils.join((Object[])ArrayUtil.toArray(messages, String.class), (String)CONJOINER);
    }

    protected String formatErrorObject(OvfError error) {
        String result = "";
        OvfMessage.Category category = error.getCategory();
        if (OvfMessage.Category.VALIDATION.equals((Object)category)) {
            result = this.formatParseError(error);
        } else if (OvfMessage.Category.INPUT.equals((Object)category)) {
            result = this.formatInputError(error);
        } else if (OvfMessage.Category.SERVER.equals((Object)category)) {
            result = this.formatServerError(error);
        }
        return result;
    }

    private String formatServerError(OvfError error) {
        List errorStackMessages = new ArrayList();
        Structure errorStructure = error.getError();
        if (errorStructure != null) {
            Error vapiError = (Error)errorStructure._convertTo(Error.class);
            errorStackMessages = vapiError.getMessages();
        }
        LocalizableMessage topMostMessage = !ArrayUtil.isNullOrEmpty(errorStackMessages) ? (LocalizableMessage)errorStackMessages.get(0) : null;
        return this.getLocalizedMessage(topMostMessage);
    }

    private String formatInputError(OvfError error) {
        return this.getLocalizedMessage(error.getMessage());
    }

    private String formatParseError(OvfError error) {
        List issues = error.getIssues();
        String result = "";
        if (!ArrayUtil.isNullOrEmpty((List)issues)) {
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(ServerModulesCommonUtil.text("ovf.parseError.details", new String[0]));
            for (ParseIssue issue : issues) {
                messages.add(ServerModulesCommonUtil.text("ovf.parseIssue.format", this.getLocalizedMessage(issue.getMessage())));
            }
            result = StringUtils.join((Object[])ArrayUtil.toArray(messages, String.class), (String)CONJOINER);
        } else {
            result = ServerModulesCommonUtil.text("ovf.parseError", new String[0]);
        }
        return result;
    }

    private KeyAnyValue[] toKeyAnyValues(List<String> args) {
        if (ArrayUtil.isNullOrEmpty(args)) {
            return new KeyAnyValue[0];
        }
        KeyAnyValueImpl[] keyAnyValues = new KeyAnyValueImpl[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            keyAnyValues[i] = new KeyAnyValueImpl();
            keyAnyValues[i].setKey(String.valueOf(i));
            keyAnyValues[i].setValue((Object)args.get(i));
        }
        return keyAnyValues;
    }

    private String getLocalizedMessage(LocalizableMessage message) {
        if (message == null) {
            return "";
        }
        return LocalizationUtil.getLocalizedMessage((String)message.getId(), (KeyAnyValue[])this.toKeyAnyValues(message.getArgs()));
    }
}

