/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.advancedsettings;

import com.vmware.vim.binding.vim.option.BoolOption;
import com.vmware.vim.binding.vim.option.ChoiceOption;
import com.vmware.vim.binding.vim.option.FloatOption;
import com.vmware.vim.binding.vim.option.IntOption;
import com.vmware.vim.binding.vim.option.LongOption;
import com.vmware.vim.binding.vim.option.OptionDef;
import com.vmware.vim.binding.vim.option.OptionType;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vim.option.StringOption;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.advancedsettings.AdvancedSettingsStaticValueSpaceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class AdvancedSettingsUtil {
    private static final Comparator<OptionValue> OPTION_VALUE_COMPARATOR = new Comparator<OptionValue>(){

        @Override
        public int compare(OptionValue value1, OptionValue value2) {
            return value1.getKey().compareToIgnoreCase(value2.getKey());
        }
    };
    private static final Comparator<OptionDef> OPTION_DEFINITION_COMPARATOR = new Comparator<OptionDef>(){

        @Override
        public int compare(OptionDef def1, OptionDef def2) {
            return def1.getKey().compareToIgnoreCase(def2.getKey());
        }
    };

    public static void sortOptionValues(OptionValue[] values) {
        Arrays.sort(values, OPTION_VALUE_COMPARATOR);
    }

    public static void sortOptionDefs(OptionDef[] definitions) {
        Arrays.sort(definitions, OPTION_DEFINITION_COMPARATOR);
    }

    public static OptionValue[] convertOptionMapToOptionValues(Map<String, Object> optionMap) {
        ArrayList<OptionValue> result = new ArrayList<OptionValue>();
        for (Map.Entry<String, Object> rawOptionValue : optionMap.entrySet()) {
            result.add(new OptionValue(rawOptionValue.getKey(), rawOptionValue.getValue()));
        }
        return result.toArray(new OptionValue[0]);
    }

    public static OptionValue[] transformAdvancedSettingsValueTypes(OptionValue[] values, OptionDef[] definitions) {
        HashMap<String, OptionDef> definitionsMap = new HashMap<String, OptionDef>();
        for (OptionDef optionDef : definitions) {
            definitionsMap.put(optionDef.key, optionDef);
        }
        ArrayList<OptionValue> resultList = new ArrayList<OptionValue>();
        for (OptionValue optionValue : values) {
            OptionDef optionDef = (OptionDef)definitionsMap.get(optionValue.key);
            if (optionDef == null) {
                resultList.add(new OptionValue(optionValue.key, optionValue.value));
                continue;
            }
            Object transformedValue = AdvancedSettingsUtil.transformAdvancedSettingValueType(optionValue.value, optionDef);
            resultList.add(new OptionValue(optionValue.key, transformedValue));
        }
        return resultList.toArray(new OptionValue[0]);
    }

    public static String getMetadataTypeByOptionType(OptionType optionType) {
        String propType = null;
        if (optionType instanceof IntOption) {
            propType = "int";
        } else if (optionType instanceof LongOption) {
            propType = "long";
        } else if (optionType instanceof StringOption) {
            propType = "string";
        } else if (optionType instanceof BoolOption) {
            propType = "boolean";
        } else if (optionType instanceof FloatOption) {
            propType = "float";
        } else if (optionType instanceof ChoiceOption) {
            propType = "string";
        }
        return propType;
    }

    public static OptionDef createDefaultOptionDef(String key) {
        StringOption optionType = new StringOption();
        optionType.defaultValue = "";
        optionType.validCharacters = "";
        optionType.valueIsReadonly = false;
        OptionDef optionDef = new OptionDef();
        optionDef.key = key;
        optionDef.label = "";
        optionDef.summary = "";
        optionDef.optionType = optionType;
        return optionDef;
    }

    public static OptionValue findOptionValue(OptionValue[] optionValues, String key) {
        if (key == null) {
            return null;
        }
        for (OptionValue optionValue : optionValues) {
            if (!key.equals(optionValue.key)) continue;
            return optionValue;
        }
        return null;
    }

    public static OptionDef findOptionDef(OptionDef[] optionDefs, String key) throws Exception {
        if (key == null) {
            return null;
        }
        for (OptionDef optionDef : optionDefs) {
            if (!key.equals(optionDef.key)) continue;
            return optionDef;
        }
        return null;
    }

    public static NameValuePair[] createNameValuePairsFromOptionValues(OptionValue[] optionValues) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        for (OptionValue optionValue : optionValues) {
            result.add(new NameValuePair(optionValue.key, optionValue.value));
        }
        return result.toArray(new NameValuePair[0]);
    }

    public static PropertyNodeDescriptor[] createMetadataFromOptionDefs(OptionDef[] optionDefs, boolean editable, boolean useKeyAsTitle) {
        ArrayList<PropertyNodeDescriptor> result = new ArrayList<PropertyNodeDescriptor>();
        for (OptionDef optionDef : optionDefs) {
            result.add(new PropertyNodeDescriptor(AdvancedSettingsUtil.createMetadataFromOptionDef(optionDef, editable, useKeyAsTitle)));
        }
        return result.toArray(new PropertyNodeDescriptor[0]);
    }

    public static PropertyDescriptor createMetadataFromOptionDef(OptionDef optionDef, boolean editable, boolean useKeyAsTitle) {
        String title;
        boolean isImmutable;
        boolean bl = isImmutable = !editable || optionDef.optionType.valueIsReadonly != false;
        if (optionDef.getOptionType() instanceof BoolOption) {
            BoolOption boolOptionType = (BoolOption)optionDef.getOptionType();
            isImmutable = isImmutable || !boolOptionType.isSupported();
        }
        boolean isOptional = false;
        if (optionDef.getOptionType() instanceof StringOption) {
            isOptional = true;
        }
        if (optionDef.getOptionType() instanceof ChoiceOption) {
            isOptional = true;
        }
        if ((title = optionDef.label) == null || title.equals("") || useKeyAsTitle) {
            title = optionDef.key;
        }
        PropertyDescriptor propDesc = new PropertyDescriptor();
        propDesc.immutable = isImmutable;
        propDesc.name = optionDef.key;
        propDesc.title = title;
        propDesc.description = AdvancedSettingsUtil.getAdvancedSettingLocalizedSummary(optionDef);
        propDesc.valueTypeName = AdvancedSettingsUtil.getMetadataTypeByOptionType(optionDef.optionType);
        propDesc.staticValueSpace = AdvancedSettingsStaticValueSpaceUtil.createFromOptionDef(optionDef);
        propDesc.isOptional = isOptional;
        return propDesc;
    }

    private static Object transformAdvancedSettingValueType(Object value, OptionDef definition) {
        if (!(value instanceof Number) || definition == null) {
            return value;
        }
        if (definition.optionType instanceof IntOption) {
            return new Integer(((Number)value).intValue());
        }
        if (definition.optionType instanceof LongOption) {
            return new Long(((Number)value).longValue());
        }
        if (definition.optionType instanceof FloatOption) {
            return new Float(((Number)value).floatValue());
        }
        return value;
    }

    private static String getAdvancedSettingLocalizedSummary(OptionDef optionDef) {
        String localizedMessageKey = "EsxHostAdvSettings." + optionDef.key + ".summary";
        String localizedValue = LocalizationUtil.getLocalizedMessage((String)localizedMessageKey);
        if (localizedValue.equals(localizedMessageKey)) {
            return optionDef.summary;
        }
        return localizedValue;
    }
}

