/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.server;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.agent.server.AgentConnectionListener;
import org.hyperic.hq.agent.server.AgentServerConnection;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.bizapp.agent.TokenData;
import org.hyperic.hq.bizapp.agent.TokenManager;
import org.hyperic.hq.bizapp.agent.TokenNotFoundException;
import org.hyperic.hq.bizapp.agent.server.SSLServerConnection;
import org.hyperic.util.security.DefaultSSLProviderImpl;
import org.hyperic.util.security.KeystoreConfig;

class SSLConnectionListener
extends AgentConnectionListener {
    private static final String PROP_READ_TIMEOUT = "agent.readTimeOut";
    private static int READ_TIMEOUT = 120000;
    private SSLServerSocket listenSock = null;
    private final Log log = LogFactory.getLog(SSLConnectionListener.class);
    private final TokenManager tokenManager;

    public SSLConnectionListener(AgentConfig cfg, TokenManager tokenManager) {
        super(cfg);
        this.tokenManager = tokenManager;
    }

    private SSLServerConnection handleNewConn(SSLSocket sock) throws AgentConnectionException, SocketTimeoutException {
        TokenData token;
        String authToken;
        InetAddress remoteAddr = sock.getInetAddress();
        this.log.debug((Object)("Handling SSL connection from " + remoteAddr));
        SSLServerConnection res = new SSLServerConnection(sock);
        try {
            DataInputStream dIs = new DataInputStream(sock.getInputStream());
            this.log.debug((Object)"Starting to read authToken for SSL connection");
            authToken = dIs.readUTF();
            this.log.debug((Object)"Finished reading authToken for SSL connection");
        }
        catch (SocketTimeoutException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new AgentConnectionException("There was an error negotiating the auth: " + exc.getMessage(), (Exception)exc);
        }
        boolean doSave = false;
        try {
            token = this.tokenManager.getToken(authToken);
        }
        catch (TokenNotFoundException exc) {
            this.log.error((Object)("Rejecting client from " + remoteAddr + ": Passed an invalid auth token (" + authToken + ")"), (Throwable)exc);
            List l = this.tokenManager.getTokens();
            for (TokenData data : l) {
                this.log.debug((Object)("Token: " + data.getToken() + ":" + data.getCreateTime() + ":" + (data.isLocked() ? "locked" : "pending")));
            }
            try {
                res.readCommand();
                res.sendErrorResponse("Unauthorized");
            }
            catch (AgentConnectionException iExc) {
                this.log.debug((Object)iExc, (Throwable)iExc);
            }
            catch (EOFException e) {
                this.log.debug((Object)e, (Throwable)e);
            }
            throw new AgentConnectionException("Client from " + remoteAddr + " unauthorized");
        }
        if (!token.isLocked()) {
            try {
                this.log.info((Object)"Locking auth token");
                this.tokenManager.setTokenLocked(token, true);
                doSave = true;
            }
            catch (TokenNotFoundException exc) {
                this.log.error((Object)("Error setting token '" + token + "' to " + "locked state -- it no longer exists"));
            }
        }
        if (doSave) {
            try {
                this.tokenManager.store();
            }
            catch (IOException exc) {
                this.log.error((Object)("Error storing token data: " + exc.getMessage()));
            }
        }
        this.log.debug((Object)"Done connecting SSL");
        return res;
    }

    public AgentServerConnection getNewConnection() throws AgentConnectionException, InterruptedIOException {
        SSLServerConnection res;
        SSLSocket inConn = null;
        boolean success = false;
        try {
            inConn = (SSLSocket)this.listenSock.accept();
            inConn.setSoTimeout(READ_TIMEOUT);
        }
        catch (InterruptedIOException exc) {
            this.close(inConn);
            throw exc;
        }
        catch (IOException exc) {
            this.close(inConn);
            throw new AgentConnectionException(exc.getMessage(), (Exception)exc);
        }
        try {
            res = this.handleNewConn(inConn);
            success = true;
        }
        catch (SocketTimeoutException e) {
            InterruptedIOException toThrow = new InterruptedIOException();
            toThrow.initCause(e);
            this.log.warn((Object)("socket timed out while handling a command from the server: " + e));
            this.log.debug((Object)e, (Throwable)e);
            throw toThrow;
        }
        finally {
            if (!success) {
                this.close(inConn);
            }
        }
        return res;
    }

    private void close(SSLSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException exc) {
                this.log.debug((Object)exc, (Throwable)exc);
            }
        }
    }

    public void setup() throws AgentStartException {
        InetAddress addr;
        AgentConfig cfg = this.getConfig();
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig(this.getConfig());
        DefaultSSLProviderImpl provider = new DefaultSSLProviderImpl((KeystoreConfig)keystoreConfig, keystoreConfig.isAcceptUnverifiedCert());
        SSLContext context = provider.getSSLContext();
        SSLServerSocketFactory sFactory = context.getServerSocketFactory();
        try {
            addr = cfg.getListenIpAsAddr();
        }
        catch (UnknownHostException exc) {
            throw new AgentStartException("Failed to setup listen socket: unknown host", (Exception)exc);
        }
        int port = cfg.getListenPort();
        while (true) {
            try {
                this.listenSock = (SSLServerSocket)sFactory.createServerSocket(port, 50, addr);
                this.listenSock.setEnabledCipherSuites(this.getSupportedAndEnabledCiphers(cfg.getEnabledCipherList(), sFactory));
            }
            catch (IOException exc) {
                if (this.listenSock != null) {
                    try {
                        this.listenSock.close();
                    }
                    catch (IOException e1) {
                        this.log.debug((Object)e1, (Throwable)e1);
                    }
                }
                this.log.warn((Object)("Failed to listen at port " + port + ": " + exc.getMessage() + ".  Will retry until up."));
                this.log.debug((Object)exc, (Throwable)exc);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    this.log.debug((Object)e, (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    private String[] getSupportedAndEnabledCiphers(List<String> enabledCiphers, SSLServerSocketFactory sFactory) {
        HashSet<String> supportedCiphers = new HashSet<String>(Arrays.asList(sFactory.getSupportedCipherSuites()));
        ArrayList<String> unsupportedCiphers = new ArrayList<String>();
        for (String cipher : enabledCiphers) {
            if (supportedCiphers.contains(cipher)) continue;
            unsupportedCiphers.add(cipher);
            this.log.warn((Object)("Cipher " + cipher + " is not supported, removing from list of negotiable ciphers."));
        }
        enabledCiphers.removeAll(unsupportedCiphers);
        return enabledCiphers.toArray(new String[0]);
    }

    public void cleanup() {
        if (this.listenSock != null) {
            this.log.info((Object)("closing listener socket " + this.listenSock.getInetAddress() + ":" + this.listenSock.getLocalPort()));
            try {
                this.listenSock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.listenSock = null;
        }
    }

    static {
        try {
            READ_TIMEOUT = Integer.parseInt(System.getProperty(PROP_READ_TIMEOUT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

