/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.Serializable;
import org.hyperic.util.HostIP;
import org.hyperic.util.config.InvalidOptionValueException;
import org.hyperic.util.config.StringConfigOption;

public class MulticastIpAddressConfigOption
extends StringConfigOption
implements Serializable {
    public MulticastIpAddressConfigOption(String optName, String optDesc, String defValue) {
        super(optName, optDesc, defValue);
    }

    @Override
    public void checkOptionIsValid(String value) throws InvalidOptionValueException {
        String msg = "not a valid multicast IP address (must be in the range 224.x.x.x through 239.x.x.x)";
        if (!HostIP.isValidMulticastIP(value)) {
            throw this.invalidOption("not a valid multicast IP address (must be in the range 224.x.x.x through 239.x.x.x)");
        }
    }
}

