/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory.scanimpl;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.hq.autoinventory.scanimpl.ScanMethodBase;
import org.hyperic.hq.product.FileServerDetector;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.BooleanConfigOption;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.DirArrayConfigOption;
import org.hyperic.util.config.EnumerationConfigOption;
import org.hyperic.util.config.IntegerConfigOption;
import org.hyperic.util.file.match.MatchResults;
import org.hyperic.util.file.match.MatchSelector;
import org.hyperic.util.file.match.Matcher;
import org.hyperic.util.file.match.MatcherConfig;
import org.hyperic.util.file.match.MatcherInterruptCallback;
import org.hyperic.util.file.match.MatcherInterruptedException;
import org.hyperic.util.file.match.MatcherProgressCallback;

public class FileScan
extends ScanMethodBase
implements MatcherInterruptCallback,
MatcherProgressCallback {
    private List _scanDirs;
    private List _excludeDirs;
    private String _fsTypes;
    private int _depth;
    private boolean _followSymlinks;
    private boolean _isWindows;
    private Log _log = LogFactory.getLog((String)FileScan.class.getName());
    private transient long _statusUpdateCounter = 0L;
    public static final String FS_TYPE_ALL = "All disks";
    public static final String FS_TYPE_LOCAL = "Local disks";
    public static final String FS_TYPE_NETWORK = "Network-mounted disks";
    public static final String[] FS_TYPES = new String[]{"All disks", "Local disks", "Network-mounted disks"};
    private static final String[] WIN32_DEFAULT_DIRS = new String[]{"C:\\"};
    private static final String[] WIN32_DEFAULT_EXCLUDE_DIRS = new String[]{"\\WINNT", "\\TEMP", "\\TMP", "\\Documents and Settings", "\\Recycled"};
    private static final String[] UNIX_DEFAULT_DIRS = new String[]{"/usr", "/opt"};
    private static final String[] UNIX_DEFAULT_EXCLUDE_DIRS = new String[]{"/usr/doc", "/usr/dict", "/usr/lib", "/usr/libexec", "/usr/man", "/usr/tmp", "/usr/include", "/usr/share", "/usr/src", "/usr/local/include", "/usr/local/share", "/usr/local/src"};

    public FileScan() {
        this._authorityLevel = 5;
        this._isWindows = PlatformDetector.IS_WIN32;
    }

    public FileScan(boolean isWindows) {
        this._authorityLevel = 5;
        this._isWindows = isWindows;
    }

    @Override
    public String getName() {
        return "FileScan";
    }

    @Override
    public String getDisplayName() {
        return "File Scan";
    }

    @Override
    public String getDescription() {
        return "Scan the filesystem";
    }

    @Override
    protected ConfigOption[] getOptionsArray() {
        ConfigOption[] opts = new ConfigOption[5];
        int i = 0;
        opts[i++] = new DirArrayConfigOption("scanDirs", "Directories to scan (use | as a delimiter)", this.getDefaultScanDirs());
        opts[i++] = new DirArrayConfigOption("excludeDirs", "Directories to exclude from scan (use | as a delimiter)", this.getDefaultExcludeDirs());
        opts[i++] = new EnumerationConfigOption("fsTypes", "Filesystem types to scan", FS_TYPES[0], FS_TYPES);
        opts[i++] = new IntegerConfigOption("depth", "How deep (in directory levels) to scan.  Use -1 to indicate unlimited depth", new Integer(6));
        opts[i++] = new BooleanConfigOption("followSymlinks", "Should symlinks be followed?", false);
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(ConfigResponse platformConfig, ServerDetector[] serverDetectors) throws AutoinventoryException {
        boolean hasFileScan = false;
        for (int i = 0; i < serverDetectors.length; ++i) {
            if (!(serverDetectors[i] instanceof FileServerDetector)) continue;
            hasFileScan = true;
            break;
        }
        if (!hasFileScan) {
            this._log.debug((Object)"Skipping FileScan");
            this._state.setScanStatus(this, "scan completed");
            return;
        }
        try {
            MatchResults matchResults;
            int i;
            this._state.setScanStatus(this, "scan started");
            this._scanDirs = StringUtil.explode((String)this._config.getValue("scanDirs"), (String)"|");
            this._excludeDirs = StringUtil.explode((String)this._config.getValue("excludeDirs"), (String)"|");
            this._fsTypes = this._config.getValue("fsTypes");
            int fsTypeID = this.convertFSType(this._fsTypes);
            this._depth = Integer.parseInt(this._config.getValue("depth"));
            this._followSymlinks = Boolean.valueOf(this._config.getValue("followSymlinks"));
            if (this._scanner.getIsInterrupted()) {
                return;
            }
            Matcher m = new Matcher();
            MatcherConfig mconfig = new MatcherConfig();
            HashMap<ServerDetector, String> pathsToDetectors = new HashMap<ServerDetector, String>();
            for (i = 0; i < this._scanDirs.size(); ++i) {
                mconfig.addSearchDir((String)this._scanDirs.get(i));
            }
            mconfig.setExcludePatterns(this._excludeDirs);
            mconfig.setFSTypes(fsTypeID);
            mconfig.setFollowSymlinks(this._followSymlinks);
            mconfig.setLog(this._log);
            mconfig.setMaxDepth(this._depth);
            mconfig.setMatcherInterruptCB((MatcherInterruptCallback)this);
            mconfig.setMatcherProgressCB((MatcherProgressCallback)this);
            mconfig.setAllowMultipleMatches(true);
            for (i = 0; i < serverDetectors.length; ++i) {
                MatchSelector matchSelector = this.getMatchSelector(serverDetectors[i]);
                mconfig.addMatchSelector(matchSelector);
            }
            try {
                this._statusUpdateCounter = 0L;
                matchResults = m.getMatches(mconfig);
                this._state.addScanExceptions(this, matchResults.getErrorArray());
            }
            catch (SigarException se) {
                throw new AutoinventoryException("Fatal Exception running FileScan: " + (Object)((Object)se), se);
            }
            catch (MatcherInterruptedException mie) {
                this._log.info((Object)"Scan interrupted.");
                this._state.setScanStatus(this, "scan completed");
                return;
            }
            for (ServerDetector serverDetector : matchResults.matches.keySet()) {
                List stMatches = (List)matchResults.matches.get(serverDetector);
                for (i = 0; i < stMatches.size(); ++i) {
                    List detectedServers;
                    String matchPath = (String)stMatches.get(i);
                    ServerDetector prevDetector = (ServerDetector)pathsToDetectors.get(matchPath);
                    if (prevDetector != null) {
                        throw new AutoinventoryException("Multiple servers (" + prevDetector.getServerSignature().getServerTypeName() + " and " + serverDetector.getServerSignature().getServerTypeName() + ") can detect for path: " + matchPath);
                    }
                    PluginLoader.setClassLoader((Object)serverDetector);
                    try {
                        detectedServers = ((FileServerDetector)((Object)serverDetector)).getServerResources(platformConfig, matchPath);
                    }
                    finally {
                        PluginLoader.resetClassLoader((Object)serverDetector);
                    }
                    if (detectedServers == null || detectedServers.size() <= 0) continue;
                    pathsToDetectors.put(serverDetector, matchPath);
                    this._log.info((Object)("DETECTED SERVERS=" + StringUtil.listToString((List)detectedServers)));
                    this._state.addServers(this, detectedServers);
                }
            }
        }
        catch (PluginException e) {
            this._log.error((Object)("PluginException in FileScan: " + (Object)((Object)e)), (Throwable)((Object)e));
        }
        catch (Exception e) {
            this._log.error((Object)("Big-time error in FileScan: " + e), (Throwable)e);
            throw new AutoinventoryException(e);
        }
        finally {
            this._state.setScanStatus(this, "scan completed");
        }
    }

    public boolean getIsInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    private int convertFSType(String aiType) {
        if (aiType.equals(FS_TYPE_ALL)) {
            return 0;
        }
        if (aiType.equals(FS_TYPE_LOCAL)) {
            return 1;
        }
        if (aiType.equals(FS_TYPE_NETWORK)) {
            return 2;
        }
        throw new IllegalArgumentException("Unrecognized filesystem argument: " + aiType);
    }

    private String getDefaultScanDirs() {
        String dirs = "";
        if (this._isWindows) {
            for (int i = 0; i < WIN32_DEFAULT_DIRS.length; ++i) {
                if (dirs.length() > 0) {
                    dirs = dirs + "|";
                }
                dirs = dirs + WIN32_DEFAULT_DIRS[i];
            }
        } else {
            for (int i = 0; i < UNIX_DEFAULT_DIRS.length; ++i) {
                if (dirs.length() > 0) {
                    dirs = dirs + "|";
                }
                dirs = dirs + UNIX_DEFAULT_DIRS[i];
            }
        }
        return dirs;
    }

    private String getDefaultExcludeDirs() {
        String dirs = "";
        if (this._isWindows) {
            for (int i = 0; i < WIN32_DEFAULT_EXCLUDE_DIRS.length; ++i) {
                if (dirs.length() > 0) {
                    dirs = dirs + "|";
                }
                dirs = dirs + WIN32_DEFAULT_EXCLUDE_DIRS[i];
            }
        } else {
            for (int i = 0; i < UNIX_DEFAULT_EXCLUDE_DIRS.length; ++i) {
                if (dirs.length() > 0) {
                    dirs = dirs + "|";
                }
                dirs = dirs + UNIX_DEFAULT_EXCLUDE_DIRS[i];
            }
        }
        return dirs;
    }

    private MatchSelector getMatchSelector(ServerDetector sd) {
        MatchSelector ms = this.getMatchSelector(sd.getServerSignature());
        ms.setKey((Object)sd);
        return ms;
    }

    private MatchSelector getMatchSelector(ServerSignature sig) {
        MatchSelector ms = new MatchSelector((Object)sig);
        ms.addMatchPatterns(sig.getFileMatchPatterns());
        ms.addExcludePatterns(sig.getFileExcludePatterns());
        return ms;
    }

    public void notifyScanDir(File dir) {
        if (this._statusUpdateCounter % 10L == 0L) {
            this._state.setScanStatus(this, "scanning: " + dir.getAbsolutePath());
        }
        ++this._statusUpdateCounter;
    }
}

