/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.snmp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.snmp.MIBLookupException;
import org.hyperic.snmp.SNMPCacheObject;
import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession;
import org.hyperic.util.timer.StopWatch;

class SNMPSessionCache
implements InvocationHandler {
    private SNMPSession session;
    private HashMap columnCache = new HashMap();
    private HashMap bulkCache = new HashMap();
    private HashMap tableCache = new HashMap();
    private static Log log = LogFactory.getLog(SNMPSessionCache.class);
    public static final int EXPIRE_DEFAULT = 30000;
    private int expire;

    SNMPSessionCache(SNMPSession session, int expire) {
        this.session = session;
        this.expire = expire;
    }

    static SNMPSession newInstance(SNMPSession session, int expire) throws SNMPException {
        SNMPSession sessionCache;
        SNMPSessionCache handler = new SNMPSessionCache(session, expire);
        try {
            sessionCache = (SNMPSession)Proxy.newProxyInstance(SNMPSession.class.getClassLoader(), new Class[]{SNMPSession.class}, (InvocationHandler)handler);
        }
        catch (Exception e) {
            throw new SNMPException(e.getMessage());
        }
        return sessionCache;
    }

    private SNMPCacheObject getFromCache(long timeNow, HashMap cache, String name, Object arg) {
        SNMPCacheObject cacheVal = (SNMPCacheObject)cache.get(arg);
        String argDebug = "";
        if (log.isDebugEnabled()) {
            argDebug = " with arg=" + arg;
        }
        if (cacheVal == null) {
            cacheVal = new SNMPCacheObject();
            cacheVal.expire = this.expire;
            cache.put(arg, cacheVal);
        } else if (timeNow - cacheVal.timestamp > (long)cacheVal.expire) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("expiring " + name + " from cache" + argDebug));
            }
            cacheVal.value = null;
        }
        return cacheVal;
    }

    private StringBuffer invokerToString(String name, Object[] args, Object cacheKey) {
        StringBuffer invoker = new StringBuffer(name);
        invoker.append('(');
        if (args.length != 0) {
            String arg = args[0].toString();
            invoker.append(arg);
            for (int i = 1; i < args.length; ++i) {
                invoker.append('.').append(args[i].toString());
            }
            if (cacheKey != null && !arg.toString().equals(cacheKey)) {
                invoker.append('/').append(cacheKey.toString());
            }
            invoker.append(')');
        }
        return invoker;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws SNMPException {
        Object retval;
        SNMPCacheObject cacheVal = null;
        HashMap cache = null;
        Object cacheKey = null;
        String name = method.getName();
        long timeNow = 0L;
        if (name.equals("getBulk")) {
            cache = this.bulkCache;
            cacheKey = args[0];
        } else if (name.equals("getTable")) {
            cache = this.tableCache;
            cacheKey = new Integer(args[0].hashCode() ^ args[1].hashCode());
        } else if (name.equals("getColumn")) {
            cache = this.columnCache;
            cacheKey = args[0];
        }
        if (cache != null) {
            timeNow = System.currentTimeMillis();
            cacheVal = this.getFromCache(timeNow, cache, name, cacheKey);
            if (cacheVal.value != null) {
                return cacheVal.value;
            }
        }
        try {
            retval = method.invoke((Object)this.session, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof MIBLookupException) {
                throw (MIBLookupException)((Object)t);
            }
            String msg = t instanceof SNMPException ? "" : t.getClass().getName() + ": ";
            msg = msg + t.getMessage() + " invoking: " + this.invokerToString(name, args, cacheKey);
            throw new SNMPException(msg, t);
        }
        catch (Exception e) {
            String msg = e.getClass().getName() + ": " + e.getMessage() + " invoking: " + this.invokerToString(name, args, cacheKey);
            throw new SNMPException(msg, e);
        }
        if (cacheVal != null) {
            cacheVal.value = retval;
            cacheVal.timestamp = timeNow;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.invokerToString(name, args, cacheKey) + " took: " + new StopWatch(timeNow)));
            }
        }
        return retval;
    }
}

