/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

public class Win32ControlPlugin
extends ControlPlugin {
    public static final String PROP_SERVICENAME = "service_name";
    protected Log log = LogFactory.getLog((String)this.getClass().getName());
    protected String serviceName = null;
    protected String installPrefix = null;
    protected Service svc;
    private static final String[] actions = new String[]{"start", "stop", "restart"};
    private static final List commands = Arrays.asList(actions);

    @Override
    protected Log getLog() {
        return this.log;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String val) {
        this.serviceName = val;
    }

    protected boolean isServiceRequired() {
        return true;
    }

    public String getInstallPrefix() {
        return this.installPrefix;
    }

    public void setInstallPrefix(String val) {
        this.installPrefix = val;
    }

    @Override
    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        String val = this.getServiceName();
        if (val == null && (val = config.getValue(PROP_SERVICENAME)) != null) {
            this.setServiceName(val);
        }
        if ((val = config.getValue("installpath")) != null) {
            this.setInstallPrefix(val);
        }
        try {
            if (this.getServiceName() == null) {
                throw new Win32Exception("Service name cannot be null");
            }
            this.svc = new Service(this.getServiceName());
        }
        catch (Win32Exception e) {
            String msg = "Could not open Windows Service: " + this.getServiceName();
            if (this.isServiceRequired()) {
                throw new PluginException(msg);
            }
            this.log.debug((Object)msg);
        }
    }

    @Override
    protected boolean isRunning() {
        return this.isRunning(this.svc);
    }

    protected boolean isRunning(Service service) {
        String resp = this.detectState(service);
        return resp.equals("started") || resp.equals("starting") || resp.equals("stopping");
    }

    protected String detectState(Service service) {
        switch (service.getStatus()) {
            case 2: {
                return "starting";
            }
            case 1: {
                return "stopped";
            }
            case 4: {
                return "started";
            }
            case 3: {
                return "stopping";
            }
            case 5: 
            case 6: 
            case 7: {
                return "unknown";
            }
        }
        return "unknown";
    }

    @Override
    protected String waitForState(String wantedState) {
        int timeout = this.getTimeoutMillis();
        long timeStart = System.currentTimeMillis();
        String state = this.detectState();
        while (!state.equals(wantedState) && System.currentTimeMillis() - timeStart < (long)timeout) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            state = this.detectState();
        }
        return state;
    }

    public List getActions() {
        return commands;
    }

    @Override
    public void doAction(String action) throws PluginException {
        try {
            if (action.equals("start")) {
                this.svc.start();
                this.setResult(0);
                return;
            }
            if (action.equals("stop")) {
                this.svc.stop();
                this.setResult(0);
                return;
            }
            if (action.equals("restart")) {
                if (this.isRunning()) {
                    this.svc.stop((long)this.getTimeoutMillis());
                }
                this.svc.start();
                this.setResult(0);
                return;
            }
        }
        catch (Win32Exception e) {
            this.setResult(-1);
            throw new PluginException(action + " " + this.getServiceName() + " failed: " + e.getMessage());
        }
        throw new PluginException("Action '" + action + "' not supported");
    }
}

