/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPIInfo;
import org.hyperic.hq.agent.AgentCommand;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.stats.AgentStatsCollector;

public class CommandDispatcher {
    private final Log log = LogFactory.getLog(CommandDispatcher.class);
    private final HashMap<String, AgentServerHandler> commands = new HashMap();
    private final AgentStatsCollector statsCollector = AgentStatsCollector.getInstance();
    private static final String COMMAND_DISPATCHER_INCOMING_COMMAND = "COMMAND_DISPATCHER_INCOMING_COMMAND";
    private static final String COMMAND_DISPATCHER_ILLEGAL_COMMAND = "COMMAND_DISPATCHER_ILLEGAL_COMMAND";

    CommandDispatcher() {
        this.statsCollector.register(COMMAND_DISPATCHER_ILLEGAL_COMMAND);
        this.statsCollector.register(COMMAND_DISPATCHER_INCOMING_COMMAND);
    }

    void addServerHandler(AgentServerHandler handler) {
        String[] cmds = handler.getCommandSet();
        for (int i = 0; i < cmds.length; ++i) {
            this.commands.put(cmds[i], handler);
            this.statsCollector.register("COMMAND_DISPATCHER_INCOMING_COMMAND_" + cmds[i].toUpperCase());
        }
    }

    public AgentRemoteValue processRequest(AgentCommand cmd, InputStream inStream, OutputStream outStream) throws AgentRemoteException {
        long start = this.now();
        String command = cmd.getCommand();
        boolean legalCommand = false;
        try {
            AgentServerHandler val = this.commands.get(cmd.getCommand());
            if (val == null) {
                throw new AgentRemoteException("Unknown command, '" + cmd.getCommand() + "'");
            }
            AgentServerHandler handler = val;
            AgentAPIInfo apiInfo = handler.getAPIInfo();
            if (!apiInfo.isCompatible(cmd.getCommandVersion())) {
                throw new AgentRemoteException("Client API mismatch: " + cmd.getCommandVersion() + " vs. " + apiInfo.getVersion());
            }
            legalCommand = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("processing cmd=" + cmd.getCommand()));
            }
            AgentRemoteValue agentRemoteValue = handler.dispatchCommand(cmd.getCommand(), cmd.getCommandArg(), inStream, outStream);
            return agentRemoteValue;
        }
        catch (AgentRemoteException exc) {
            throw exc;
        }
        catch (Exception exc) {
            this.log.error((Object)"Error while processing request", (Throwable)exc);
            throw new AgentRemoteException(exc.toString(), exc);
        }
        catch (LinkageError err) {
            AgentRemoteException e = new AgentRemoteException(err.toString());
            e.initCause((Throwable)err);
            throw e;
        }
        finally {
            long end = this.now();
            if (legalCommand) {
                this.statsCollector.addStat(end - start, COMMAND_DISPATCHER_INCOMING_COMMAND);
                this.statsCollector.addStat(end - start, "COMMAND_DISPATCHER_INCOMING_COMMAND_" + command.toUpperCase());
            } else {
                this.statsCollector.addStat(1L, COMMAND_DISPATCHER_ILLEGAL_COMMAND);
            }
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }
}

