/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file.match;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.hyperic.util.file.match.MatchSelector;
import org.hyperic.util.file.match.MatcherInterruptCallback;
import org.hyperic.util.file.match.MatcherProgressCallback;

public class MatcherConfig {
    public static final int DEPTH_INFINITE = -1;
    public static final int FS_ALL = 0;
    public static final int FS_LOCAL = 1;
    public static final int FS_NETWORK = 2;
    private List _searchDirs;
    private List _matchSelectors;
    private List _excludePatterns;
    private boolean _followSymlinks = false;
    private boolean _allowMultipleMatches = false;
    private int _filesystemTypes = 0;
    private int _maxDepth = -1;
    private Log _log;
    private MatcherInterruptCallback _interruptCB;
    private MatcherProgressCallback _progressCB;

    public MatcherConfig() {
        this._searchDirs = new ArrayList();
        this._matchSelectors = new ArrayList();
        this._excludePatterns = new ArrayList();
    }

    public MatcherConfig(List dirs, List matchSelectors, List excludePatterns, boolean followSymlinks, boolean allowMultipleMatches, int fsTypes, int maxDepth, MatcherInterruptCallback icb, MatcherProgressCallback pcb, Log log) {
        this._searchDirs = dirs;
        this._matchSelectors = matchSelectors;
        this._excludePatterns = excludePatterns;
        this._followSymlinks = followSymlinks;
        this._allowMultipleMatches = allowMultipleMatches;
        this._filesystemTypes = this.validateFSTypes(fsTypes);
        this.setMaxDepth(maxDepth);
        this._interruptCB = icb;
        this._progressCB = pcb;
        this._log = log;
    }

    private int validateFSTypes(int fsTypes) {
        if (fsTypes < 0 || fsTypes > 2) {
            throw new IllegalArgumentException("Illegal filesystem types");
        }
        return fsTypes;
    }

    public void addSearchDir(String dir) {
        this._searchDirs.add(dir);
    }

    public List getSearchDirs() {
        return this._searchDirs;
    }

    public void setSearchDirs(List dirs) {
        this._searchDirs = dirs;
    }

    public void addMatchSelector(MatchSelector ms) {
        this._matchSelectors.add(ms);
    }

    public List getMatchSelectors() {
        return this._matchSelectors;
    }

    public void setMatchSelectors(List ms) {
        this._matchSelectors = ms;
    }

    public void addExcludePattern(String pattern) {
        this._excludePatterns.add(pattern);
    }

    public List getExcludePatterns() {
        return this._excludePatterns;
    }

    public void setExcludePatterns(List patterns) {
        this._excludePatterns = patterns;
    }

    public int getFSTypes() {
        return this._filesystemTypes;
    }

    public void setFSTypes(int fs) {
        this._filesystemTypes = fs;
    }

    public boolean getFollowSymlinks() {
        return this._followSymlinks;
    }

    public void setFollowSymlinks(boolean fsm) {
        this._followSymlinks = fsm;
    }

    public boolean getAllowMultipleMatches() {
        return this._allowMultipleMatches;
    }

    public void setAllowMultipleMatches(boolean amm) {
        this._allowMultipleMatches = amm;
    }

    public Log getLog() {
        return this._log;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public int getMaxDepth() {
        return this._maxDepth;
    }

    public void setMaxDepth(int max) {
        if (max < 0 && max != -1) {
            throw new IllegalArgumentException("Max Depth cannot be negative.");
        }
        this._maxDepth = max;
    }

    public MatcherInterruptCallback getMatcherInterruptCB() {
        return this._interruptCB;
    }

    public void setMatcherInterruptCB(MatcherInterruptCallback icb) {
        this._interruptCB = icb;
    }

    public MatcherProgressCallback getMatcherProgressCB() {
        return this._progressCB;
    }

    public void setMatcherProgressCB(MatcherProgressCallback pcb) {
        this._progressCB = pcb;
    }
}

