/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessFinder;

public class MultiProcCpu
extends ProcCpu {
    private long pid;
    private int nproc = 0;

    static synchronized MultiProcCpu get(Sigar sigar, String query) throws SigarException {
        MultiProcCpu cpu = new MultiProcCpu();
        cpu.pid = query.hashCode();
        cpu.total = 0L;
        cpu.user = 0L;
        cpu.sys = 0L;
        cpu.percent = 0.0;
        long[] pids = ProcessFinder.find(sigar, query);
        cpu.nproc = pids.length;
        for (int i = 0; i < pids.length; ++i) {
            try {
                ProcCpu procCpu = sigar.getProcCpu(pids[i]);
                cpu.total += procCpu.getTotal();
                cpu.user += procCpu.getUser();
                cpu.sys += procCpu.getSys();
                cpu.percent += procCpu.getPercent();
                continue;
            }
            catch (SigarException e) {
                // empty catch block
            }
        }
        return cpu;
    }

    public double getPercent() {
        return this.percent;
    }

    public int getProcesses() {
        return this.nproc;
    }

    public int hashCode() {
        return (int)this.pid;
    }

    public boolean equals(Object cpu) {
        if (!(cpu instanceof MultiProcCpu)) {
            return false;
        }
        return ((MultiProcCpu)cpu).pid == this.pid;
    }
}

