/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.configuration.agent.server;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPIInfo;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.configuration.agent.ConfigurationCommandsAPI;
import org.hyperic.hq.configuration.agent.client.ConfigurationCommandsClient;
import org.hyperic.hq.configuration.agent.commands.Configuration_args;
import org.hyperic.hq.configuration.agent.commands.Configuration_result;
import org.hyperic.hq.configuration.agent.server.ConfigurationCommandsService;

public class ConfigurationCommandsServer
implements AgentServerHandler {
    private static final Log log = LogFactory.getLog(ConfigurationCommandsServer.class);
    private final ConfigurationCommandsAPI configurationCommandsAPI = new ConfigurationCommandsAPI();
    private ConfigurationCommandsService configurationCommandsService;

    public String[] getCommandSet() {
        return ConfigurationCommandsAPI.COMMANDS_SET;
    }

    public AgentAPIInfo getAPIInfo() {
        return this.configurationCommandsAPI;
    }

    public AgentRemoteValue dispatchCommand(String cmd, AgentRemoteValue args, InputStream inStream, OutputStream outStream) throws AgentRemoteException {
        if ("cfg:configure".equals(cmd)) {
            if (this.configurationCommandsService == null) {
                throw new AgentRemoteException("Dispatch command was invoked before configuration service initialized.");
            }
            Configuration_args configurationArgs = (Configuration_args)args;
            this.configurationCommandsService.configure(configurationArgs);
            return new Configuration_result();
        }
        throw new AgentRemoteException("Unknown command: " + cmd);
    }

    public void startup(AgentDaemon agent) throws AgentStartException {
        AgentTransportLifecycle agentTransportLifecycle = this.getTransportLifecycle(agent);
        this.configurationCommandsService = new ConfigurationCommandsService(agent);
        this.registerCommandsService(agentTransportLifecycle);
        log.info((Object)"Configuration Commands Server started up");
    }

    private void registerCommandsService(AgentTransportLifecycle agentTransportLifecycle) throws AgentStartException {
        log.info((Object)"Registering Configuration Commands Service with Agent Transport");
        try {
            agentTransportLifecycle.registerService(ConfigurationCommandsClient.class, (Object)this.configurationCommandsService);
        }
        catch (Exception e) {
            throw new AgentStartException("Failed to register Configuration Commands Service", e);
        }
    }

    private AgentTransportLifecycle getTransportLifecycle(AgentDaemon agent) throws AgentStartException {
        AgentTransportLifecycle agentTransportLifecycle;
        try {
            agentTransportLifecycle = agent.getAgentTransportLifecycle();
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get agent transport lifecycle: " + e.getMessage());
        }
        return agentTransportLifecycle;
    }

    public void postInitActions() throws AgentStartException {
    }

    public void shutdown() {
        log.info((Object)"Resource Configuration Commands Server shut down");
    }

    public void refreshOnPluginsChange() {
        log.info((Object)"Agent commands refreshOnPluginsChange");
    }
}

