/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.configuration.agent.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.configuration.agent.commands.Configuration_args;
import org.hyperic.hq.configuration.agent.repository.MissingConfigurationInfoExeption;
import org.hyperic.hq.configuration.agent.repository.model.ConfigurationInfo;
import org.hyperic.hq.configuration.agent.repository.model.ResourceKey;
import org.hyperic.hq.configuration.agent.repository.model.SchedulingInfo;
import org.hyperic.hq.product.TypeInfo;

public class ConfigurationInfoTranslator {
    private static final Log logger = LogFactory.getLog(ConfigurationInfoTranslator.class);
    private static Pattern LWO_CONFIG_PATTERN = Pattern.compile("(.+):(.+)\\|(.+)");
    private static final String PIPE_SEPERATOR = "\\|";
    private static final String VIRTUAL_SERVERS_PROP_NAME = "virtual_servers";
    private static final String VIRTUAL_SERVER_STRING_LIST_SEPERATOR = ";";
    private static final String VIRTUAL_SERVER_NAME_PROPERTIES_SEPERATOR = ":";
    private static final String VIRTUAL_SERVER_PROP_SEPERATOR = "=";
    private static final String VIRTUAL_SERVER_PROP_LIST_DELIMITERS = "{}";
    private static final String VIRTUAL_SERVER_PROP_LIST_SEPERATOR = ",";

    public static ConfigurationInfo translate(Configuration_args configurationArgs, AgentDaemon agentDaemon) throws MissingConfigurationInfoExeption {
        if (configurationArgs == null) {
            throw new MissingConfigurationInfoExeption(MissingConfigurationInfoExeption.MissingConfigurationInfoError.NULL_ARGS);
        }
        ConfigurationInfo configInfo = new ConfigurationInfo();
        ConfigurationInfoTranslator.translateResourceKey(configurationArgs, configInfo);
        ConfigurationInfoTranslator.translateResourceKind(configurationArgs, configInfo, agentDaemon);
        ConfigurationInfoTranslator.translateResourceInternalId(configurationArgs, configInfo);
        ConfigurationInfoTranslator.translateSchedulings(configurationArgs, configInfo);
        ConfigurationInfoTranslator.translateConfiguration(configurationArgs, configInfo);
        return configInfo;
    }

    private static void addTypeInfo(Configuration_args configurationArgs, AgentDaemon agentDaemon, ConfigurationInfo configInfo) throws MissingConfigurationInfoExeption {
        String resourceKind = configurationArgs.getResourceKind();
        try {
            TypeInfo typeInfo = agentDaemon.getTypeInfo(resourceKind);
            configInfo.setTypeInfo(typeInfo);
        }
        catch (Exception e) {
            throw new MissingConfigurationInfoExeption(MissingConfigurationInfoExeption.MissingConfigurationInfoError.RESOURCE_KIND_HAS_NO_TYPE_INFO, e);
        }
        if (null == configInfo.getTypeInfo()) {
            throw new MissingConfigurationInfoExeption(MissingConfigurationInfoExeption.MissingConfigurationInfoError.RESOURCE_KIND_HAS_NO_TYPE_INFO, resourceKind);
        }
    }

    private static void translateResourceKind(Configuration_args configurationArgs, ConfigurationInfo configInfo, AgentDaemon agentDaemon) throws MissingConfigurationInfoExeption {
        String resourceKind = configurationArgs.getResourceKind();
        if (resourceKind == null) {
            throw new MissingConfigurationInfoExeption(MissingConfigurationInfoExeption.MissingConfigurationInfoError.MISSING_RESOUCE_KIND);
        }
        configInfo.setResourceKind(resourceKind);
        ConfigurationInfoTranslator.addTypeInfo(configurationArgs, agentDaemon, configInfo);
    }

    public static void translateResourceInternalId(Configuration_args configurationArgs, ConfigurationInfo configInfo) throws MissingConfigurationInfoExeption {
        String internalId = configurationArgs.getResourceInternalId();
        if (internalId == null) {
            throw new MissingConfigurationInfoExeption(MissingConfigurationInfoExeption.MissingConfigurationInfoError.MISSING_RESOUCE_INTERNAL_ID);
        }
        try {
            configInfo.setResourceInternalId(Integer.parseInt(internalId));
        }
        catch (NumberFormatException e) {
            throw new MissingConfigurationInfoExeption(MissingConfigurationInfoExeption.MissingConfigurationInfoError.BAD_RESOUCE_INTERNAL_ID);
        }
    }

    private static void translateResourceKey(Configuration_args configurationArgs, ConfigurationInfo configInfo) throws MissingConfigurationInfoExeption {
        String monitoresResourceId = configurationArgs.getMonitoredResourceId();
        String parentId = configurationArgs.getParentId();
        if (monitoresResourceId == null || parentId == null) {
            throw new MissingConfigurationInfoExeption(MissingConfigurationInfoExeption.MissingConfigurationInfoError.MISSING_RESOUCE_KEY);
        }
        configInfo.setResourceKey(new ResourceKey(parentId, monitoresResourceId));
    }

    private static void translateSchedulings(Configuration_args configurationArgs, ConfigurationInfo configInfo) {
        List rawSchedulings = configurationArgs.getSchedulings();
        if (CollectionUtils.isEmpty((Collection)rawSchedulings)) {
            configInfo.setScheduling(Collections.<SchedulingInfo>emptyList());
        }
        ArrayList<SchedulingInfo> schedulings = new ArrayList<SchedulingInfo>(rawSchedulings.size());
        HashMap<String, List<SchedulingInfo>> lwoScheduling = new HashMap<String, List<SchedulingInfo>>();
        for (String[] rawSchedule : rawSchedulings) {
            try {
                String[] lwo = ConfigurationInfoTranslator.extractLwoTypeAndInstance2Key(rawSchedule[2]);
                if (lwo == null) {
                    schedulings.add(new SchedulingInfo(rawSchedule[2], Integer.parseInt(rawSchedule[0]), Long.parseLong(rawSchedule[1])));
                    continue;
                }
                SchedulingInfo schedulingInfo = new SchedulingInfo(lwo[1], Integer.parseInt(rawSchedule[0]), Long.parseLong(rawSchedule[1]));
                if (lwoScheduling.containsKey(lwo[0])) {
                    ((List)lwoScheduling.get(lwo[0])).add(schedulingInfo);
                    continue;
                }
                ArrayList<SchedulingInfo> lwoMetrics = new ArrayList<SchedulingInfo>();
                lwoMetrics.add(schedulingInfo);
                lwoScheduling.put(lwo[0], lwoMetrics);
            }
            catch (NumberFormatException e) {
                logger.error((Object)(e + "Failed to parse this schedule info: " + ConfigurationInfoTranslator.convertRawSchedulingToString(rawSchedule)));
            }
        }
        configInfo.setScheduling(schedulings);
        configInfo.setLwoScheduling(lwoScheduling);
    }

    private static void translateConfiguration(Configuration_args configurationArgs, ConfigurationInfo configInfo) {
        configInfo.setConfiguration(configurationArgs.getConfiguration());
        configInfo.setSecuredConfiguration(configurationArgs.getSecuredConfiguration());
        Map allProperties = configurationArgs.getProperties();
        configInfo.setProperties(new HashMap<String, String>());
        configInfo.setLwoConfiguration(new HashMap<String, Map<String, String>>());
        for (Map.Entry configEntry : allProperties.entrySet()) {
            String[] lwoTypeAndInstance2Key = ConfigurationInfoTranslator.extractLwoTypeAndInstance2Key((String)configEntry.getKey());
            if (lwoTypeAndInstance2Key == null) {
                String key = ConfigurationInfoTranslator.prefixPlatformConfigKey((String)configEntry.getKey(), configInfo.getTypeInfo());
                if (key.equals(VIRTUAL_SERVERS_PROP_NAME)) {
                    configInfo.setVirtualServerConfiguration(ConfigurationInfoTranslator.getVirtualServers((String)configEntry.getValue()));
                    continue;
                }
                configInfo.getProperties().put(key, (String)configEntry.getValue());
                continue;
            }
            Map<String, String> lwoConfiguration = configInfo.getLwoConfiguration().get(lwoTypeAndInstance2Key[0]);
            if (lwoConfiguration == null) {
                lwoConfiguration = new HashMap<String, String>();
            }
            lwoConfiguration.put(lwoTypeAndInstance2Key[1], (String)configEntry.getValue());
            configInfo.getLwoConfiguration().put(lwoTypeAndInstance2Key[0], lwoConfiguration);
        }
    }

    private static String prefixPlatformConfigKey(String key, TypeInfo typeInfo) {
        if (1 == typeInfo.getType()) {
            return PlatformKeyConfigPrefix.prefixKey(key);
        }
        return key;
    }

    private static Map<String, Map<String, String>> getVirtualServers(String virtualServerStrList) {
        HashMap<String, Map<String, String>> virtualServerProperties = new HashMap<String, Map<String, String>>();
        for (String virtualServerStr : StringUtils.split((String)virtualServerStrList, (String)VIRTUAL_SERVER_STRING_LIST_SEPERATOR)) {
            String[] fields = StringUtils.split((String)virtualServerStr, (String)VIRTUAL_SERVER_NAME_PROPERTIES_SEPERATOR);
            if (fields.length != 2) {
                logger.error((Object)"unexpected properties structure for virtual server");
                continue;
            }
            String vServerName = fields[0];
            String virtualServerPropStrList = StringUtils.strip((String)fields[1], (String)VIRTUAL_SERVER_PROP_LIST_DELIMITERS);
            HashMap<String, String> vServerProperties = new HashMap<String, String>();
            for (String virtualServerProp : StringUtils.split((String)virtualServerPropStrList, (String)VIRTUAL_SERVER_PROP_LIST_SEPERATOR)) {
                vServerProperties.put(StringUtils.substringBefore((String)virtualServerProp, (String)VIRTUAL_SERVER_PROP_SEPERATOR), StringUtils.substringAfter((String)virtualServerProp, (String)VIRTUAL_SERVER_PROP_SEPERATOR));
            }
            virtualServerProperties.put(vServerName, vServerProperties);
        }
        return virtualServerProperties;
    }

    private static String[] extractLwoTypeAndInstance2Key(String key) {
        if (ConfigurationInfoTranslator.isLwoPattern(key)) {
            return key.split(PIPE_SEPERATOR, 2);
        }
        return null;
    }

    private static boolean isLwoPattern(String key) {
        Matcher m = LWO_CONFIG_PATTERN.matcher(key);
        return m.matches() && m.groupCount() == 3;
    }

    private static String convertRawSchedulingToString(String[] rawSchedule) {
        StringBuilder sb = new StringBuilder("Failed to parse this schdule info: ");
        sb.append("Name: ").append(rawSchedule[2]);
        sb.append("ID: ").append(rawSchedule[0]);
        sb.append("Polling interval: ").append(rawSchedule[1]);
        return sb.toString();
    }

    public static enum PlatformKeyConfigPrefix {
        NAME("name"),
        FQDN("fqdn"),
        IP("ip"),
        TYPE("type"),
        ID("id");

        public static final String PREFIX = "platform.";
        private final String key;

        private PlatformKeyConfigPrefix(String key) {
            this.key = key;
        }

        public static String prefixKey(String key) {
            for (PlatformKeyConfigPrefix platformConfigKey : PlatformKeyConfigPrefix.values()) {
                if (!platformConfigKey.key.equals(key)) continue;
                return PREFIX + key;
            }
            return key;
        }

        public String getKey() {
            return this.key;
        }

        public String getPrefixedKey() {
            return PREFIX + this.key;
        }
    }
}

