/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.util.PropertyEncryptionUtil;
import org.hyperic.util.PropertyUtilException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.security.SecurityUtil;

public enum KeystoreCredentialsManager {
    INSTANCE;

    private static final Log log;
    private static final String PWD_FILE_EXT = ".pwd";
    private static final SecureRandom random;
    private static final int NUM_OF_GEN_PWD_DIGITS = 12;
    private static final int PASSWORD_MAX_LENGTH = 120;
    private static final int CIPHER_MAX_LENGTH = 221;
    private static final String PASSWORD_ENCODING = "UTF-8";
    private final KeystoreCredentialCache cache = new KeystoreCredentialCache();
    private char[] encryptionKey = null;

    public static KeystoreCredentialsManager getInstance() {
        return INSTANCE;
    }

    public synchronized char[] getKeystorePassword(File keystore, char[] userDefaultPassword) throws IOException {
        char[] cachedPassword = this.cache.get(keystore);
        if (cachedPassword == null) {
            log.debug((Object)"Keystore password not in cache, fetching from file.");
            char[] fetchedPassword = this.fetchKeystorePassword(keystore);
            if (fetchedPassword == null) {
                log.debug((Object)"Keystore password not in file (or invalid). Creating password file.");
                char[] storedPassword = this.createKeystorePassword(keystore, userDefaultPassword);
                this.cache.put(keystore, storedPassword);
                return storedPassword;
            }
            this.cache.put(keystore, fetchedPassword);
            return fetchedPassword;
        }
        return cachedPassword;
    }

    private char[] createKeystorePassword(File keystore, char[] password) throws IOException {
        if ("AUTO_GENERATED".equals(String.valueOf(password))) {
            log.info((Object)("Generating random password for keystore: " + keystore.getPath()));
            return this.writeKeystorePassword(keystore, this.generatePassword());
        }
        if (this.isValid(String.valueOf(password))) {
            log.info((Object)"Encrypting given password before writing it to file.");
            this.writeKeystorePassword(keystore, this.encrypt(password));
            return password;
        }
        log.warn((Object)"Password is invalid, generating a new one.");
        return this.writeKeystorePassword(keystore, this.generatePassword());
    }

    private char[] fetchKeystorePassword(File keystore) throws IOException {
        File keystorePasswordFile = this.getKeystorePasswordFile(keystore);
        try {
            if (keystorePasswordFile.exists()) {
                log.debug((Object)("Reading keystore password from file: " + keystorePasswordFile.getPath()));
                String fetchedPassword = FileUtils.readFileToString((File)keystorePasswordFile, (String)PASSWORD_ENCODING);
                String password = null;
                if (SecurityUtil.isMarkedEncrypted((String)fetchedPassword)) {
                    if (this.isCipherValid(fetchedPassword)) {
                        String decryptedPassword;
                        password = decryptedPassword = SecurityUtil.decrypt((char[])this.fetchEncryptionKey(), (String)fetchedPassword);
                    }
                } else {
                    password = fetchedPassword;
                }
                if (this.isValid(password)) {
                    return password.toCharArray();
                }
            }
        }
        catch (IOException e) {
            throw this.loggedIOException("Couldn't read keystore password from file: " + keystorePasswordFile.getPath(), e);
        }
        catch (PropertyUtilException e) {
            throw this.loggedIOException("Couldn't decrypt keystore password", (Exception)((Object)e));
        }
        return null;
    }

    private char[] writeKeystorePassword(File keystore, char[] password) throws IOException {
        File keystorePassword = this.getKeystorePasswordFile(keystore);
        try {
            log.debug((Object)("Writing keystore password to file: " + keystorePassword.getPath()));
            FileUtils.writeStringToFile((File)this.getKeystorePasswordFile(keystore), (String)String.valueOf(password), (String)PASSWORD_ENCODING);
            return password;
        }
        catch (IOException e) {
            throw this.loggedIOException("Couldn't write keystore password to file: " + keystorePassword.getPath(), e);
        }
    }

    private char[] generatePassword() {
        return new BigInteger(60, random).toString(32).toCharArray();
    }

    private File getKeystorePasswordFile(File keystore) {
        File pwdfile = new File(keystore.getParent(), keystore.getName() + PWD_FILE_EXT);
        return pwdfile;
    }

    private boolean isValid(String password) {
        return !StringUtil.isNullOrEmpty((String)password) && password.length() <= 120;
    }

    private boolean isCipherValid(String cipher) {
        return cipher.length() <= 221;
    }

    private char[] fetchEncryptionKey() throws PropertyUtilException {
        if (this.encryptionKey == null) {
            this.encryptionKey = PropertyEncryptionUtil.getPropertyEncryptionKey((String)AgentConfig.PROP_ENC_KEY_FILE[1]);
        }
        return this.encryptionKey;
    }

    private char[] encrypt(char[] password) {
        try {
            return SecurityUtil.encrypt((char[])this.fetchEncryptionKey(), (char[])password).toCharArray();
        }
        catch (PropertyUtilException e) {
            log.warn((Object)"Couldn't encrypt keystore password. Continuing.", (Throwable)e);
            return password;
        }
    }

    private IOException loggedIOException(String msg, Exception e) throws IOException {
        log.error((Object)msg, (Throwable)e);
        return new IOException(msg, e);
    }

    static {
        log = LogFactory.getLog(KeystoreCredentialsManager.class);
        random = new SecureRandom();
    }

    private static class KeystoreCredentialCache {
        private final Map<File, char[]> credentials = new HashMap<File, char[]>(1);

        private KeystoreCredentialCache() {
        }

        private char[] get(File keystore) {
            if (this.credentials.containsKey(keystore)) {
                log.debug((Object)("Retrieved cached password for keystore: " + keystore.getPath()));
                return this.credentials.get(keystore);
            }
            return null;
        }

        private void put(File keystore, char[] password) {
            this.credentials.put(keystore, password);
        }
    }
}

