/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.util.config.ConfigResponse;

public class ProcessControlPlugin
extends ControlPlugin {
    public static final String KILL = "kill";
    public static final String SIGHUP = "SIGHUP";
    public static final String SIGINT = "SIGINT";
    public static final String SIGQUIT = "SIGQUIT";
    public static final String SIGKILL = "SIGKILL";
    public static final String SIGTERM = "SIGTERM";
    public static final String SIGUSR1 = "SIGUSR1";
    public static final String SIGUSR2 = "SIGUSR2";
    public static final List ACTIONS = Arrays.asList("kill", "SIGHUP", "SIGINT", "SIGQUIT", "SIGKILL", "SIGTERM", "SIGUSR1", "SIGUSR2");
    private static final Map SIGNALS = new HashMap();
    private static final int POSIX_SIGHUP = 1;
    private static final int POSIX_SIGINT = 2;
    private static final int POSIX_SIGQUIT = 3;
    private static final int POSIX_SIGKILL = 9;
    private static final int POSIX_SIGTERM = 15;
    private String _ptql;

    @Override
    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        if (SIGNALS.size() != 0) {
            return;
        }
        SIGNALS.put(SIGINT, new Integer(2));
        SIGNALS.put(SIGTERM, new Integer(15));
        if (!SigarLoader.IS_WIN32) {
            SIGNALS.put(SIGHUP, new Integer(1));
            SIGNALS.put(SIGQUIT, new Integer(3));
            SIGNALS.put(SIGKILL, new Integer(9));
        }
        if (SigarLoader.IS_AIX || SigarLoader.IS_DARWIN || SigarLoader.IS_FREEBSD) {
            SIGNALS.put(SIGUSR1, new Integer(30));
            SIGNALS.put(SIGUSR2, new Integer(31));
        } else if (SigarLoader.IS_SOLARIS || SigarLoader.IS_HPUX) {
            SIGNALS.put(SIGUSR1, new Integer(16));
            SIGNALS.put(SIGUSR2, new Integer(17));
        } else if (SigarLoader.IS_LINUX) {
            SIGNALS.put(SIGUSR1, new Integer(10));
            SIGNALS.put(SIGUSR2, new Integer(12));
        } else if (SigarLoader.IS_WIN32) {
            SIGNALS.put(SIGKILL, new Integer(15));
        }
    }

    @Override
    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this._ptql = config.getValue("process.query");
    }

    public List getActions() {
        return ACTIONS;
    }

    protected boolean killAll() {
        return false;
    }

    public static int getSignal(String signal) throws PluginException {
        if (Character.isDigit(signal.charAt(0))) {
            try {
                return Integer.parseInt(signal);
            }
            catch (NumberFormatException e) {
                throw new PluginException(signal + ": " + e);
            }
        }
        Integer num = (Integer)SIGNALS.get(signal);
        if (num == null) {
            num = (Integer)SIGNALS.get("SIG" + signal);
        }
        if (num == null) {
            throw new PluginException("Invalid signal: " + signal);
        }
        return num;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doAction(String action, String[] args) throws PluginException {
        long[] pids;
        String signal;
        if (action.equals(KILL)) {
            if (args.length == 0) {
                signal = SIGKILL;
            } else {
                if (args.length != 1) throw new PluginException("Too many arguments");
                signal = args[0].toUpperCase();
            }
        } else {
            if (args.length != 0) throw new PluginException("Too many arguments");
            signal = action;
            if (signal.startsWith("-")) {
                signal = signal.substring(1);
            }
        }
        int signum = ProcessControlPlugin.getSignal(signal);
        Sigar sigar = new Sigar();
        ArrayList<Long> killed = new ArrayList<Long>();
        try {
            pids = ProcessFinder.find((Sigar)sigar, (String)this._ptql);
            if (pids.length == 0) {
                this.setResult(-1);
                this.setMessage("No processes match query: " + this._ptql);
                return;
            }
            if (pids.length > 1 && !this.killAll()) {
                this.setMessage(pids.length + " processes match query: " + this._ptql);
                return;
            }
        }
        catch (SigarException e) {
            sigar.close();
            throw new PluginException(this._ptql + ": " + (Object)((Object)e));
        }
        for (int i = 0; i < pids.length; ++i) {
            try {
                sigar.kill(pids[i], signum);
                killed.add(new Long(pids[i]));
                continue;
            }
            catch (SigarException e) {
                this.setResult(-1);
                this.setMessage(e.getMessage());
            }
        }
        sigar.close();
        this.setResult(0);
        this.setMessage("kill " + signal + " " + killed);
    }
}

