/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.SupportedOperatingSystem;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.util.config.ConfigResponse;

public class PlatformDetector
extends GenericPlugin {
    public static final boolean IS_WIN32 = OperatingSystem.IS_WIN32;
    private static final String[] EMPARR = new String[0];
    public static final String[] UNIX_PLATFORM_NAMES = SupportedOperatingSystem.getSupportedUnixPlatforms().toArray(EMPARR);
    public static String[] WIN32_PLATFORM_NAMES = SupportedOperatingSystem.getSupportedWindowsPlatforms().toArray(EMPARR);
    public static final String[] PLATFORM_NAMES = SupportedOperatingSystem.getSupportedPlatforms().toArray(EMPARR);

    public static boolean isSupportedPlatform(String name) {
        return SupportedOperatingSystem.isSupported(name);
    }

    public static boolean isWin32(String name) {
        return OperatingSystem.isWin32((String)name);
    }

    private String getValue(ConfigResponse config, String key) throws PluginException {
        String value = config.getValue(key);
        if (value == null) {
            throw new PluginException("Cannot detect platform with " + key + "=null");
        }
        return value;
    }

    public PlatformResource getPlatformResource(ConfigResponse config) throws PluginException {
        if (config == null) {
            throw new PluginException("Cannot detect platform with config=null");
        }
        String type = this.getValue(config, "platform.type");
        String fqdn = this.getValue(config, "platform.fqdn");
        String addr = this.getValue(config, "platform.ip");
        String name = config.getValue("platform.name");
        PlatformResource platform = new PlatformResource();
        platform.setFqdn(fqdn);
        platform.setPlatformTypeName(type);
        platform.setName(name);
        platform.setCpuCount(new Integer(1));
        platform.addInterface(addr, null, null);
        return platform;
    }
}

