/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.thread;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.PropertyConfigurator;
import org.hyperic.util.thread.MultiRunnable;

@Deprecated
public class MultiRunner {
    public static final String PROP_CLONE_SPAWN_SLEEP = "clone.spawn.sleep";
    public static final String PROP_CLONE_CLASSPATH = "clone.classpath";
    public static final String PROP_CLONE_NUM = "clone.number";
    public static final String PROP_CLONE_CLASS = "clone.class";
    private final Properties _props;

    public MultiRunner(Properties p) {
        this._props = p;
    }

    private ClassLoader createThreadClassLoader() throws Exception {
        String classPath = this._props.getProperty(PROP_CLONE_CLASSPATH);
        String[] split = classPath.split(":");
        URL[] urls = new URL[split.length];
        for (int i = 0; i < split.length; ++i) {
            File f = new File(split[i].trim());
            if (!f.canRead()) {
                System.out.println("Can't read [" + f.getAbsolutePath() + "]");
            }
            urls[i] = f.toURL();
        }
        return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread(int threadNo) throws Exception {
        ClassLoader cl = this.createThreadClassLoader();
        String className = this._props.getProperty(PROP_CLONE_CLASS);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> c = cl.loadClass(className);
            MultiRunnable r = (MultiRunnable)c.newInstance();
            Properties subProps = new Properties();
            subProps.putAll((Map<?, ?>)this._props);
            MDC.put((String)"cloneId", (Object)("clone-" + threadNo));
            Logger.getLogger(MultiRunner.class).info((Object)("Initializing log for clone-" + threadNo));
            TargetRunnable tr = new TargetRunnable(cl, r, threadNo, subProps);
            Thread t = new Thread(tr);
            t.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public void runThreads() throws Exception {
        String cloneSleepStr = this._props.getProperty(PROP_CLONE_SPAWN_SLEEP);
        long cloneSleep = Long.parseLong(cloneSleepStr);
        String numClonesStr = this._props.getProperty(PROP_CLONE_NUM);
        int numClones = Integer.parseInt(numClonesStr);
        for (int i = 0; i < numClones; ++i) {
            this.startThread(i);
            Thread.sleep(cloneSleep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Properties p = new Properties();
        File in = new File(args[0]);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(in);
            p.load(fis);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        BasicConfigurator.configure();
        PropertyConfigurator.configure((String)args[0]);
        Logger.getLogger(MultiRunner.class).info((Object)"MultiRunner.class");
        MultiRunner m = new MultiRunner(p);
        m.runThreads();
    }

    private static class TargetRunnable
    implements Runnable {
        private final ClassLoader _loader;
        private final MultiRunnable _target;
        private final int _threadNo;
        private final Properties _props;

        TargetRunnable(ClassLoader cl, MultiRunnable target, int threadNo, Properties props) {
            this._loader = cl;
            this._target = target;
            this._threadNo = threadNo;
            this._props = props;
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setContextClassLoader(this._loader);
                this._target.configure(this._threadNo, this._props);
                this._target.run();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

