/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

public class AgentMonitorValue {
    public static final int TYPE_STRING = 0;
    public static final int TYPE_DOUBLE = 1;
    public static final int TYPE_ASTRING = 2;
    public static final int TYPE_AINT = 3;
    public static final int ERR_INCALCULABLE = 1;
    public static final int ERR_BADKEY = 2;
    public static final int ERR_BADMONITOR = 3;
    public static final int ERR_INTERNAL = 4;
    private boolean isErr;
    private int errCode;
    private int type;
    private String sValue;
    private double dValue;
    private String[] asValue;
    private int[] aiValue;

    public AgentMonitorValue() {
        this.setErrCode(2);
        this.type = 0;
    }

    public AgentMonitorValue(String value) {
        this.setValue(value);
    }

    public AgentMonitorValue(double value) {
        this.setValue(value);
    }

    public AgentMonitorValue(String[] value) {
        this.setValue(value);
    }

    public AgentMonitorValue(int[] value) {
        this.setValue(value);
    }

    public boolean isErr() {
        return this.isErr;
    }

    public void setErrCode(int errCode) {
        this.isErr = true;
        this.errCode = errCode;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        AgentMonitorValue.checkValidType(type);
        this.type = type;
    }

    public String getStringValue() {
        if (this.isErr || this.type != 0) {
            throw new IllegalStateException("Monitor value not a String");
        }
        return this.sValue;
    }

    public void setValue(String sValue) {
        this.isErr = false;
        this.sValue = sValue;
        this.type = 0;
    }

    public double getDoubleValue() {
        if (this.isErr || this.type != 1) {
            throw new IllegalStateException("Monitor value not a Double");
        }
        return this.dValue;
    }

    public void setValue(double dValue) {
        this.isErr = false;
        this.dValue = dValue;
        this.type = 1;
    }

    public String[] getAStringValue() {
        if (this.isErr || this.type != 2) {
            throw new IllegalStateException("Monitor value not an AString");
        }
        return this.asValue;
    }

    public void setValue(String[] asValue) {
        this.isErr = false;
        this.asValue = asValue;
        this.type = 2;
    }

    public int[] getAIntValue() {
        if (this.isErr || this.type != 3) {
            throw new IllegalStateException("Monitor value not an AInt");
        }
        return this.aiValue;
    }

    public void setValue(int[] aiValue) {
        this.isErr = false;
        this.aiValue = aiValue;
        this.type = 3;
    }

    public static void checkValidType(int type) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Unknown type, '" + type + "'");
        }
    }

    public String toString() {
        if (this.isErr) {
            switch (this.errCode) {
                case 1: {
                    return "**ERR INCALCULABLE**";
                }
                case 2: {
                    return "**ERR BADKEY**";
                }
                case 3: {
                    return "**ERR BADMONITOR**";
                }
                case 4: {
                    return "**ERR INTERNAL**";
                }
            }
            return "**ERR UNKNOWN**";
        }
        switch (this.type) {
            case 0: {
                return this.sValue;
            }
            case 1: {
                return Double.toString(this.dValue);
            }
            case 2: {
                String res = "{";
                for (int i = 0; i < this.asValue.length; ++i) {
                    res = res + "'" + this.asValue[i] + "'";
                    if (i == this.asValue.length - 1) continue;
                    res = res + ", ";
                }
                return res + "}";
            }
            case 3: {
                String res = "{";
                for (int i = 0; i < this.aiValue.length; ++i) {
                    res = res + Integer.toString(this.aiValue[i]);
                    if (i == this.aiValue.length - 1) continue;
                    res = res + ", ";
                }
                return res + "}";
            }
        }
        return "**ERR UNKNOWN**";
    }
}

