/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.ServerSocketFactory;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

class PortWatcher
implements Runnable {
    private static Vector pool = new Vector();
    private static InetAddress anyLocalAddress = null;
    Session session;
    int lport;
    int rport;
    String host;
    InetAddress boundaddress;
    Runnable thread;
    ServerSocket ss;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = pool;
        synchronized (vector2) {
            int n = 0;
            while (n < pool.size()) {
                PortWatcher portWatcher = (PortWatcher)pool.elementAt(n);
                if (portWatcher.session == session) {
                    vector.addElement(portWatcher.lport + ":" + portWatcher.host + ":" + portWatcher.rport);
                }
                ++n;
            }
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static PortWatcher getPort(Session session, String string, int n) throws JSchException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new JSchException("PortForwardingL: invalid address " + string + " specified.", unknownHostException);
        }
        Vector vector = pool;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < pool.size()) {
                PortWatcher portWatcher = (PortWatcher)pool.elementAt(n2);
                if (portWatcher.session == session && portWatcher.lport == n) {
                    if (anyLocalAddress != null) {
                        if (portWatcher.boundaddress.equals(anyLocalAddress)) return portWatcher;
                    }
                    if (portWatcher.boundaddress.equals(inetAddress)) {
                        return portWatcher;
                    }
                }
                ++n2;
            }
            return null;
        }
    }

    static PortWatcher addPort(Session session, String string, int n, String string2, int n2, ServerSocketFactory serverSocketFactory) throws JSchException {
        if (PortWatcher.getPort(session, string, n) != null) {
            throw new JSchException("PortForwardingL: local port " + string + ":" + n + " is already registered.");
        }
        PortWatcher portWatcher = new PortWatcher(session, string, n, string2, n2, serverSocketFactory);
        pool.addElement(portWatcher);
        return portWatcher;
    }

    static void delPort(Session session, String string, int n) throws JSchException {
        PortWatcher portWatcher = PortWatcher.getPort(session, string, n);
        if (portWatcher == null) {
            throw new JSchException("PortForwardingL: local port " + string + ":" + n + " is not registered.");
        }
        portWatcher.delete();
        pool.removeElement(portWatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        Vector vector = pool;
        synchronized (vector) {
            PortWatcher[] portWatcherArray = new PortWatcher[pool.size()];
            int n = 0;
            int n2 = 0;
            while (n2 < pool.size()) {
                PortWatcher portWatcher = (PortWatcher)pool.elementAt(n2);
                if (portWatcher.session == session) {
                    portWatcher.delete();
                    portWatcherArray[n++] = portWatcher;
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                PortWatcher portWatcher = portWatcherArray[n3];
                pool.removeElement(portWatcher);
                ++n3;
            }
        }
    }

    PortWatcher(Session session, String string, int n, String string2, int n2, ServerSocketFactory serverSocketFactory) throws JSchException {
        int n3;
        this.session = session;
        this.lport = n;
        this.host = string2;
        this.rport = n2;
        try {
            this.boundaddress = InetAddress.getByName(string);
            this.ss = serverSocketFactory == null ? new ServerSocket(n, 0, this.boundaddress) : serverSocketFactory.createServerSocket(n, 0, this.boundaddress);
        }
        catch (Exception exception) {
            String string3 = "PortForwardingL: local port " + string + ":" + n + " cannot be bound.";
            if (exception instanceof Throwable) {
                throw new JSchException(string3, exception);
            }
            throw new JSchException(string3);
        }
        if (n == 0 && (n3 = this.ss.getLocalPort()) != -1) {
            this.lport = n3;
        }
    }

    public void run() {
        this.thread = this;
        try {
            while (this.thread != null) {
                Socket socket = this.ss.accept();
                socket.setTcpNoDelay(true);
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                ChannelDirectTCPIP channelDirectTCPIP = new ChannelDirectTCPIP();
                channelDirectTCPIP.init();
                channelDirectTCPIP.setInputStream(inputStream);
                channelDirectTCPIP.setOutputStream(outputStream);
                this.session.addChannel(channelDirectTCPIP);
                channelDirectTCPIP.setHost(this.host);
                channelDirectTCPIP.setPort(this.rport);
                channelDirectTCPIP.setOrgIPAddress(socket.getInetAddress().getHostAddress());
                channelDirectTCPIP.setOrgPort(socket.getPort());
                channelDirectTCPIP.connect();
                if (channelDirectTCPIP.exitstatus == -1) continue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delete();
    }

    void delete() {
        this.thread = null;
        try {
            if (this.ss != null) {
                this.ss.close();
            }
            this.ss = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            anyLocalAddress = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

