/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.configuration.agent.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.configuration.agent.repository.ConfigurationInfoTranslator;
import org.hyperic.hq.configuration.agent.repository.ResourceRepositoryException;
import org.hyperic.hq.configuration.agent.repository.model.ConfigurationInfo;
import org.hyperic.hq.configuration.agent.repository.model.ResourceKey;
import org.hyperic.hq.product.TypeInfo;

public class ResourceRepositoryService {
    private static final Log log = LogFactory.getLog(ResourceRepositoryService.class);
    private static final int MAX_HIERARCHY_DEPTH = 3;
    private static ResourceRepositoryService instance;
    private final MultiValueMap resourceRelationships = new MultiValueMap();
    private final Map<ResourceKey, ConfigurationInfo> configurationInfos = new HashMap<ResourceKey, ConfigurationInfo>();

    public static synchronized ResourceRepositoryService getInstance() {
        if (instance == null) {
            instance = new ResourceRepositoryService();
        }
        return instance;
    }

    public ConfigurationInfo.ChangeType compareAndSwap(ConfigurationInfo newConfiguration) throws ResourceRepositoryException {
        if (newConfiguration == null) {
            throw new ResourceRepositoryException(ResourceRepositoryException.ResourceRepositoryError.NULL_CONFIG);
        }
        if (newConfiguration.getResourceKind() == null) {
            throw new ResourceRepositoryException(ResourceRepositoryException.ResourceRepositoryError.MISSING_RESOURCE_KIND);
        }
        ResourceKey resourceKey = newConfiguration.getResourceKey();
        if (resourceKey == null) {
            throw new ResourceRepositoryException(ResourceRepositoryException.ResourceRepositoryError.MISSING_RESOURCE_KEY);
        }
        ConfigurationInfo oldConfigInfo = this.configurationInfos.get(newConfiguration.getResourceKey());
        ConfigurationInfo.ChangeType changeType = newConfiguration.compare(oldConfigInfo);
        if (changeType == null) {
            throw new ResourceRepositoryException(ResourceRepositoryException.ResourceRepositoryError.RESOURCE_KINDS_DIFFER);
        }
        if (ConfigurationInfo.ChangeType.EQUAL.equals((Object)changeType)) {
            return changeType;
        }
        this.configurationInfos.put(resourceKey, newConfiguration);
        ResourceKey parentResourceKey = resourceKey.getParentResourceKey();
        if (parentResourceKey != null) {
            if (this.resourceRelationships.containsKey((Object)parentResourceKey)) {
                if (!this.resourceRelationships.getCollection((Object)parentResourceKey).contains(resourceKey)) {
                    this.resourceRelationships.put((Object)parentResourceKey, (Object)resourceKey);
                }
            } else {
                this.resourceRelationships.put((Object)parentResourceKey, (Object)resourceKey);
            }
        }
        return changeType;
    }

    public ConfigurationInfo getConfiguration(ResourceKey resourceKey) {
        return this.configurationInfos.get(resourceKey);
    }

    public ConfigurationInfo getParentConfiguration(ResourceKey resourceKey) {
        ResourceKey parentResourceKey = resourceKey.getParentResourceKey();
        if (parentResourceKey == null) {
            return null;
        }
        return this.configurationInfos.get(parentResourceKey);
    }

    public boolean isResourceReadyForConfigurationAndScheduling(ResourceKey resourceKey) throws ResourceRepositoryException {
        if (resourceKey == null || !this.configurationInfos.containsKey(resourceKey)) {
            return false;
        }
        ConfigurationInfo config = this.configurationInfos.get(resourceKey);
        if (this.isTopOfHierarchy(config)) {
            return true;
        }
        ResourceKey parentResourceKey = resourceKey.getParentResourceKey();
        return this.configurationInfos.containsKey(parentResourceKey) && this.isResourceReadyForConfigurationAndScheduling(parentResourceKey);
    }

    public boolean isResourceExists(ResourceKey resourceKey) {
        if (resourceKey == null) {
            return false;
        }
        return this.configurationInfos.containsKey(resourceKey);
    }

    public Map<String, String> getFullResourceConfiguration(ResourceKey resourceKey) throws ResourceRepositoryException {
        return this.getResourceAndAncestorsConfigurationAndProperties(resourceKey, false);
    }

    public Map<String, String> getResourceAndAncestorsConfiguration(ResourceKey resourceKey) throws ResourceRepositoryException {
        return this.getResourceAndAncestorsConfigurationAndProperties(resourceKey, true);
    }

    private Map<String, String> getResourceAndAncestorsConfigurationAndProperties(ResourceKey resourceKey, boolean filterProperties) throws ResourceRepositoryException {
        List<ConfigurationInfo> resourceHierarchy = this.getResourceAncestors(resourceKey);
        if (CollectionUtils.isEmpty(resourceHierarchy)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (ConfigurationInfo configInfo : resourceHierarchy) {
            configMap.putAll(configInfo.getConfiguration());
            configMap.putAll(configInfo.getSecuredConfiguration());
            if (filterProperties) {
                configMap.putAll(this.getFilteredResourceProperties(configInfo));
                continue;
            }
            configMap.putAll(configInfo.getProperties());
        }
        return configMap;
    }

    public List<ConfigurationInfo> getResourceAncestors(ResourceKey resourceKey) throws ResourceRepositoryException {
        ArrayList<ConfigurationInfo> aggregated = new ArrayList<ConfigurationInfo>();
        aggregated.addAll(this.getResourceAncestorsHelper(resourceKey, 1));
        return aggregated;
    }

    private List<ConfigurationInfo> getResourceAncestorsHelper(ResourceKey resourceKey, int depth) throws ResourceRepositoryException {
        ConfigurationInfo current = this.configurationInfos.get(resourceKey);
        if (current == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfigurationInfo> aggregated = new ArrayList<ConfigurationInfo>();
        if (depth != 3 && !this.isTopOfHierarchy(current)) {
            aggregated.addAll(this.getResourceAncestorsHelper(current.getResourceKey().getParentResourceKey(), depth + 1));
        }
        aggregated.add(current);
        return aggregated;
    }

    private Map<String, String> getFilteredResourceProperties(ConfigurationInfo configuration) throws ResourceRepositoryException {
        int type = configuration.getTypeInfo().getType();
        switch (type) {
            case 1: {
                return this.filterPlatformProperties(configuration.getProperties());
            }
        }
        return Collections.emptyMap();
    }

    private Map<String, String> filterPlatformProperties(Map<String, String> properties) throws ResourceRepositoryException {
        String correctTypeKey = "platform.type";
        String correctNameKey = "platform.name";
        String originalTypeValue = "";
        String originalNameValue = "";
        Iterator<Map.Entry<String, String>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            log.debug((Object)String.format("Key: [%s], Value: [%s]", entry.getKey(), entry.getValue()));
            if (entry.getKey().equalsIgnoreCase("TYPE")) {
                log.debug((Object)"Agent will catch the faulty corrupted key and self-correct it");
                originalTypeValue = entry.getValue();
                iterator.remove();
                log.debug((Object)("Faulty key: " + entry.getKey() + " received from the server is removed"));
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("NAME")) continue;
            log.debug((Object)"Agent will catch the faulty corrupted key and self-correct it");
            originalNameValue = entry.getValue();
            iterator.remove();
            log.debug((Object)("Faulty key: " + entry.getKey() + " received from the server is removed"));
        }
        if (originalTypeValue != null && originalTypeValue != "") {
            properties.put(correctTypeKey, originalTypeValue);
            log.debug((Object)"Faulty platform.type key is corrected");
        }
        if (originalNameValue != null && originalNameValue != "") {
            properties.put(correctNameKey, originalNameValue);
            log.debug((Object)"Faulty platform.name key is corrected");
        }
        HashMap<String, String> filteredProperties = new HashMap<String, String>();
        for (ConfigurationInfoTranslator.PlatformKeyConfigPrefix propertyKey : ConfigurationInfoTranslator.PlatformKeyConfigPrefix.values()) {
            String propertyValue = properties.get(propertyKey.getPrefixedKey());
            if (propertyValue != null) {
                filteredProperties.put(propertyKey.getPrefixedKey(), propertyValue);
                continue;
            }
            if (ConfigurationInfoTranslator.PlatformKeyConfigPrefix.IP.equals((Object)propertyKey)) continue;
            log.error((Object)("The following property is missing for platform resource: " + propertyKey.getPrefixedKey()));
            throw new ResourceRepositoryException(ResourceRepositoryException.ResourceRepositoryError.MISSING_RESOURCE_PROPERTIES);
        }
        return filteredProperties;
    }

    public List<ConfigurationInfo> getResourceDescendents(ResourceKey resourceKey) {
        ArrayList<ConfigurationInfo> aggregated = new ArrayList<ConfigurationInfo>();
        aggregated.addAll(this.getResourceDescendentsHelper(resourceKey, 1));
        return aggregated;
    }

    private List<ConfigurationInfo> getResourceDescendentsHelper(ResourceKey resourceKey, int depth) {
        if (resourceKey == null) {
            return Collections.emptyList();
        }
        Collection descendentsKeys = this.resourceRelationships.getCollection((Object)resourceKey);
        if (CollectionUtils.isEmpty((Collection)descendentsKeys)) {
            return Collections.emptyList();
        }
        ArrayList<ConfigurationInfo> aggregated = new ArrayList<ConfigurationInfo>();
        for (ResourceKey key : descendentsKeys) {
            if (!this.configurationInfos.containsKey(key)) continue;
            aggregated.add(this.configurationInfos.get(key));
            if (depth > 3) continue;
            aggregated.addAll(this.getResourceDescendentsHelper(key, depth + 1));
        }
        return aggregated;
    }

    private boolean isTopOfHierarchy(ConfigurationInfo config) throws ResourceRepositoryException {
        TypeInfo typeInfo = config.getTypeInfo();
        if (typeInfo == null) {
            throw new ResourceRepositoryException(ResourceRepositoryException.ResourceRepositoryError.MISSING_RESOURCE_TYPE_INFO);
        }
        return 1 == typeInfo.getType();
    }

    public void removeResource(ResourceKey resourceKey) {
        if (resourceKey != null) {
            ResourceKey parentResoucrKey = resourceKey.getParentResourceKey();
            if (this.resourceRelationships.getCollection((Object)parentResoucrKey) != null) {
                this.resourceRelationships.getCollection((Object)parentResoucrKey).remove(resourceKey);
            }
            this.configurationInfos.remove(resourceKey);
        }
    }

    public ConfigurationInfo getConfigInfoByInternalId(int internalId) {
        for (Map.Entry<ResourceKey, ConfigurationInfo> entry : this.configurationInfos.entrySet()) {
            if (internalId != entry.getValue().getResourceInternalId()) continue;
            ResourceKey resourceKey = entry.getKey();
            ConfigurationInfo oldConfigInfo = this.configurationInfos.get(resourceKey);
            ConfigurationInfo configInfo = new ConfigurationInfo();
            configInfo.setResourceKey(resourceKey);
            configInfo.setResourceInternalId(internalId);
            configInfo.setTypeInfo(oldConfigInfo.getTypeInfo());
            configInfo.setVirtualServerConfiguration(oldConfigInfo.getVirtualServerConfiguration());
            configInfo.setResourceKind(oldConfigInfo.getResourceKind());
            return configInfo;
        }
        return null;
    }
}

