/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.appdef.shared.AIServiceTypeValue;
import org.hyperic.hq.product.MeasurementInfos;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.EncodingException;

public class ServiceType {
    private Set controlActions = new HashSet();
    private ConfigSchema customProperties = new ConfigSchema();
    private final ServiceTypeInfo info;
    private Log log = LogFactory.getLog((String)ServiceType.class.getName());
    private MeasurementInfos measurements = new MeasurementInfos();
    private ConfigResponse pluginClasses = new ConfigResponse();
    private final String productName;
    private ConfigResponse properties = new ConfigResponse();
    private final AIServiceTypeValue resource;
    private final String serviceName;

    public ServiceType(String serviceName, String productName, ServiceTypeInfo info) {
        this.info = info;
        this.productName = productName;
        this.serviceName = serviceName;
        this.resource = new AIServiceTypeValue();
        this.resource.setDescription(info.getDescription());
        this.resource.setName(info.getName());
        this.resource.setServiceName(serviceName);
        this.resource.setProductName(productName);
    }

    public void addControlAction(String controlAction) {
        this.controlActions.add(controlAction);
        this.resource.setControlActions(this.controlActions.toArray(new String[this.controlActions.size()]));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.getInfo().getName().equals(((ServiceType)obj).getInfo().getName());
    }

    public AIServiceTypeValue getAIServiceTypeValue() {
        return this.resource;
    }

    public Set getControlActions() {
        return this.controlActions;
    }

    public ConfigSchema getCustomProperties() {
        return this.customProperties;
    }

    public ServiceTypeInfo getInfo() {
        return this.info;
    }

    public MeasurementInfos getMeasurements() {
        return this.measurements;
    }

    public ConfigResponse getPluginClasses() {
        return this.pluginClasses;
    }

    public String getProductName() {
        return this.productName;
    }

    public ConfigResponse getProperties() {
        return this.properties;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int hashCode() {
        return this.getInfo().getName().hashCode();
    }

    public void setControlActions(Set controlActions) {
        this.controlActions = controlActions;
        this.resource.setControlActions(controlActions.toArray(new String[controlActions.size()]));
    }

    public void setCustomProperties(ConfigSchema customProperties) {
        this.customProperties = customProperties;
        try {
            this.resource.setCustomProperties(customProperties.encode());
        }
        catch (EncodingException e) {
            this.log.warn((Object)("Unable to set custom properties on internal resource object.  Cause: " + e.getMessage()));
        }
    }

    public void setMeasurements(MeasurementInfos measurements) {
        this.measurements = measurements;
        try {
            this.resource.setMeasurements(measurements.encode());
        }
        catch (EncodingException e) {
            this.log.warn((Object)("Unable to set measurements on internal resource object.  Cause: " + e.getMessage()));
        }
    }

    public void setPluginClasses(ConfigResponse pluginClasses) {
        this.pluginClasses = pluginClasses;
        try {
            this.resource.setPluginClasses(pluginClasses.encode());
        }
        catch (EncodingException e) {
            this.log.warn((Object)("Unable to set plugin classes on internal resource object.  Cause: " + e.getMessage()));
        }
    }

    public void setProperties(ConfigResponse properties) {
        this.properties = properties;
        try {
            this.resource.setProperties(properties.encode());
        }
        catch (EncodingException e) {
            this.log.warn((Object)("Unable to set properties on internal resource object.  Cause: " + e.getMessage()));
        }
    }

    public String toString() {
        StringBuilder serviceType = new StringBuilder("ServiceType[name=");
        serviceType.append(this.getInfo().getName());
        serviceType.append(']');
        return serviceType.toString();
    }
}

