/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.hq.bizapp.shared.lather.ControlSendCommandResult_args;
import org.hyperic.hq.product.ControlPluginManager;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public abstract class ControlPlugin
extends GenericPlugin {
    public static final String PROP_TIMEOUT = "timeout";
    protected static final int DEFAULT_TIMEOUT = 30;
    private int timeout = 30;
    private int result;
    private String message;
    public static final String STATE_UNKNOWN = "unknown";
    public static final String STATE_STARTING = "starting";
    public static final String STATE_STARTED = "started";
    public static final String STATE_STOPPING = "stopping";
    public static final String STATE_STOPPED = "stopped";
    public static final String STATE_RESTARTING = "restarting";
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE = -1;
    protected ControlPluginManager manager;

    public List<String> getActions() {
        ArrayList actions = null;
        if (this.data != null) {
            actions = this.data.getControlActions(this.getTypeInfo());
        }
        if (actions == null) {
            this.getLog().debug((Object)(this.getName() + " does not specify any control actions"));
            actions = new ArrayList();
        }
        return actions;
    }

    protected void setExceptionMessage(Throwable t) {
        String msg = t.getMessage();
        if (msg == null) {
            msg = t.toString();
        }
        if (this.getMessage() == null) {
            this.setMessage(msg);
        }
        this.getLog().debug((Object)msg, t);
        this.setResult(-1);
    }

    public void doAction(String action, ControlSendCommandResult_args resultsMetadata) throws PluginException {
        this.doAction(action);
    }

    public void doAction(String action) throws PluginException {
        this.doAction(action, new String[0]);
    }

    public void doAction(String action, String[] args, ControlSendCommandResult_args resultsMetadata) throws PluginException {
        this.doAction(action, args);
    }

    public void doAction(String action, String[] args) throws PluginException {
        Object[] objectArray;
        this.setResult(0);
        Method method = null;
        Object[] sigs = new Object[]{new Class[]{args.getClass()}, new Class[0]};
        Class<?> clz = this.getClass();
        for (int i = 0; i < sigs.length; ++i) {
            try {
                method = clz.getDeclaredMethod(action, (Class[])sigs[i]);
                break;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        if (method == null) {
            String msg = "Action '" + action + "' not supported";
            throw new PluginException(msg);
        }
        if (method.getParameterTypes().length == 0) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = args;
        }
        Object[] methodArgs = objectArray;
        try {
            method.invoke((Object)this, methodArgs);
        }
        catch (InvocationTargetException e) {
            this.setExceptionMessage(e.getTargetException());
        }
        catch (Exception e) {
            this.setExceptionMessage(e);
            throw new PluginException("Error invoking " + this.getName() + " action '" + action + "': " + e, e);
        }
    }

    protected boolean isRunning() {
        this.getLog().error((Object)(this.getName() + " does not implement isRunning"));
        return false;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTimeoutMillis() {
        return this.timeout * 1000;
    }

    public void setTimeout(int val) {
        this.timeout = val;
    }

    public void setTimeout(String val) {
        this.setTimeout(Integer.parseInt(val));
    }

    protected ControlPluginManager getManager() {
        return this.manager;
    }

    protected void setManager(ControlPluginManager manager) {
        this.manager = manager;
    }

    @Override
    public void init(PluginManager manager) throws PluginException {
        this.manager = (ControlPluginManager)manager;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected String detectState() {
        if (this.isRunning()) {
            return STATE_STARTED;
        }
        return STATE_STOPPED;
    }

    protected String waitForState(String wantedState) {
        int timeout = this.getTimeoutMillis();
        long timeStart = System.currentTimeMillis();
        String state = this.detectState();
        while (!state.equals(wantedState) && System.currentTimeMillis() - timeStart < (long)timeout) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            state = this.detectState();
        }
        return state;
    }

    @Override
    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema;
        if (this.data != null && (schema = this.data.getConfigSchema(info, 2)) != null) {
            return schema;
        }
        return super.getConfigSchema(info, config);
    }
}

