/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.hyperic.hq.autoinventory.ScanMethodState;
import org.hyperic.hq.autoinventory.ScanStateCore;
import org.hyperic.hq.bizapp.shared.lather.AiPlatformLatherValue;
import org.hyperic.hq.bizapp.shared.lather.ScanMethodStateLatherValue;
import org.hyperic.hq.bizapp.shared.lather.StringifiedExceptionLatherValue;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;

public class ScanStateCoreLatherValue
extends LatherValue {
    private static final String PROP_ARESERVERSINCLUDED = "areServersIncluded";
    private static final String PROP_CERTDN = "certDN";
    private static final String PROP_ENDTIME = "endTime";
    private static final String PROP_GLOBALEXCEPTION = "globalException";
    private static final String PROP_ISDONE = "isDone";
    private static final String PROP_ISINTERRUPTED = "isInterrupted";
    private static final String PROP_PLATFORM = "platform";
    private static final String PROP_SCANMETHODSTATES = "scanMethodStates";
    private static final String PROP_STARTTIME = "startTime";

    public ScanStateCoreLatherValue() {
    }

    public ScanStateCoreLatherValue(ScanStateCore v) {
        this.setIntValue(PROP_ARESERVERSINCLUDED, v.getAreServersIncluded() ? 1 : 0);
        if (v.getCertDN() != null) {
            this.setStringValue(PROP_CERTDN, v.getCertDN());
        }
        this.setDoubleValue(PROP_ENDTIME, v.getEndTime());
        if (v.getGlobalException() != null) {
            this.setObjectValue(PROP_GLOBALEXCEPTION, new StringifiedExceptionLatherValue(v.getGlobalException()));
        }
        this.setIntValue(PROP_ISDONE, v.getIsDone() ? 1 : 0);
        this.setIntValue(PROP_ISINTERRUPTED, v.getIsInterrupted() ? 1 : 0);
        if (v.getPlatform() != null) {
            this.setObjectValue(PROP_PLATFORM, new AiPlatformLatherValue(v.getPlatform()));
        }
        if (v.getScanMethodStates() != null) {
            ScanMethodState[] states = v.getScanMethodStates();
            for (int i = 0; i < states.length; ++i) {
                this.addObjectToList(PROP_SCANMETHODSTATES, (Object)new ScanMethodStateLatherValue(states[i]));
            }
        }
        this.setDoubleValue(PROP_STARTTIME, v.getStartTime());
    }

    public ScanStateCore getScanStateCore() {
        ScanStateCore r = new ScanStateCore();
        r.setAreServersIncluded(this.getIntValue(PROP_ARESERVERSINCLUDED) == 1);
        try {
            r.setCertDN(this.getStringValue(PROP_CERTDN));
        }
        catch (LatherKeyNotFoundException exc) {
            // empty catch block
        }
        r.setEndTime((long)this.getDoubleValue(PROP_ENDTIME));
        try {
            LatherValue gExc = this.getObjectValue(PROP_GLOBALEXCEPTION);
            r.setGlobalException(((StringifiedExceptionLatherValue)gExc).getException());
        }
        catch (LatherKeyNotFoundException exc) {
            // empty catch block
        }
        r.setIsDone(this.getIntValue(PROP_ISDONE) == 1);
        r.setIsInterrupted(this.getIntValue(PROP_ISINTERRUPTED) == 1);
        try {
            LatherValue plat = this.getObjectValue(PROP_PLATFORM);
            r.setPlatform(((AiPlatformLatherValue)plat).getAIPlatformValue());
        }
        catch (LatherKeyNotFoundException exc) {
            // empty catch block
        }
        try {
            LatherValue[] lstates = (LatherValue[])this.getObjectList(PROP_SCANMETHODSTATES);
            ScanMethodState[] states = new ScanMethodState[lstates.length];
            for (int i = 0; i < lstates.length; ++i) {
                ScanMethodStateLatherValue lState = (ScanMethodStateLatherValue)lstates[i];
                states[i] = lState.getScanMethodState();
            }
            r.setScanMethodStates(states);
        }
        catch (LatherKeyNotFoundException exc) {
            r.setScanMethodStates(new ScanMethodState[0]);
        }
        r.setStartTime((long)this.getDoubleValue(PROP_STARTTIME));
        return r;
    }

    public void validate() throws LatherRemoteException {
    }
}

