/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.hyperic.tools.db.ConstraintImpl;
import org.hyperic.tools.db.ConstraintImpl_FK;
import org.hyperic.tools.db.ConstraintImpl_PK;
import org.hyperic.tools.db.DBSetup;
import org.hyperic.tools.db.Table;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class Constraint {
    private Table m_table;
    private ConstraintImpl m_constraint;
    private DBSetup m_parent;

    protected Constraint(Node node, Table table, int dbtype) throws SAXException {
        this.m_parent = table.getDBSetup();
        if (!Constraint.isConstraint(node)) {
            throw new SAXException("node is not an CONSTRAINT.");
        }
        String cname = null;
        NamedNodeMap map = node.getAttributes();
        for (int iAttr = 0; iAttr < map.getLength(); ++iAttr) {
            Node nodeMap = map.item(iAttr);
            String strName = nodeMap.getNodeName();
            String strValue = nodeMap.getNodeValue();
            if (!strName.equalsIgnoreCase("name")) continue;
            cname = strValue;
        }
        NodeList listFields = node.getChildNodes();
        int numFields = listFields.getLength();
        for (int iField = 0; iField < numFields; ++iField) {
            node = listFields.item(iField);
            if (node.getNodeName().equalsIgnoreCase("primarykey")) {
                this.m_constraint = new ConstraintImpl_PK(cname, dbtype, node);
                continue;
            }
            if (!node.getNodeName().equalsIgnoreCase("foreignkey")) continue;
            this.m_constraint = new ConstraintImpl_FK(cname, this, dbtype, node);
        }
        this.m_table = table;
    }

    protected String getCreateString() {
        return this.m_constraint.getCreateString();
    }

    protected Table getTable() {
        return this.m_table;
    }

    protected void getPostCreateCommands(List postCreateCommands) {
        this.m_constraint.getPostCreateCommands(postCreateCommands);
    }

    protected static Collection getConstraints(Table table, Node nodeTable, int dbtype) {
        String strTableName = nodeTable.getNodeName();
        NodeList listIdx = nodeTable.getChildNodes();
        Vector<Constraint> colResult = new Vector<Constraint>();
        for (int i = 0; i < listIdx.getLength(); ++i) {
            Node node = listIdx.item(i);
            if (!Constraint.isConstraint(node)) continue;
            try {
                colResult.add(new Constraint(node, table, dbtype));
                continue;
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        return colResult;
    }

    protected static boolean isConstraint(Node node) {
        return node.getNodeName().equalsIgnoreCase("constraint");
    }
}

