/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.config.InvalidOptionException;
import org.hyperic.util.config.InvalidOptionValueException;

public class ConfigSchema
implements Serializable {
    private static final long serialVersionUID = 8171794117881852319L;
    private static final Object configLock = new Object();
    private static HashMap<String, Boolean> secrets = new HashMap();
    private static HashMap<String, Boolean> sensitive = new HashMap();
    private ArrayList<ConfigOption> configOptions = new ArrayList();

    public ConfigSchema() {
    }

    public ConfigSchema(ConfigOption[] options) {
        this();
        this.configOptions.addAll(Arrays.asList(options));
    }

    public List<ConfigOption> getOptions() {
        return Collections.unmodifiableList(new ArrayList<ConfigOption>(this.configOptions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOption(ConfigOption option) {
        Object object = configLock;
        synchronized (object) {
            this.configOptions.remove(option);
            this.configOptions.add(option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOptionAsFirst(ConfigOption option) {
        Object object = configLock;
        synchronized (object) {
            this.configOptions.remove(option);
            this.configOptions.add(0, option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOptions(List<ConfigOption> options) {
        Object object = configLock;
        synchronized (object) {
            this.configOptions.removeAll(options);
            this.configOptions.addAll(options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ConfigOption> getOptionsMap() {
        Object object = configLock;
        synchronized (object) {
            HashMap<String, ConfigOption> opts = new HashMap<String, ConfigOption>();
            Iterator<ConfigOption> i$ = this.configOptions.iterator();
            while (i$.hasNext()) {
                ConfigOption configOption;
                ConfigOption option = configOption = i$.next();
                opts.put(option.getName(), option);
            }
            return opts;
        }
    }

    public ConfigOption getOption(String name) {
        return this.getOptionsMap().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getOptionNames() {
        Object object = configLock;
        synchronized (object) {
            int size = this.configOptions.size();
            String[] names = new String[size];
            for (int i = 0; i < size; ++i) {
                ConfigOption option = this.configOptions.get(i);
                names[i] = option.getName();
            }
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDefaultProperties() {
        Object object = configLock;
        synchronized (object) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (ConfigOption configOption : this.configOptions) {
                ConfigOption opt = configOption;
                String defVal = opt.getDefault();
                if (defVal == null) continue;
                props.put(opt.getName(), defVal);
            }
            return props;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode() throws EncodingException {
        ObjectOutputStream objectStream = null;
        byte[] retVal = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            objectStream = new ObjectOutputStream(byteStream);
            Object object = configLock;
            synchronized (object) {
                for (ConfigOption configOption : this.configOptions) {
                    objectStream.writeObject(configOption);
                }
            }
            objectStream.writeObject(null);
            objectStream.flush();
            retVal = byteStream.toByteArray();
        }
        catch (IOException exc) {
            throw new EncodingException(exc.toString());
        }
        finally {
            if (objectStream != null) {
                try {
                    objectStream.close();
                }
                catch (Exception ex) {}
            }
        }
        return retVal;
    }

    public static ConfigSchema decode(byte[] data) throws EncodingException, InvalidOptionException, InvalidOptionValueException {
        try {
            ConfigOption configOption;
            ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            ConfigSchema schema = new ConfigSchema();
            while ((configOption = (ConfigOption)objectStream.readObject()) != null) {
                schema.addOption(configOption);
            }
            return schema;
        }
        catch (IOException exc) {
            throw new EncodingException(exc.toString());
        }
        catch (ClassNotFoundException exc) {
            throw new EncodingException(exc.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefault(String prop, String value) {
        Object object = configLock;
        synchronized (object) {
            for (int i = 0; i < this.configOptions.size(); ++i) {
                ConfigOption opt = this.configOptions.get(i);
                if (!opt.getName().equals(prop)) continue;
                opt.setDefault(value);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSecret(String key) {
        HashMap<String, Boolean> hashMap = secrets;
        synchronized (hashMap) {
            Boolean obj = secrets.get(key);
            return obj != null && ((Object)obj).equals(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSecret(String key) {
        HashMap<String, Boolean> hashMap = secrets;
        synchronized (hashMap) {
            secrets.put(key, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSensitive(String key) {
        HashMap<String, Boolean> hashMap = sensitive;
        synchronized (hashMap) {
            Boolean obj = sensitive.get(key);
            return obj != null && ((Object)obj).equals(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSensitive(String key) {
        HashMap<String, Boolean> hashMap = sensitive;
        synchronized (hashMap) {
            sensitive.put(key, Boolean.TRUE);
        }
    }
}

