/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.util.StringTokenizer;
import org.hyperic.util.StringUtil;

public class TextIndenter {
    public static final int DEFAULT_INDENT = 4;
    private StringBuffer buf;
    private int indentAmount;
    private int curIndent;
    private boolean lastWasNewline;

    public TextIndenter(int indentAmount) {
        this.init(indentAmount);
    }

    public TextIndenter() {
        this.init(4);
    }

    private void init(int indentAmount) {
        this.buf = new StringBuffer();
        this.indentAmount = indentAmount;
        this.curIndent = 0;
        this.lastWasNewline = false;
    }

    public void append(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, "\n", true);
        while (tokenizer.hasMoreTokens()) {
            String val = tokenizer.nextToken();
            if (this.lastWasNewline) {
                this.buf.append(StringUtil.repeatChars(' ', this.curIndent));
            }
            this.buf.append(val);
            if (val.equals("\n")) {
                this.lastWasNewline = true;
                continue;
            }
            this.lastWasNewline = false;
        }
    }

    public void pushIndent(int amount) {
        this.curIndent += amount;
    }

    public void pushIndent() {
        this.pushIndent(this.indentAmount);
    }

    public void popIndent(int amount) {
        if (this.curIndent - amount < 0) {
            throw new IllegalStateException("Underflow in indentation poppage!");
        }
        this.curIndent -= amount;
    }

    public void popIndent() {
        this.popIndent(this.indentAmount);
    }

    public String toString() {
        return this.buf.toString();
    }

    public static void main(String[] args) {
        TextIndenter t = new TextIndenter(3);
        t.append("Header\n");
        t.pushIndent();
        t.append("Test 1\n");
        t.pushIndent();
        t.pushIndent();
        t.append("Super 1\n\nSuper 2\n");
        t.popIndent();
        t.popIndent();
        t.popIndent();
        t.append("Header 2\n");
        t.pushIndent();
        t.append("Test 2\n");
        t.pushIndent();
        t.append("Sub 1\n");
        System.out.println(t.toString());
    }
}

