/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class NetInterfaceConfig
implements Serializable {
    private static final long serialVersionUID = 20384L;
    String name = null;
    String hwaddr = null;
    String type = null;
    String description = null;
    String address = null;
    String address6 = null;
    int prefix6Length = 0;
    int scope6 = 0;
    String destination = null;
    String broadcast = null;
    String netmask = null;
    long flags = 0L;
    long mtu = 0L;
    long metric = 0L;

    public native void gather(Sigar var1, String var2) throws SigarException;

    static NetInterfaceConfig fetch(Sigar sigar, String name) throws SigarException {
        NetInterfaceConfig netInterfaceConfig = new NetInterfaceConfig();
        netInterfaceConfig.gather(sigar, name);
        return netInterfaceConfig;
    }

    public String getName() {
        return this.name;
    }

    public String getHwaddr() {
        return this.hwaddr;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddress6() {
        return this.address6;
    }

    public int getPrefix6Length() {
        return this.prefix6Length;
    }

    public int getScope6() {
        return this.scope6;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getBroadcast() {
        return this.broadcast;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getMtu() {
        return this.mtu;
    }

    public long getMetric() {
        return this.metric;
    }

    void copyTo(NetInterfaceConfig copy) {
        copy.name = this.name;
        copy.hwaddr = this.hwaddr;
        copy.type = this.type;
        copy.description = this.description;
        copy.address = this.address;
        copy.address6 = this.address6;
        copy.prefix6Length = this.prefix6Length;
        copy.scope6 = this.scope6;
        copy.destination = this.destination;
        copy.broadcast = this.broadcast;
        copy.netmask = this.netmask;
        copy.flags = this.flags;
        copy.mtu = this.mtu;
        copy.metric = this.metric;
    }

    public Map toMap() {
        String strmetric;
        String strmtu;
        String strflags;
        String strnetmask;
        String strbroadcast;
        String strdestination;
        String strscope6;
        String strprefix6Length;
        String straddress6;
        String straddress;
        String strdescription;
        String strtype;
        String strhwaddr;
        HashMap<String, String> map = new HashMap<String, String>();
        String strname = String.valueOf(this.name);
        if (!"-1".equals(strname)) {
            map.put("Name", strname);
        }
        if (!"-1".equals(strhwaddr = String.valueOf(this.hwaddr))) {
            map.put("Hwaddr", strhwaddr);
        }
        if (!"-1".equals(strtype = String.valueOf(this.type))) {
            map.put("Type", strtype);
        }
        if (!"-1".equals(strdescription = String.valueOf(this.description))) {
            map.put("Description", strdescription);
        }
        if (!"-1".equals(straddress = String.valueOf(this.address))) {
            map.put("Address", straddress);
        }
        if (!"-1".equals(straddress6 = String.valueOf(this.address6))) {
            map.put("Address6", straddress6);
        }
        if (!"-1".equals(strprefix6Length = String.valueOf(this.prefix6Length))) {
            map.put("Prefix6Length", strprefix6Length);
        }
        if (!"-1".equals(strscope6 = String.valueOf(this.scope6))) {
            map.put("Scope6", strscope6);
        }
        if (!"-1".equals(strdestination = String.valueOf(this.destination))) {
            map.put("Destination", strdestination);
        }
        if (!"-1".equals(strbroadcast = String.valueOf(this.broadcast))) {
            map.put("Broadcast", strbroadcast);
        }
        if (!"-1".equals(strnetmask = String.valueOf(this.netmask))) {
            map.put("Netmask", strnetmask);
        }
        if (!"-1".equals(strflags = String.valueOf(this.flags))) {
            map.put("Flags", strflags);
        }
        if (!"-1".equals(strmtu = String.valueOf(this.mtu))) {
            map.put("Mtu", strmtu);
        }
        if (!"-1".equals(strmetric = String.valueOf(this.metric))) {
            map.put("Metric", strmetric);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

