/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hibernate.usertypes;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.hyperic.util.security.SecurityUtil;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.hibernate.type.AbstractEncryptedAsStringType;

public class EncryptedStringType
implements UserType,
ParameterizedType {
    private static final Log log = LogFactory.getLog(EncryptedStringType.class);
    private static final int nullableSqlType = Hibernate.STRING.sqlType();
    protected PBEStringEncryptor encryptor;
    private DelegateAbstractEncryptedAsStringType delegate = new DelegateAbstractEncryptedAsStringType();

    public final void setParameterValues(Properties parameters) {
        this.delegate.setParameterValues(parameters);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return this.delegate.deepCopy(value);
    }

    public final Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.delegate.assemble(cached, owner);
    }

    public int hashCode(Object x) throws HibernateException {
        return this.delegate.hashCode(x);
    }

    public final Serializable disassemble(Object value) throws HibernateException {
        return this.delegate.disassemble(value);
    }

    protected final Object convertToObject(String value) {
        return new LazyDecryptableValue(this.encryptor, value);
    }

    protected final String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof LazyDecryptableValue) {
            return object == null ? null : ((LazyDecryptableValue)object).get();
        }
        return object.toString();
    }

    public Class<LazyDecryptableValue> returnedClass() {
        return LazyDecryptableValue.class;
    }

    public final Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        this.delegate.lazyInit();
        String value = rs.getString(names[0]);
        return rs.wasNull() ? null : this.convertToObject(value);
    }

    public final int[] sqlTypes() {
        return this.delegate.sqlTypes();
    }

    public final boolean equals(Object x, Object y) throws HibernateException {
        return this.delegate.equals(x, y);
    }

    public final boolean isMutable() {
        return this.delegate.isMutable();
    }

    public final void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        this.delegate.lazyInit();
        if (value == null) {
            st.setNull(index, nullableSqlType);
        } else {
            String strValue = this.convertToString(value);
            if (!SecurityUtil.isMarkedEncrypted((String)strValue)) {
                String originalValue = strValue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[nullSafeSet] value before encryption=" + originalValue));
                }
                strValue = this.encryptor.encrypt(strValue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[nullSafeSet] value after encryption=" + strValue));
                }
                try {
                    String decryptedValue = this.encryptor.decrypt(strValue);
                    if (!originalValue.equals(decryptedValue)) {
                        StringBuilder logMessageBuilder = new StringBuilder("original value={");
                        logMessageBuilder.append(originalValue).append("} differs from the decrypted value={").append(decryptedValue).append("}");
                        log.error((Object)logMessageBuilder.toString());
                    }
                }
                catch (EncryptionOperationNotPossibleException e) {
                    log.warn((Object)("[nullSafeSet] could not decrypt value=" + value));
                    throw e;
                }
            }
            st.setString(index, strValue);
        }
    }

    public final Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public static final class LazyDecryptableValue
    implements Serializable {
        private static final long serialVersionUID = -8158319101596665352L;
        private String value;
        private boolean isDecrypted;
        private PBEStringEncryptor encryptor;

        public LazyDecryptableValue(String clearTextValue) {
            this.value = clearTextValue;
            this.isDecrypted = true;
        }

        public LazyDecryptableValue(PBEStringEncryptor encryptor, String encryptedValue) {
            this.encryptor = encryptor;
            this.value = encryptedValue;
        }

        public final String get() {
            boolean debug = log.isDebugEnabled();
            try {
                if (!this.isDecrypted) {
                    this.isDecrypted = true;
                    if (SecurityUtil.isMarkedEncrypted((String)this.value)) {
                        if (debug) {
                            log.debug((Object)("[get] value before decryption=" + this.value));
                        }
                        this.value = this.encryptor.decrypt(this.value);
                        if (debug) {
                            log.debug((Object)("[get] value after decryption=" + this.value));
                        }
                    } else if (debug) {
                        log.debug((Object)("LazyDecryptableValue is supposed to be encrypted, but is not marked encrypted=" + this.value));
                    }
                }
                return this.value;
            }
            catch (EncryptionOperationNotPossibleException e) {
                log.warn((Object)("[get] could not decrypt value=" + this.value));
                throw e;
            }
        }

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isDecrypted ? 1231 : 1237);
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LazyDecryptableValue other = (LazyDecryptableValue)obj;
            if (this.isDecrypted != other.isDecrypted) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public static final LazyDecryptableValue set(LazyDecryptableValue original, String clearTextValue) {
            boolean isEqual = true;
            if (original == null) {
                isEqual = false;
            } else if (original.value == null) {
                if (clearTextValue != null) {
                    isEqual = false;
                }
            } else if (!original.value.equals(clearTextValue)) {
                isEqual = false;
            }
            return isEqual ? original : new LazyDecryptableValue(clearTextValue);
        }
    }

    private final class DelegateAbstractEncryptedAsStringType
    extends AbstractEncryptedAsStringType {
        private DelegateAbstractEncryptedAsStringType() {
        }

        protected final Object convertToObject(String string) {
            return null;
        }

        public final Class returnedClass() {
            return null;
        }

        public final void lazyInit() {
            if (EncryptedStringType.this.encryptor == null) {
                this.checkInitialization();
                EncryptedStringType.this.encryptor = this.encryptor;
            }
        }
    }
}

