/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.support.ant;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.roo.support.ant.AntPatchStringMatcher;
import org.springframework.roo.support.ant.PathMatcher;
import org.springframework.roo.support.util.Assert;
import org.springframework.roo.support.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPathMatcher
implements PathMatcher {
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private String pathSeparator = "/";

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator != null ? pathSeparator : DEFAULT_PATH_SEPARATOR;
    }

    @Override
    public boolean isPattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    @Override
    public boolean match(String pattern, String path) {
        return this.doMatch(pattern, path, true, null);
    }

    @Override
    public boolean matchStart(String pattern, String path) {
        return this.doMatch(pattern, path, false, null);
    }

    protected boolean doMatch(String pattern, String path, boolean fullMatch, Map<String, String> uriTemplateVariables) {
        String patDir;
        int pathIdxStart;
        if (path.startsWith(this.pathSeparator) != pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] pattDirs = StringUtils.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] pathDirs = StringUtils.tokenizeToStringArray(path, this.pathSeparator);
        int pattIdxStart = 0;
        int pattIdxEnd = pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(patDir = pattDirs[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (this.matchStrings(patDir, pathDirs[pathIdxStart], uriTemplateVariables)) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith(this.pathSeparator) ? path.endsWith(this.pathSeparator) : !path.endsWith(this.pathSeparator);
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && path.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(pattDirs[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(patDir = pattDirs[pattIdxEnd]).equals("**")) {
            if (!this.matchStrings(patDir, pathDirs[pathIdxEnd], uriTemplateVariables)) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattDirs[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattDirs[pattIdxStart + j + 1];
                    String subStr = pathDirs[pathIdxStart + i + j];
                    if (!this.matchStrings(subPat, subStr, uriTemplateVariables)) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattDirs[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    private boolean matchStrings(String pattern, String str, Map<String, String> uriTemplateVariables) {
        AntPatchStringMatcher matcher = new AntPatchStringMatcher(pattern, str, uriTemplateVariables);
        return matcher.matchStrings();
    }

    @Override
    public String extractPathWithinPattern(String pattern, String path) {
        int i;
        String[] patternParts = StringUtils.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] pathParts = StringUtils.tokenizeToStringArray(path, this.pathSeparator);
        StringBuilder builder = new StringBuilder();
        int puts = 0;
        for (i = 0; i < patternParts.length; ++i) {
            String patternPart = patternParts[i];
            if (patternPart.indexOf(42) <= -1 && patternPart.indexOf(63) <= -1 || pathParts.length < i + 1) continue;
            if (puts > 0 || i == 0 && !pattern.startsWith(this.pathSeparator)) {
                builder.append(this.pathSeparator);
            }
            builder.append(pathParts[i]);
            ++puts;
        }
        for (i = patternParts.length; i < pathParts.length; ++i) {
            if (puts > 0 || i > 0) {
                builder.append(this.pathSeparator);
            }
            builder.append(pathParts[i]);
        }
        return builder.toString();
    }

    @Override
    public Map<String, String> extractUriTemplateVariables(String pattern, String path) {
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        boolean result = this.doMatch(pattern, path, true, variables);
        Assert.state(result, "Pattern \"" + pattern + "\" is not a match for \"" + path + "\"");
        return variables;
    }
}

