/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Collector;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.util.StringUtil;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;

public class ExecutableProcess
extends Collector {
    public static final String DOMAIN = "exec";
    private static final String AGENT_BUNDLE_HOME = "agent.bundle.home";
    public static final String PROP_EXEC = "exec";
    public static final String PROP_FILE = "file";
    public static final String PROP_ARGS = "args";
    private static Log log = LogFactory.getLog((String)ExecutableProcess.class.getName());
    private String[] argv;
    private File file;
    private File cwd;
    private ByteArrayOutputStream output = new ByteArrayOutputStream();

    @Override
    protected int getDefaultTimeout() {
        return 120;
    }

    protected int getLogLevel(int rc) {
        switch (rc) {
            case 0: {
                return 6;
            }
            case 1: {
                return 4;
            }
        }
        return 3;
    }

    protected double getAvailValue(int rc) {
        switch (rc) {
            case 0: {
                return 100.0;
            }
            case 1: {
                return 0.5;
            }
            case 2: {
                return 0.0;
            }
            case 3: {
                return 2.0;
            }
            case 4: {
                return -0.01;
            }
        }
        return 2.0;
    }

    private void addArgv(String value, ArrayList argv) {
        if (value != null && value.length() != 0) {
            String[] add = StringUtil.explodeQuoted((String)value);
            for (int i = 0; i < add.length; ++i) {
                argv.add(add[i]);
            }
        }
    }

    protected String getExecProperty() {
        return this.getCollectorProperty("exec");
    }

    protected String getFileProperty() {
        return this.getCollectorProperty(PROP_FILE);
    }

    protected String getArgsProperty() {
        return this.getCollectorProperty(PROP_ARGS);
    }

    private String resolveRelativeFile(String file) {
        if (file != null && file.startsWith("pdk/")) {
            String bundleHome = System.getProperty(AGENT_BUNDLE_HOME);
            return bundleHome + "/" + file;
        }
        return file;
    }

    @Override
    protected void init() {
        String msg;
        String exe;
        String exec = this.getExecProperty();
        String name = this.resolveRelativeFile(this.getFileProperty());
        ArrayList<String> argv = new ArrayList<String>();
        if (OperatingSystem.IS_WIN32 && exec == null && (exe = Win32.findScriptExecutable((String)name)) != null) {
            argv.add(exe);
            if (exe.endsWith("cscript.exe")) {
                argv.add("//nologo");
            }
        }
        this.addArgv(exec, argv);
        argv.add(name);
        this.addArgv(this.getArgsProperty(), argv);
        this.argv = new String[argv.size()];
        argv.toArray(this.argv);
        this.setSource(name);
        if (name == null) {
            msg = "No file in properties: " + this.getProperties();
            throw new IllegalArgumentException(msg);
        }
        this.file = new File(name);
        if (!this.file.exists()) {
            msg = "File '" + this.file + "' does not exist";
            throw new IllegalArgumentException(msg);
        }
        this.cwd = this.file.isAbsolute() ? this.file.getParentFile() : new File(".");
    }

    @Override
    public boolean isPoolable() {
        return true;
    }

    @Override
    public void collect() {
        int res;
        this.output.reset();
        ExecuteWatchdog wdog = new ExecuteWatchdog(this.getTimeoutMillis());
        Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)this.output), wdog);
        exec.setCommandline(this.argv);
        exec.setWorkingDirectory(this.cwd);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" running: " + this));
        }
        try {
            this.startTime();
            res = exec.execute();
            this.endTime();
            String outputMessage = this.output.toString();
            if (outputMessage == null || outputMessage.length() == 0) {
                outputMessage = "No message, exit value=" + res;
            }
            this.setMessage(outputMessage);
            this.parseResults(this.getMessage());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error((Object)(this + ": " + e.getMessage()), (Throwable)e);
            }
            this.setMessage(e.toString());
            if (!this.file.exists()) {
                this.setMessage("File '" + this.file + "' does not exist");
            }
            res = 2;
        }
        if (wdog.killedProcess()) {
            this.setMessage("Timeout running [" + exec.getCommandLineString() + "]");
            res = 2;
        }
        this.setLogLevel(this.getLogLevel(res));
        double avail = this.getAvailValue(res);
        String msg = this + ": " + this.getMessage();
        switch (this.getLogLevel()) {
            case 3: {
                log.error((Object)msg);
                break;
            }
            case 4: {
                log.warn((Object)msg);
                break;
            }
            default: {
                log.debug((Object)msg);
            }
        }
        this.setAvailability(avail);
        this.setResponseCode(res);
    }

    @Override
    public String toString() {
        return Arrays.asList(this.argv).toString();
    }
}

