#!/usr/bin/env python
# Copyright (c) 2015
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
#     The above copyright notice and this permission notice shall be
#     included in all copies or substantial portions of the Software.
#
#     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#     EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
#     OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
#     NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
#     HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
#     WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#     FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
#     OTHER DEALINGS IN THE SOFTWARE.
# Version 6.0.0

import os
import sys
import platform
import subprocess
import shutil
import getopt
import getpass

if not os.environ.has_key('VMWARE_JAVA_HOME'):
   if os.environ.has_key('JAVA_HOME'):
      os.environ['VMWARE_JAVA_HOME'] = os.environ['JAVA_HOME']
   else:
      print """
      ERROR: VMWARE_JAVA_HOME or JAVA_HOME not set in environment.
      Please set to location of Java runtime and retry.
      """
      sys.exit(1)
_LS_HOMEDIR = ""
if platform.system() == 'Windows':
    _LS_HOMEDIR = os.environ['VMWARE_CIS_HOME'] + "\\VMware Identity Services\\lstool\\lib\\"
else :
    _LS_HOMEDIR = "/usr/lib/vmidentity/tools/lib"

CLASSPATH = os.path.join(_LS_HOMEDIR, "lookup-client.jar") + os.pathsep + os.path.join(_LS_HOMEDIR, "*") + os.pathsep + _LS_HOMEDIR


EXT = ""
if platform.system() == 'Windows':
   EXT = ".exe"

JAVA = "%s/bin/java%s" % (os.environ['VMWARE_JAVA_HOME'], EXT)

JAVA_SECURITY_PROPERTIES = os.path.join(os.environ['VMWARE_CFG_DIR'],
                                        "java",
                                        "vmware-override-java.security")

_LB_ADDRESS = ''
_SSO_URL = ''
_USER = ''
_PASSWD = ''
_LB_FLDR =''
ssl_trust = ""
domain = ""
def lstooljava(main, arugments):
   """
   Lookup service client tool
   """
   cmd = [JAVA,
          "-Djava.security.properties=%s" % JAVA_SECURITY_PROPERTIES,
          "-cp",
          CLASSPATH,
          "-Dlog4j.configuration=tool-log4j.properties"]
   cmd.append(main)
   cmd += arugments
   cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
   return cmd_out.communicate() [0]

def get_domain() :
    global domain
    domain = _USER.split("@")[1];
def readPassword() :
    global _PASSWD
    _PASSWD = getpass.getpass();


def get_lb_cert():
    global ssl_trust
    with open (os.path.join(_LB_FLDR,"lb.crt"),'r') as fd:
        for lines in fd :
            if lines.find("CERTIFICATE") == -1:
                ssl_trust += lines.strip('\r\n')

def get_ownerId_nodeId(lines):
    global domain;
    global ssl_trust;
    owner_id = []
    node_id = []
    default_file_name = "update_sso_endpoint"
    update_required = False
    orig_fqdn = ""
    ssl_trust_found = False
    for line in lines :
        if line.find("Owner ID:") != -1 :
            strs = line.split(":");
            owner_id.append(strs[1].replace(" ",""))
        elif line.find("Service ID:") != -1:
            strs = line.split(":")
            node_id.append(strs[1].replace(" ",""))
        elif line.find("URL: ") != -1:
            strs = line.split(": ")
            orig_fqdn = strs[1].replace(" ","")
            strs = orig_fqdn.split("/")
            orig_fqdn = strs[2]
            if orig_fqdn != _LB_ADDRESS :
                update_required = True;

    idx = 0
    if update_required == True:
        while len(owner_id) > idx :
            fd = open("update_sso_endpoint.txt","r")
            filename = default_file_name + str(idx)
            file_descriptor = open(filename,"w")
            for fileline in fd :
                if fileline.find("<insert-here>") != -1 :
                    if fileline.find("ownerId =") != -1 :
                        fileline  = fileline.replace("<insert-here>",owner_id[idx])
                    elif fileline.find("nodeId = ") != -1 :
                        fileline = fileline.replace("<insert-here>",node_id[idx])
                    elif fileline.find(".url =") != -1 :
                        fileline = fileline.replace("<insert-here>",_LB_ADDRESS)
                        fileline = fileline.replace("<domain>",domain)
                    elif fileline.find(".ssltrust") != -1 :
                        fileline = fileline.replace("<insert-here>",ssl_trust)
                file_descriptor.write(fileline)

            fd.close()
            file_descriptor.close()
            del args[:]
            args.append("reregister")
            args.append("--spec")
            args.append(filename)
            args.append("--url")
            args.append("https://"+_SSO_URL+"/lookupservice/sdk")
            args.append("--user")
            args.append(_USER)
            args.append("--password")
            args.append(_PASSWD)
            args.append("--id")
            args.append(node_id[idx])
            output = lstooljava("com.vmware.vim.lookup.client.tool.LsTool",args[0:])
            idx +=1;

def update_license_endpoint(lines) :
    global ssl_trust
    owner_id = []
    node_id = []
    service_id = []
    #ssl_trust = ''
    http_attr = [{}]
    rest_attr = [{}]
    vmomi_attr = [{}]
    endpoint_attr = [{}]
    orig_fqdn = ''
    update_required = False;
    default_file_name = "update_license_endpoint"
    for line in lines :
        if line.find("Owner ID:") != -1 :
            strs = line.split(":");
            owner_id.append(strs[1].replace(" ",""))
        elif line.find("Service ID:") != -1:
            strs = line.split(":")
            node_id.append(strs[1].replace(" ",""))
        elif line.find("Node ID:") != -1:
            strs = line.split(":")
            service_id.append(strs[1].replace(" ",""))
        elif line.find("URL: ") != -1:
            strs = line.split(": ")
            orig_fqdn = strs[1].replace(" ","")
            strs = orig_fqdn.split("/")
            orig_fqdn = strs[2]
            if orig_fqdn != _LB_ADDRESS :
                update_required = True;
        #elif ssl_trust == '' and line.find("SSL trust") != -1:
        #    strs = line.split(":")
        #    ssl_trust = strs[1].rstrip('\r\n');
    i = 0 ;
    protocol = ''
    if update_required == True :
        while len(lines) > i :
            if lines[i].find("Protocol:") != -1 :
                strs = lines[i].split(": ")
                protocol = strs[1].replace(" ","")
            elif protocol != '' and lines[i].find('Endpoint Attributes:') != -1:
                if protocol.find('http') != -1:
                    temp_values = {}
                    temp_str = ''
                    j = 0
                    while j < 2:
                        i += 1
                        str = lines[i].split(": ")
                        temp_str = str[0].replace("\t","")
                        temp_str = temp_str.replace(" ","")
                        temp_values[temp_str] = str[1].replace(" ","")
                        j += 1
                    http_attr.append(temp_values)
                elif protocol.find('rest') != -1:
                    temp_values = {}
                    i += 1
                    str = lines[i].split(": ")
                    temp_values[str[0].replace("\t","")] = str[1].replace(" ","")
                    rest_attr.append(temp_values)
                elif protocol.find('vmomi') != -1:
                    temp_values = {}
                    i += 1
                    str = lines[i].split(": ")
                    temp_values[str[0].replace("\t","")] = str[1].replace(" ","")
                    vmomi_attr.append(temp_values)

            elif lines[i].find("\tAttributes:") != -1 :
                j = 0
                temp_values = {}
                while j < 3:
                    i += 1
                    str = lines[i].split(": ")
                    temp_values[str[0].replace("\t","")] = str[1].replace(" ","")
                    j += 1
                endpoint_attr.append(temp_values)
            i += 1
        idx = 0
        while len(owner_id) > idx :
            fd = open("update_license_endpoint.txt","r")
            file = fd.read()
            fileline = file.splitlines();
            filename = default_file_name + `idx`
            file_descriptor = open(filename,"w")
            i = 0;
            protocol = ''
            while len(fileline) > i :
                if fileline[i].find("<insert-here>") != -1 :
                    if fileline[i].find("ownerId =") != -1 :
                        fileline[i]  = fileline[i].replace("<insert-here>",owner_id[idx])
                    elif fileline[i].find("nodeId = ") != -1 :
                        fileline[i] = fileline[i].replace("<insert-here>",node_id[idx])
                    elif fileline[i].find(".url =") != -1 :
                        fileline[i] = fileline[i].replace("<insert-here>",_LB_ADDRESS)
                    elif fileline[i].find(".ssltrust") != -1 :
                        fileline[i] = fileline[i].replace("<insert-here>",ssl_trust)
                elif fileline[i].find("protocol") != -1 :
                    strs = fileline[i].split("=")
                    protocol = strs[1].replace(" ","")
                elif protocol != '' and fileline[i].find("cis.common.ep.localurl") != -1:
                    if protocol.find("http") != -1 :
                        file_descriptor.write(fileline[i] + "\n")
                        i += 1
                        fileline[i] = fileline[i].replace("<insert-here>",http_attr[idx+1]["cis.common.ep.localurl"])
                    elif protocol.find("rest") != -1 :
                        file_descriptor.write(fileline[i] + "\n")
                        i += 1
                        fileline[i] = fileline[i].replace("<insert-here>",rest_attr[idx+1]["cis.common.ep.localurl"])
                    elif protocol.find("vmomi") != -1 :
                        file_descriptor.write(fileline[i] + "\n")
                        i += 1
                        fileline[i] = fileline[i].replace("<insert-here>",vmomi_attr[idx+1]["cis.common.ep.localurl"])
                elif protocol != '' and fileline[i].find("com.vmware.cis.common.resourcebundle.basename") != -1:
                    if protocol.find("http") != -1 :
                        file_descriptor.write(fileline[i] + "\n")
                        i += 1
                        fileline[i] = fileline[i].replace("<insert-here>",http_attr[idx+1]["com.vmware.cis.common.resourcebundle.basename"])
                elif  fileline[i].find("com.vmware.cis.cm.GroupResourceKey") != -1:
                    file_descriptor.write(fileline[i] + "\n")
                    i += 1
                    fileline[i] = fileline[i].replace("<insert-here>",endpoint_attr[idx+1]["com.vmware.cis.cm.GroupResourceKey"])
                elif  fileline[i].find("com.vmware.cis.cm.ControlScript") != -1:
                    file_descriptor.write(fileline[i] + "\n")
                    i += 1
                    fileline[i] = fileline[i].replace("<insert-here>",endpoint_attr[idx+1]["com.vmware.cis.cm.ControlScript"])
                elif  fileline[i].find("com.vmware.cis.cm.HostId") != -1:
                    file_descriptor.write(fileline[i] + "\n")
                    i += 1
                    fileline[i] = fileline[i].replace("<insert-here>",endpoint_attr[idx+1]["com.vmware.cis.cm.HostId"])

                file_descriptor.write(fileline[i])
                file_descriptor.write("\n")
                i +=1
            fd.close()
            file_descriptor.close()
            del args[:]
            args.append("reregister")
            args.append("--spec")
            args.append(filename)
            args.append("--url")
            args.append("https://"+_SSO_URL+"/lookupservice/sdk")
            args.append("--user")
            args.append(_USER)
            args.append("--password")
            args.append(_PASSWD)
            args.append("--id")
            args.append(node_id[idx])
            output = lstooljava("com.vmware.vim.lookup.client.tool.LsTool",args[0:])
            idx +=1;
def usage() :
    print """Usage : """
    print """ python lstoolHA.py --hostname=<local-hostname-fqdn> --lb-fqdn=<load_balancer_fqdn> --lb-cert-folder=<cert-folder> --user=Administrator@vsphere.local --password=**** """
    print """"""
    print """ The user may choose not to specify the --password option. This is to prevent the Password from being displayed on the command line"""

if __name__ == "__main__":

    try :
        opts, args = getopt.getopt(sys.argv[1:],"",["hostname=","lb-fqdn=","user=","lb-cert-folder=","password="])
    except getopt.GetoptError as err:
        usage()
        sys.exit(1)

    if len(opts) == 0 :
        usage()
        sys.exit(1)

    for o,a in opts:
        if o == "--hostname":
            _SSO_URL = a
        elif o == "--lb-fqdn":
            _LB_ADDRESS = a
        elif o == "--user":
            _USER = a
        elif o == "--password":
            if a != '':
                _PASSWD = a
        elif o == "--lb-cert-folder":
            _LB_FLDR = a
        else:
            usage()
            sys.exit(1)

    if _LB_ADDRESS != '' and _SSO_URL != '' and _USER != '' and _LB_FLDR != '':

        if _PASSWD == '' :
            readPassword()
        get_lb_cert()
        get_domain()
        args = []
        args.append("get-site-id")
        args.append("--url")
        args.append("https://" +_SSO_URL + "/lookupservice/sdk")
        print args
        site_id = lstooljava("com.vmware.vim.lookup.client.tool.LsTool",args[0:])
        site_id = site_id.rstrip('\r\n')
        print site_id
        del args[:]
        args.append("list")
        args.append("--url")
        args.append("https://" +_SSO_URL + "/lookupservice/sdk")
        args.append("--type")
        args.append("cs.license")
        args.append("--site")
        args.append(site_id)
        print args
        output = lstooljava("com.vmware.vim.lookup.client.tool.LsTool",args[0:])
        #file = open("vmware_cs_license.txt","w")
        #file.write(output)
        lines = output.splitlines()
        update_license_endpoint(lines)
        del args[:]
        args.append("list")
        args.append("--url")
        args.append("https://" +_SSO_URL + "/lookupservice/sdk")
        args.append("--type")
        args.append("cs.identity")
        args.append("--site")
        args.append(site_id)

        output = lstooljava("com.vmware.vim.lookup.client.tool.LsTool",args[0:])
        # output contains the service id and the endpoint information
        #file = open("vmware_cs_identity.txt","w")
        #file.write(output)
        lines = output.splitlines()
        get_ownerId_nodeId(lines)
        del args[:]



        del args[:]
    else:
        usage()
        sys.exit(1)
